/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.ButtonContentFilter;
import bibliothek.gui.dock.action.ButtonContentFilterListener;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.AbstractBasicHandler;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import javax.swing.JComponent;

public abstract class BasicHandler<D extends StandardDockAction>
extends AbstractBasicHandler<D, BasicButtonModel>
implements BasicTrigger,
BasicTitleViewItem<JComponent> {
    private Listener listener;
    private PropertyValue<ButtonContentFilter> filter = new PropertyValue<ButtonContentFilter>(DockAction.BUTTON_CONTENT_FILTER){

        @Override
        protected void valueChanged(ButtonContentFilter oldValue, ButtonContentFilter newValue) {
            if (BasicHandler.this.isBound()) {
                if (oldValue != null) {
                    oldValue.removeListener(BasicHandler.this.filterListener);
                    oldValue.uninstall(BasicHandler.this.getDockable(), (DockAction)BasicHandler.this.getAction());
                }
                if (newValue != null) {
                    newValue.addListener(BasicHandler.this.filterListener);
                    newValue.install(BasicHandler.this.getDockable(), (DockAction)BasicHandler.this.getAction());
                }
            }
            BasicHandler.this.updateText();
        }
    };
    private ButtonContentFilterListener filterListener = new ButtonContentFilterListener(){

        @Override
        public void showTextChanged(ButtonContentFilter filter, Dockable dockable, DockAction action) {
            if (!(action != null && action != BasicHandler.this.getAction() || dockable != null && dockable != BasicHandler.this.getDockable())) {
                BasicHandler.this.updateText();
            }
        }
    };

    public BasicHandler(D action, Dockable dockable) {
        super(action, dockable);
    }

    @Override
    public JComponent getItem() {
        return ((BasicButtonModel)this.getModel()).getOwner();
    }

    @Override
    public void setBackground(Color background) {
        JComponent item = this.getItem();
        if (item != null) {
            ((Component)item).setBackground(background);
        }
    }

    @Override
    public void setForeground(Color foreground) {
        JComponent item = this.getItem();
        if (item != null) {
            ((Component)item).setForeground(foreground);
        }
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        ((BasicButtonModel)this.getModel()).setOrientation(orientation);
    }

    @Override
    public abstract void triggered();

    @Override
    public void bind() {
        if (this.listener == null) {
            this.listener = this.createListener();
        }
        this.filter.setProperties(this.getDockable().getController());
        this.updateTooltip();
        Object model = this.getModel();
        StandardDockAction action = (StandardDockAction)this.getAction();
        Dockable dockable = this.getDockable();
        for (ActionContentModifier modifier : action.getIconContexts(dockable)) {
            ((BasicButtonModel)model).setIcon(modifier, action.getIcon(dockable, modifier));
        }
        this.updateText();
        ((BasicButtonModel)model).setEnabled(action.isEnabled(dockable));
        ((BasicButtonModel)model).setDockableRepresentative(action.getDockableRepresentation(dockable));
        action.addDockActionListener(this.listener);
        super.bind();
        this.filter.getValue().addListener(this.filterListener);
        this.filter.getValue().install(this.getDockable(), (DockAction)this.getAction());
    }

    @Override
    public void unbind() {
        this.filter.getValue().removeListener(this.filterListener);
        this.filter.getValue().uninstall(this.getDockable(), (DockAction)this.getAction());
        super.unbind();
        this.filter.setProperties((DockController)null);
        ((BasicButtonModel)this.getModel()).setDockableRepresentative(null);
        ((StandardDockAction)this.getAction()).removeDockActionListener(this.listener);
    }

    protected Listener createListener() {
        return new Listener();
    }

    private void updateText() {
        Dockable dockable = this.getDockable();
        StandardDockAction action = (StandardDockAction)this.getAction();
        if (this.filter.getValue().showText(dockable, action)) {
            ((BasicButtonModel)this.getModel()).setText(action.getText(dockable));
        } else {
            ((BasicButtonModel)this.getModel()).setText(null);
        }
    }

    private void updateTooltip() {
        Dockable dockable = this.getDockable();
        StandardDockAction action = (StandardDockAction)this.getAction();
        String tooltip = action.getTooltipText(dockable);
        if (tooltip == null || tooltip.length() == 0) {
            tooltip = action.getText(dockable);
        }
        ((BasicButtonModel)this.getModel()).setToolTipText(tooltip);
    }

    protected class Listener
    implements StandardDockActionListener {
        protected Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                ((BasicButtonModel)BasicHandler.this.getModel()).setEnabled(action.isEnabled(dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction action, ActionContentModifier modifier, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                Object model = BasicHandler.this.getModel();
                if (modifier == null) {
                    ((BasicButtonModel)model).clearIcons();
                    for (ActionContentModifier index : action.getIconContexts(dockable)) {
                        ((BasicButtonModel)model).setIcon(index, action.getIcon(dockable, index));
                    }
                } else {
                    ((BasicButtonModel)model).setIcon(modifier, action.getIcon(dockable, modifier));
                }
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                BasicHandler.this.updateText();
                BasicHandler.this.updateTooltip();
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                BasicHandler.this.updateTooltip();
            }
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                ((BasicButtonModel)BasicHandler.this.getModel()).setDockableRepresentative(action.getDockableRepresentation(dockable));
            }
        }
    }
}

