/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.component;

import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentManager;
import bibliothek.gui.dock.component.DockComponentRoot;
import bibliothek.util.Filter;
import bibliothek.util.container.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultDockComponentManager
implements DockComponentManager {
    private DockComponentConfiguration defaultConfiguration;
    private List<Tuple<Filter<DockComponentRoot>, DockComponentConfiguration>> configurations = new ArrayList<Tuple<Filter<DockComponentRoot>, DockComponentConfiguration>>();
    private Map<DockComponentRoot, Handle> roots = new HashMap<DockComponentRoot, Handle>();

    @Override
    public void setDefaultConfiguration(DockComponentConfiguration configuration) {
        this.defaultConfiguration = configuration;
        this.reconfigure();
    }

    @Override
    public void addConfiguration(Filter<DockComponentRoot> filter, DockComponentConfiguration configuration) {
        this.configurations.add(Tuple.of(filter, configuration));
        this.reconfigure();
    }

    @Override
    public void removeConfiguration(DockComponentConfiguration configuration) {
        Iterator<Tuple<Filter<DockComponentRoot>, DockComponentConfiguration>> iterator = this.configurations.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getB() != configuration) continue;
            iterator.remove();
            this.reconfigure();
            return;
        }
    }

    private void reconfigure() {
        for (Handle handle : this.roots.values()) {
            handle.reconfigure();
        }
    }

    @Override
    public void register(DockComponentRoot root) {
        if (!this.roots.containsKey(root)) {
            Handle handle = new Handle(root);
            this.roots.put(root, handle);
            handle.reconfigure();
        }
    }

    @Override
    public void unregister(DockComponentRoot root) {
        Handle handle = this.roots.remove(root);
        if (handle != null) {
            handle.destroy();
        }
    }

    private DockComponentConfiguration getConfigurationFor(DockComponentRoot root) {
        for (Tuple<Filter<DockComponentRoot>, DockComponentConfiguration> config : this.configurations) {
            if (!((Filter)config.getA()).includes(root)) continue;
            return config.getB();
        }
        return this.defaultConfiguration;
    }

    private class Handle {
        private DockComponentRoot root;

        public Handle(DockComponentRoot root) {
            this.root = root;
        }

        public void reconfigure() {
            DockComponentConfiguration configuration;
            DockComponentConfiguration preferred = DefaultDockComponentManager.this.getConfigurationFor(this.root);
            if (preferred != (configuration = this.root.getComponentConfiguration())) {
                this.root.setComponentConfiguration(preferred);
            }
        }

        public void destroy() {
            this.root.setComponentConfiguration(null);
        }
    }
}

