/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import java.util.concurrent.ThreadLocalRandom;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.ErrorFunction;
import org.ojalgo.random.Normal;
import org.ojalgo.random.process.Process1D;
import org.ojalgo.random.process.SingleValueBasedProcess;
import org.ojalgo.random.scedasticity.ARCH;
import org.ojalgo.random.scedasticity.GARCH;
import org.ojalgo.random.scedasticity.ScedasticityModel;
import org.ojalgo.structure.Access1D;

public final class StationaryNormalProcess
extends SingleValueBasedProcess<Normal>
implements Process1D.ComponentProcess<Normal> {
    private final ScedasticityModel myScedasticityModel;

    public static StationaryNormalProcess estimateARCH(Access1D<?> series, int q) {
        return new StationaryNormalProcess(ARCH.estimate(series, q));
    }

    public static StationaryNormalProcess estimateGARCH(Access1D<?> series, int p, int q) {
        return new StationaryNormalProcess(GARCH.estimate(series, p, q));
    }

    public static StationaryNormalProcess of(ScedasticityModel scedasticityModel) {
        return new StationaryNormalProcess(scedasticityModel);
    }

    StationaryNormalProcess(ScedasticityModel scedasticityModel) {
        this.myScedasticityModel = scedasticityModel;
    }

    @Override
    public Normal getDistribution(double evaluationPoint) {
        return Normal.of(this.getExpected(evaluationPoint), this.getStandardDeviation(evaluationPoint));
    }

    @Override
    public double getValue() {
        return this.getCurrentValue();
    }

    @Override
    public void setValue(double newValue) {
        this.setCurrentValue(newValue);
        this.myScedasticityModel.update(newValue);
    }

    public double step() {
        return this.step(PrimitiveMath.ONE);
    }

    @Override
    public double step(double stepSize, double standardGaussianInnovation) {
        return this.doStep(stepSize, standardGaussianInnovation);
    }

    @Override
    double doStep(double stepSize, double normalisedRandomIncrement) {
        double stdDev = this.getStandardDeviation(stepSize);
        double error = stdDev * normalisedRandomIncrement;
        double retVal = this.getExpected(stepSize) + error;
        this.setValue(retVal);
        return retVal;
    }

    @Override
    double getExpected(double stepSize) {
        return this.myScedasticityModel.getMean();
    }

    @Override
    double getLowerConfidenceQuantile(double stepSize, double confidence) {
        return this.getExpected(stepSize) - this.getStandardDeviation(stepSize) * PrimitiveMath.SQRT_TWO * ErrorFunction.erfi(confidence);
    }

    @Override
    double getNormalisedRandomIncrement() {
        return ThreadLocalRandom.current().nextGaussian();
    }

    @Override
    double getStandardDeviation(double stepSize) {
        return PrimitiveMath.SQRT.invoke(this.getVariance(stepSize));
    }

    @Override
    double getUpperConfidenceQuantile(double stepSize, double confidence) {
        return this.getExpected(stepSize) + this.getStandardDeviation(stepSize) * PrimitiveMath.SQRT_TWO * ErrorFunction.erfi(confidence);
    }

    @Override
    double getVariance(double stepSize) {
        return stepSize * this.myScedasticityModel.getVariance();
    }
}

