/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.verification;

import java.util.List;

public class DataRange
implements Cloneable {
    private Double minThreshold = null;
    private Double maxThreshold = null;
    private boolean minEqual = true;
    private boolean maxEqual = true;
    private boolean minMax = true;
    private List<Number> values = null;

    public DataRange() {
    }

    public DataRange(Double min, Double max) {
        this.minThreshold = min;
        this.maxThreshold = max;
    }

    public DataRange(Double min, Double max, boolean minEqual, boolean maxEqual) {
        this.minThreshold = min;
        this.maxThreshold = max;
        this.minEqual = minEqual;
        this.maxEqual = maxEqual;
    }

    public DataRange(List<Number> values) {
        this.values = values;
        this.minMax = false;
    }

    public boolean isSingleThreshold() {
        return this.minThreshold == null || this.maxThreshold == null;
    }

    public Double getMinThreshold() {
        return this.minThreshold;
    }

    public void setMinThreshold(Double value) {
        this.minThreshold = value;
        this.minMax = true;
    }

    public Double getMaxThreshold() {
        return this.maxThreshold;
    }

    public void setMaxThreshold(Double value) {
        this.maxThreshold = value;
        this.minMax = true;
    }

    public boolean isMinEqual() {
        return this.minEqual;
    }

    public void setMinEqual(boolean value) {
        this.minEqual = value;
    }

    public boolean isMaxEqual() {
        return this.maxEqual;
    }

    public void setMaxEqual(boolean value) {
        this.maxEqual = value;
    }

    public boolean isMinMax() {
        return this.minMax;
    }

    public void setMinMax(boolean value) {
        this.minMax = value;
    }

    public List<Number> getValues() {
        return this.values;
    }

    public void setValues(List<Number> value) {
        this.values = value;
        this.minMax = false;
    }

    public boolean isValueIn(double value) {
        boolean valueIn = false;
        if (this.minMax) {
            if (this.minThreshold == null) {
                if (value < this.maxThreshold) {
                    valueIn = true;
                } else if (this.maxEqual && value == this.maxThreshold) {
                    valueIn = true;
                }
            } else if (this.maxThreshold == null) {
                if (value > this.minThreshold) {
                    valueIn = true;
                } else if (this.minEqual && value == this.minThreshold) {
                    valueIn = true;
                }
            } else if (value > this.minThreshold && value < this.maxThreshold) {
                valueIn = true;
            } else {
                if (this.minEqual && value == this.minThreshold) {
                    valueIn = true;
                }
                if (this.maxEqual && value == this.maxThreshold) {
                    valueIn = true;
                }
            }
        } else {
            valueIn = this.values.contains(value);
        }
        return valueIn;
    }

    public String toString() {
        String str = null;
        if (this.minMax) {
            str = this.maxThreshold == null ? ">" + String.valueOf(this.minThreshold) : (this.minThreshold == null ? "<" + String.valueOf(this.maxThreshold) : String.valueOf(this.minThreshold) + "-" + String.valueOf(this.maxThreshold));
        } else {
            str = "in";
            for (Number v : this.values) {
                str = str + " " + v.toString();
            }
        }
        return str;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

