/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.forms;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteothink.imep.forms.FrmAbout;
import org.meteothink.imep.forms.FrmDataset;
import org.meteothink.imep.forms.FrmMethod;
import org.meteothink.imep.forms.FrmTimes;
import org.meteothink.imep.global.GenericFileFilter;
import org.meteothink.imep.global.Globals;
import org.meteothink.imep.global.Options;
import org.meteothink.imep.verification.StatType;
import org.meteothink.imep.verification.VerifyCase;
import org.meteothink.imep.verification.VerifyGroup;
import org.xml.sax.SAXException;

public class FrmMain
extends JFrame {
    private Options _options = new Options();
    private VerifyCase _verifyCase;
    private VerifyGroup _currentGroup;
    private String _verifyFileName = "";
    private ButtonGroup buttonGroup1;
    private JButton jButton_AddGroup;
    private JButton jButton_DeleteGroup;
    private JButton jButton_FcstDataset;
    private JButton jButton_FilterFile;
    private JButton jButton_LoadVerifyCase;
    private JButton jButton_MaskFile;
    private JButton jButton_Method;
    private JButton jButton_NewVerifyCase;
    private JButton jButton_ObsDataset;
    private JButton jButton_OutPath;
    private JButton jButton_RegionFile;
    private JButton jButton_Run;
    private JButton jButton_SaveGroup;
    private JButton jButton_SaveVerifyCase;
    private JButton jButton_Times;
    private JComboBox jComboBox_StatType;
    private JComboBox jComboBox_TimeZone;
    private JLabel jLabel9;
    private JLabel jLabel_GroupName;
    private JLabel jLabel_Groups;
    private JLabel jLabel_MaskFile;
    private JLabel jLabel_MaskFile1;
    private JLabel jLabel_OutPath;
    private JLabel jLabel_RegionFile;
    private JLabel jLabel_StatType;
    private JLabel jLabel_TimeZone;
    private JList jList_Groups;
    private JMenuBar jMenuBar_Main;
    private JMenuItem jMenuItem_About;
    private JMenuItem jMenuItem_Exit;
    private JMenuItem jMenuItem_Help;
    private JMenuItem jMenuItem_Map;
    private JMenuItem jMenuItem_NewCase;
    private JMenuItem jMenuItem_OpenCase;
    private JMenuItem jMenuItem_SaveAs;
    private JMenuItem jMenuItem_SaveCase;
    private JMenuItem jMenuItem_Script;
    private JMenu jMenu_Help;
    private JMenu jMenu_Tools;
    private JMenu jMenu_VerifyCase;
    private JMenu jMenu_View;
    private JPanel jPanel_GroupSetting;
    private JProgressBar jProgressBar_Main;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JTextField jTextField_FilterFile;
    private JTextField jTextField_GroupName;
    private JTextField jTextField_MaskFile;
    private JTextField jTextField_OutPath;
    private JTextField jTextField_RegionFile;
    private JToolBar jToolBar_Main;
    private JToolBar jToolBar_Status;

    public FrmMain() {
        this.initComponents();
        this.jMenu_View.setVisible(false);
        this.jMenu_Tools.setVisible(false);
        this.jMenuItem_Help.setVisible(false);
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/check_24.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setIconImage(image);
        this.jProgressBar_Main.setVisible(false);
        this.loadConfigureFile();
        this.jList_Groups.setModel(new DefaultListModel());
        this.jComboBox_StatType.removeAllItems();
        this.jComboBox_StatType.addItem(StatType.GridStat);
        this.jComboBox_StatType.addItem(StatType.StationStat);
        this.jComboBox_TimeZone.removeAllItems();
        for (int i = -12; i <= 12; ++i) {
            this.jComboBox_TimeZone.addItem(Globals.getTimeZoneString(i));
        }
        this.jLabel_Groups.setVisible(false);
        this.jList_Groups.setVisible(false);
        this.jPanel_GroupSetting.setVisible(false);
        this.jButton_SaveVerifyCase.setEnabled(false);
        this.jButton_AddGroup.setEnabled(false);
        this.jButton_DeleteGroup.setEnabled(false);
        this.jButton_SaveGroup.setEnabled(false);
        this.jButton_Run.setEnabled(false);
    }

    public final void loadConfigureFile() {
        String fn = GlobalUtil.getAppPath(FrmMain.class);
        if (new File(fn = fn + File.separator + "config.xml").exists()) {
            try {
                this._options.loadConfigFile(fn);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public final void saveConfigureFile() {
        String fn = this._options.getFileName();
        try {
            this._options.saveConfigFile(fn);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jList_Groups = new JList();
        this.jLabel_Groups = new JLabel();
        this.jPanel_GroupSetting = new JPanel();
        this.jLabel_GroupName = new JLabel();
        this.jTextField_GroupName = new JTextField();
        this.jComboBox_StatType = new JComboBox();
        this.jLabel_StatType = new JLabel();
        this.jLabel_TimeZone = new JLabel();
        this.jLabel_OutPath = new JLabel();
        this.jTextField_OutPath = new JTextField();
        this.jLabel_MaskFile = new JLabel();
        this.jTextField_MaskFile = new JTextField();
        this.jLabel_RegionFile = new JLabel();
        this.jTextField_RegionFile = new JTextField();
        this.jButton_OutPath = new JButton();
        this.jButton_MaskFile = new JButton();
        this.jButton_RegionFile = new JButton();
        this.jComboBox_TimeZone = new JComboBox();
        this.jButton_ObsDataset = new JButton();
        this.jButton_FcstDataset = new JButton();
        this.jButton_Times = new JButton();
        this.jButton_Method = new JButton();
        this.jLabel_MaskFile1 = new JLabel();
        this.jTextField_FilterFile = new JTextField();
        this.jButton_FilterFile = new JButton();
        this.jToolBar_Main = new JToolBar();
        this.jButton_NewVerifyCase = new JButton();
        this.jButton_LoadVerifyCase = new JButton();
        this.jButton_SaveVerifyCase = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButton_AddGroup = new JButton();
        this.jButton_DeleteGroup = new JButton();
        this.jButton_SaveGroup = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_Run = new JButton();
        this.jToolBar_Status = new JToolBar();
        this.jProgressBar_Main = new JProgressBar();
        this.jLabel9 = new JLabel();
        this.jMenuBar_Main = new JMenuBar();
        this.jMenu_VerifyCase = new JMenu();
        this.jMenuItem_NewCase = new JMenuItem();
        this.jMenuItem_OpenCase = new JMenuItem();
        this.jMenuItem_SaveCase = new JMenuItem();
        this.jMenuItem_SaveAs = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem_Exit = new JMenuItem();
        this.jMenu_View = new JMenu();
        this.jMenuItem_Map = new JMenuItem();
        this.jMenu_Tools = new JMenu();
        this.jMenuItem_Script = new JMenuItem();
        this.jMenu_Help = new JMenu();
        this.jMenuItem_About = new JMenuItem();
        this.jMenuItem_Help = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("IMEP");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrmMain.this.formWindowClosing(evt);
            }
        });
        this.jList_Groups.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList_Groups.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmMain.this.jList_GroupsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList_Groups);
        this.jLabel_Groups.setText("Groups:");
        this.jPanel_GroupSetting.setBorder(BorderFactory.createTitledBorder("Group Setting"));
        this.jLabel_GroupName.setText("Name:");
        this.jComboBox_StatType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel_StatType.setText("StatType:");
        this.jLabel_TimeZone.setText("TimeZone:");
        this.jLabel_OutPath.setText("OutPath:");
        this.jLabel_MaskFile.setText("MaskFile:");
        this.jLabel_RegionFile.setText("RegionFile:");
        this.jButton_OutPath.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-open.svg"));
        this.jButton_OutPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_OutPathActionPerformed(evt);
            }
        });
        this.jButton_MaskFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-open.svg"));
        this.jButton_MaskFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_MaskFileActionPerformed(evt);
            }
        });
        this.jButton_RegionFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-open.svg"));
        this.jButton_RegionFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_RegionFileActionPerformed(evt);
            }
        });
        this.jComboBox_TimeZone.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButton_ObsDataset.setText("Observation Dataset");
        this.jButton_ObsDataset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_ObsDatasetActionPerformed(evt);
            }
        });
        this.jButton_FcstDataset.setText("Forecast Dataset");
        this.jButton_FcstDataset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_FcstDatasetActionPerformed(evt);
            }
        });
        this.jButton_Times.setText("Times");
        this.jButton_Times.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_TimesActionPerformed(evt);
            }
        });
        this.jButton_Method.setText("Method");
        this.jButton_Method.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_MethodActionPerformed(evt);
            }
        });
        this.jLabel_MaskFile1.setText("FilterFile:");
        this.jButton_FilterFile.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-open.svg"));
        this.jButton_FilterFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_FilterFileActionPerformed(evt);
            }
        });
        GroupLayout jPanel_GroupSettingLayout = new GroupLayout(this.jPanel_GroupSetting);
        this.jPanel_GroupSetting.setLayout(jPanel_GroupSettingLayout);
        jPanel_GroupSettingLayout.setHorizontalGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GroupSettingLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_OutPath, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_MaskFile1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_MaskFile, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_RegionFile, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_RegionFile).addComponent(this.jTextField_MaskFile, -2, 340, -2).addComponent(this.jTextField_FilterFile).addComponent(this.jTextField_OutPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_OutPath).addComponent(this.jButton_MaskFile).addComponent(this.jButton_RegionFile)).addComponent(this.jButton_FilterFile, GroupLayout.Alignment.TRAILING)).addContainerGap()).addGroup(jPanel_GroupSettingLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_GroupName).addComponent(this.jLabel_StatType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField_GroupName).addComponent(this.jComboBox_StatType, 0, 156, Short.MAX_VALUE)).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GroupSettingLayout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jLabel_TimeZone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_TimeZone, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel_GroupSettingLayout.createSequentialGroup().addGap(159, 159, 159).addComponent(this.jButton_Method))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel_GroupSettingLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jButton_ObsDataset).addGap(18, 18, 18).addComponent(this.jButton_FcstDataset).addGap(18, 18, 18).addComponent(this.jButton_Times, -1, -1, Short.MAX_VALUE).addGap(44, 44, 44)));
        jPanel_GroupSettingLayout.setVerticalGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_GroupSettingLayout.createSequentialGroup().addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_GroupName).addComponent(this.jTextField_GroupName, -2, -1, -2).addComponent(this.jButton_Method)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox_StatType, -2, -1, -2).addComponent(this.jLabel_StatType).addComponent(this.jComboBox_TimeZone, -2, -1, -2).addComponent(this.jLabel_TimeZone)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_OutPath).addComponent(this.jTextField_OutPath, -2, -1, -2)).addComponent(this.jButton_OutPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_MaskFile1).addComponent(this.jTextField_FilterFile, -2, -1, -2)).addComponent(this.jButton_FilterFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_MaskFile).addComponent(this.jTextField_MaskFile, -2, -1, -2)).addComponent(this.jButton_MaskFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_RegionFile).addComponent(this.jTextField_RegionFile, -2, -1, -2)).addComponent(this.jButton_RegionFile)).addGap(18, 18, 18).addGroup(jPanel_GroupSettingLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_ObsDataset).addComponent(this.jButton_FcstDataset).addComponent(this.jButton_Times)).addContainerGap()));
        this.jToolBar_Main.setBorder(null);
        this.jToolBar_Main.setFloatable(false);
        this.jToolBar_Main.setRollover(true);
        ClassLoader classLoader = FrmMain.class.getClassLoader();
        this.jButton_NewVerifyCase.setIcon((Icon)new FlatSVGIcon("org/meteothink/imep/icons/file-new.svg", classLoader));
        this.jButton_NewVerifyCase.setToolTipText("New Verify Case");
        this.jButton_NewVerifyCase.setFocusable(false);
        this.jButton_NewVerifyCase.setHorizontalTextPosition(0);
        this.jButton_NewVerifyCase.setVerticalTextPosition(3);
        this.jButton_NewVerifyCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_NewVerifyCaseActionPerformed(evt);
            }
        });
        this.jToolBar_Main.add(this.jButton_NewVerifyCase);
        this.jButton_LoadVerifyCase.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-open.svg"));
        this.jButton_LoadVerifyCase.setToolTipText("Open Verify Case");
        this.jButton_LoadVerifyCase.setFocusable(false);
        this.jButton_LoadVerifyCase.setHorizontalTextPosition(0);
        this.jButton_LoadVerifyCase.setVerticalTextPosition(3);
        this.jButton_LoadVerifyCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_LoadVerifyCaseActionPerformed(evt);
            }
        });
        this.jToolBar_Main.add(this.jButton_LoadVerifyCase);
        this.jButton_SaveVerifyCase.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-save.svg"));
        this.jButton_SaveVerifyCase.setToolTipText("Save Verify Case");
        this.jButton_SaveVerifyCase.setFocusable(false);
        this.jButton_SaveVerifyCase.setHorizontalTextPosition(0);
        this.jButton_SaveVerifyCase.setVerticalTextPosition(3);
        this.jButton_SaveVerifyCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_SaveVerifyCaseActionPerformed(evt);
            }
        });
        this.jToolBar_Main.add(this.jButton_SaveVerifyCase);
        this.jToolBar_Main.add(this.jSeparator3);
        this.jButton_AddGroup.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/add.svg"));
        this.jButton_AddGroup.setToolTipText("Add Group");
        this.jButton_AddGroup.setFocusable(false);
        this.jButton_AddGroup.setHorizontalTextPosition(0);
        this.jButton_AddGroup.setVerticalTextPosition(3);
        this.jButton_AddGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_AddGroupActionPerformed(evt);
            }
        });
        this.jToolBar_Main.add(this.jButton_AddGroup);
        this.jButton_DeleteGroup.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/remove.svg"));
        this.jButton_DeleteGroup.setToolTipText("Delete Group");
        this.jButton_DeleteGroup.setFocusable(false);
        this.jButton_DeleteGroup.setHorizontalTextPosition(0);
        this.jButton_DeleteGroup.setVerticalTextPosition(3);
        this.jButton_DeleteGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_DeleteGroupActionPerformed(evt);
            }
        });
        this.jToolBar_Main.add(this.jButton_DeleteGroup);
        this.jButton_SaveGroup.setIcon((Icon)new FlatSVGIcon("org/meteothink/imep/icons/save-as.svg", classLoader));
        this.jButton_SaveGroup.setToolTipText("Save Group");
        this.jButton_SaveGroup.setFocusable(false);
        this.jButton_SaveGroup.setHorizontalTextPosition(0);
        this.jButton_SaveGroup.setVerticalTextPosition(3);
        this.jButton_SaveGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_SaveGroupActionPerformed(evt);
            }
        });
        this.jToolBar_Main.add(this.jButton_SaveGroup);
        this.jToolBar_Main.add(this.jSeparator2);
        this.jButton_Run.setIcon((Icon)new FlatSVGIcon("org/meteothink/imep/icons/execute.svg", classLoader));
        this.jButton_Run.setToolTipText("Run Verification");
        this.jButton_Run.setFocusable(false);
        this.jButton_Run.setHorizontalTextPosition(0);
        this.jButton_Run.setVerticalTextPosition(3);
        this.jButton_Run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_RunActionPerformed(evt);
            }
        });
        this.jToolBar_Main.add(this.jButton_Run);
        this.jToolBar_Status.setFloatable(false);
        this.jToolBar_Status.setRollover(true);
        this.jProgressBar_Main.setAlignmentX(0.0f);
        this.jProgressBar_Main.setMaximumSize(new Dimension(Short.MAX_VALUE, 18));
        this.jProgressBar_Main.setPreferredSize(new Dimension(100, 18));
        this.jProgressBar_Main.setSize(new Dimension(100, 18));
        this.jToolBar_Status.add(this.jProgressBar_Main);
        this.jLabel9.setText("                                            ");
        this.jToolBar_Status.add(this.jLabel9);
        this.jMenu_VerifyCase.setText("Case");
        this.jMenuItem_NewCase.setIcon((Icon)new FlatSVGIcon("org/meteothink/imep/icons/file-new.svg", classLoader));
        this.jMenuItem_NewCase.setText("New Case");
        this.jMenuItem_NewCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_NewCaseActionPerformed(evt);
            }
        });
        this.jMenu_VerifyCase.add(this.jMenuItem_NewCase);
        this.jMenuItem_OpenCase.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-open.svg"));
        this.jMenuItem_OpenCase.setText("Open Case");
        this.jMenuItem_OpenCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_OpenCaseActionPerformed(evt);
            }
        });
        this.jMenu_VerifyCase.add(this.jMenuItem_OpenCase);
        this.jMenuItem_SaveCase.setIcon((Icon)new FlatSVGIcon("org/meteoinfo/icons/file-save.svg"));
        this.jMenuItem_SaveCase.setText("Save Case");
        this.jMenuItem_SaveCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_SaveCaseActionPerformed(evt);
            }
        });
        this.jMenu_VerifyCase.add(this.jMenuItem_SaveCase);
        this.jMenuItem_SaveAs.setText("Save As");
        this.jMenuItem_SaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_SaveAsActionPerformed(evt);
            }
        });
        this.jMenu_VerifyCase.add(this.jMenuItem_SaveAs);
        this.jMenu_VerifyCase.add(this.jSeparator4);
        this.jMenuItem_Exit.setText("Exit");
        this.jMenuItem_Exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_ExitActionPerformed(evt);
            }
        });
        this.jMenu_VerifyCase.add(this.jMenuItem_Exit);
        this.jMenuBar_Main.add(this.jMenu_VerifyCase);
        this.jMenu_View.setText("View");
        this.jMenuItem_Map.setText("Map");
        this.jMenuItem_Map.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_MapActionPerformed(evt);
            }
        });
        this.jMenu_View.add(this.jMenuItem_Map);
        this.jMenuBar_Main.add(this.jMenu_View);
        this.jMenu_Tools.setText("Tools");
        this.jMenuItem_Script.setText("Script");
        this.jMenuItem_Script.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_ScriptActionPerformed(evt);
            }
        });
        this.jMenu_Tools.add(this.jMenuItem_Script);
        this.jMenuBar_Main.add(this.jMenu_Tools);
        this.jMenu_Help.setText("Help");
        this.jMenuItem_About.setText("About");
        this.jMenuItem_About.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_AboutActionPerformed(evt);
            }
        });
        this.jMenu_Help.add(this.jMenuItem_About);
        this.jMenuItem_Help.setText("Help");
        this.jMenu_Help.add(this.jMenuItem_Help);
        this.jMenuBar_Main.add(this.jMenu_Help);
        this.setJMenuBar(this.jMenuBar_Main);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_Groups).addComponent(this.jScrollPane1, -1, 165, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel_GroupSetting, -1, -1, Short.MAX_VALUE)).addComponent(this.jToolBar_Main, -1, -1, Short.MAX_VALUE).addComponent(this.jToolBar_Status, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar_Main, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel_Groups).addGap(9, 9, 9).addComponent(this.jScrollPane1)).addComponent(this.jPanel_GroupSetting, -1, -1, Short.MAX_VALUE)).addGap(4, 4, 4).addComponent(this.jToolBar_Status, -2, 25, -2)));
        this.pack();
    }

    public Options getOptions() {
        return this._options;
    }

    private void jMenuItem_MapActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem_AboutActionPerformed(ActionEvent evt) {
        FrmAbout frmAbout = new FrmAbout((Frame)this, false);
        frmAbout.setLocationRelativeTo(this);
        frmAbout.setVisible(true);
    }

    private void jMenuItem_ScriptActionPerformed(ActionEvent evt) {
    }

    private void jButton_AddGroupActionPerformed(ActionEvent evt) {
        String name = JOptionPane.showInputDialog("Group Name", (Object)"New Group");
        VerifyGroup group = new VerifyGroup(name);
        this.addGroup(group);
    }

    private void addGroup(VerifyGroup group) {
        this._verifyCase.addVerifyGroup(group);
        ((DefaultListModel)this.jList_Groups.getModel()).addElement(group.getName());
        this.jList_Groups.setSelectedIndex(this.jList_Groups.getModel().getSize() - 1);
        this._currentGroup = group;
        this.updateContorls(group);
    }

    private void jButton_DeleteGroupActionPerformed(ActionEvent evt) {
        if (this._verifyCase.getVerifyGroups().size() == 1) {
            JOptionPane.showMessageDialog(null, "There is at least one group!");
        } else {
            int result = JOptionPane.showConfirmDialog(null, "Do your really want to remove this group? " + this._currentGroup.getName(), "Conform remove group", 0);
            if (result == 0) {
                this._verifyCase.removeVerifyGroup(this._currentGroup);
                ((DefaultListModel)this.jList_Groups.getModel()).removeElement(this._currentGroup.getName());
                this.jList_Groups.setSelectedIndex(this.jList_Groups.getModel().getSize() - 1);
                this._currentGroup = this._verifyCase.getVerifyGroups().get(this.jList_Groups.getSelectedIndex());
                this.updateContorls(this._currentGroup);
            }
        }
    }

    private void jButton_SaveGroupActionPerformed(ActionEvent evt) {
        this.saveCurrentGroup();
    }

    private void jButton_SaveVerifyCaseActionPerformed(ActionEvent evt) {
        this.saveVerifyCase();
    }

    private void saveCurrentGroup() {
        if (this._currentGroup != null) {
            String name = this.jTextField_GroupName.getText();
            this._currentGroup.setName(name);
            DefaultListModel listModel = (DefaultListModel)this.jList_Groups.getModel();
            listModel.set(this._verifyCase.getVerifyGroups().indexOf(this._currentGroup), name);
            this._currentGroup.setStatType(StatType.valueOf(this.jComboBox_StatType.getSelectedItem().toString()));
            this._currentGroup.setTimeZone(Globals.getTimeZone(this.jComboBox_TimeZone.getSelectedItem().toString()));
            this._currentGroup.setOutFilePath(this.jTextField_OutPath.getText());
            this._currentGroup.setDataMaskFile(this.jTextField_MaskFile.getText());
            this._currentGroup.setStatRegionFile(this.jTextField_RegionFile.getText());
        }
    }

    private void saveVerifyCase() {
        this.saveCurrentGroup();
        if (this._verifyFileName.isEmpty()) {
            JFileChooser aDlg = new JFileChooser();
            String[] fileExts = new String[]{"vrf"};
            GenericFileFilter fileFilter = new GenericFileFilter(fileExts, "Verification File (*.vrf)");
            aDlg.setFileFilter(fileFilter);
            File dir = new File(System.getProperty("user.dir"));
            if (dir.isDirectory()) {
                aDlg.setCurrentDirectory(dir);
            }
            if (aDlg.showSaveDialog(this) == 0) {
                File file = aDlg.getSelectedFile();
                System.setProperty("user.dir", file.getParent());
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                String fileName = file.getAbsolutePath();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                try {
                    this._verifyCase.exportToXMLFile(fileName);
                }
                catch (ParserConfigurationException ex) {
                    Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            try {
                this._verifyCase.exportToXMLFile(this._verifyFileName);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jButton_RunActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.saveCurrentGroup();
        this._verifyCase.run();
        this.setCursor(Cursor.getDefaultCursor());
        JOptionPane.showMessageDialog(null, "Finished!");
    }

    private void jButton_LoadVerifyCaseActionPerformed(ActionEvent evt) {
        this.loadVerifyCase();
    }

    private void loadVerifyCase() {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"vrf"};
        GenericFileFilter verifyFileFilter = new GenericFileFilter(fileExts, "Verify file");
        aDlg.setFileFilter(verifyFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            VerifyCase verifyCase = new VerifyCase("Temp");
            try {
                verifyCase.importFromXMLFile(aFile.getAbsolutePath());
                this._verifyFileName = aFile.getAbsolutePath();
                this.setVerifyCase(verifyCase);
                this.setTitle("IMEP - " + aFile.getName());
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void updateContorls(VerifyGroup group) {
        this.jTextField_GroupName.setText(group.getName());
        this.jComboBox_StatType.setSelectedItem((Object)group.getStatType());
        this.jComboBox_TimeZone.setSelectedItem(Globals.getTimeZoneString(group.getTimeZone()));
        this.jTextField_OutPath.setText(group.getOutFilePath());
        this.jTextField_MaskFile.setText(group.getDataMaskFile());
        this.jTextField_RegionFile.setText(group.getStatRegionFile());
    }

    private void formWindowClosing(WindowEvent evt) {
        this.saveConfigureFile();
    }

    private void jButton_NewVerifyCaseActionPerformed(ActionEvent evt) {
        this._verifyFileName = "";
        VerifyCase verifyCase = new VerifyCase("New Case");
        VerifyGroup group = new VerifyGroup("New Group");
        verifyCase.addVerifyGroup(group);
        this.setVerifyCase(verifyCase);
    }

    private void jButton_OutPathActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        aDlg.setFileSelectionMode(1);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            this.jTextField_OutPath.setText(aFile.getAbsolutePath());
        }
    }

    private void jButton_MaskFileActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"shp"};
        GenericFileFilter verifyFileFilter = new GenericFileFilter(fileExts, "Shape file");
        aDlg.setFileFilter(verifyFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            this.jTextField_MaskFile.setText(aFile.getAbsolutePath());
        }
    }

    private void jButton_RegionFileActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"shp"};
        GenericFileFilter verifyFileFilter = new GenericFileFilter(fileExts, "Shape file");
        aDlg.setFileFilter(verifyFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            this.jTextField_RegionFile.setText(aFile.getAbsolutePath());
        }
    }

    private void jButton_ObsDatasetActionPerformed(ActionEvent evt) {
        FrmDataset frmDataset = new FrmDataset((Frame)this, true);
        frmDataset.setTitle("Observation Dataset");
        frmDataset.setDataset(this._currentGroup.getObsDataset());
        frmDataset.setLocationRelativeTo(this);
        frmDataset.setVisible(true);
    }

    private void jButton_FcstDatasetActionPerformed(ActionEvent evt) {
        FrmDataset frmDataset = new FrmDataset((Frame)this, true);
        frmDataset.setTitle("Forecast Dataset");
        frmDataset.setDataset(this._currentGroup.getFcstDataset());
        frmDataset.setLocationRelativeTo(this);
        frmDataset.setVisible(true);
    }

    private void jButton_TimesActionPerformed(ActionEvent evt) {
        FrmTimes frmTimes = new FrmTimes((Frame)this, true);
        frmTimes.setVerifyGroup(this._currentGroup);
        frmTimes.setLocationRelativeTo(this);
        frmTimes.setVisible(true);
    }

    private void jButton_MethodActionPerformed(ActionEvent evt) {
        FrmMethod frmMethod = new FrmMethod((Frame)this, true);
        frmMethod.setVerifyGroup(this._currentGroup);
        frmMethod.setLocationRelativeTo(this);
        frmMethod.setVisible(true);
    }

    private void jMenuItem_NewCaseActionPerformed(ActionEvent evt) {
        this._verifyFileName = "";
        VerifyCase verifyCase = new VerifyCase("New Case");
        VerifyGroup group = new VerifyGroup("New Group");
        verifyCase.addVerifyGroup(group);
        this.setVerifyCase(verifyCase);
    }

    private void jMenuItem_OpenCaseActionPerformed(ActionEvent evt) {
        this.loadVerifyCase();
    }

    private void jMenuItem_SaveCaseActionPerformed(ActionEvent evt) {
        this.saveVerifyCase();
    }

    private void jMenuItem_SaveAsActionPerformed(ActionEvent evt) {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"vrf"};
        GenericFileFilter fileFilter = new GenericFileFilter(fileExts, "Verification File (*.vrf)");
        aDlg.setFileFilter(fileFilter);
        File dir = new File(System.getProperty("user.dir"));
        if (dir.isDirectory()) {
            aDlg.setCurrentDirectory(dir);
        }
        if (aDlg.showSaveDialog(this) == 0) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = file.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            try {
                this._verifyCase.exportToXMLFile(fileName);
                this._verifyFileName = fileName;
                this.setTitle("IMEP - " + file.getName());
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jMenuItem_ExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jList_GroupsMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            int idx = this.jList_Groups.getSelectedIndex();
            if (idx >= 0) {
                this.saveCurrentGroup();
                this._currentGroup = this._verifyCase.getVerifyGroups().get(idx);
                this.updateContorls(this._currentGroup);
            }
        } else if (evt.getButton() == 3) {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem copyGroupMI = new JMenuItem("Copy Group");
            copyGroupMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrmMain.this.onCopyGroupClick(e);
                }
            });
            popupMenu.add(copyGroupMI);
            popupMenu.show(this.jList_Groups, evt.getX(), evt.getY());
        }
    }

    private void jButton_FilterFileActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"txt"};
        GenericFileFilter verifyFileFilter = new GenericFileFilter(fileExts, "Text file");
        aDlg.setFileFilter(verifyFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            this.jTextField_FilterFile.setText(aFile.getAbsolutePath());
        }
    }

    private void onCopyGroupClick(ActionEvent e) {
        int idx = this.jList_Groups.getSelectedIndex();
        if (idx >= 0) {
            try {
                this.saveCurrentGroup();
                VerifyGroup group = this._verifyCase.getVerifyGroups().get(idx);
                VerifyGroup newGroup = (VerifyGroup)group.clone();
                newGroup.setName(group.getName() + "_Copy");
                this.addGroup(newGroup);
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void setVerifyCase(VerifyCase verifyCase) {
        this.jLabel_Groups.setVisible(true);
        this.jList_Groups.setVisible(true);
        this.jPanel_GroupSetting.setVisible(true);
        this.jButton_SaveVerifyCase.setEnabled(true);
        this.jButton_AddGroup.setEnabled(true);
        this.jButton_DeleteGroup.setEnabled(true);
        this.jButton_SaveGroup.setEnabled(true);
        this.jButton_Run.setEnabled(true);
        DefaultListModel listModel = (DefaultListModel)this.jList_Groups.getModel();
        listModel.clear();
        for (String name : verifyCase.getGroupNames()) {
            listModel.addElement(name);
        }
        this._verifyCase = verifyCase;
        this.jList_Groups.setSelectedIndex(0);
        this._currentGroup = this._verifyCase.getVerifyGroups().get(0);
        this.updateContorls(this._currentGroup);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FrmMain().setVisible(true);
            }
        });
    }
}

