/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.FrmLegendSet;
import org.meteoinfo.geo.legend.GroupNode;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.legend.MapFrame;
import org.meteoinfo.geo.plugin.IApplication;
import org.meteoinfo.geo.plugin.PluginBase;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.legend.LegendManage;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.Field;
import org.meteoinfo.ui.CheckBoxListEntry;
import org.meteothink.trajstat.forms.FrmAbout;
import org.meteothink.trajstat.forms.FrmAddData;
import org.meteothink.trajstat.forms.FrmCWT;
import org.meteothink.trajstat.forms.FrmChart;
import org.meteothink.trajstat.forms.FrmClusterCal;
import org.meteothink.trajstat.forms.FrmClusterStat;
import org.meteothink.trajstat.forms.FrmConvertToLine;
import org.meteothink.trajstat.forms.FrmCreateGridLayer;
import org.meteothink.trajstat.forms.FrmMultiSel;
import org.meteothink.trajstat.forms.FrmPSCF;
import org.meteothink.trajstat.forms.FrmToGrid;
import org.meteothink.trajstat.forms.FrmTrajMonth;
import org.meteothink.trajstat.trajectory.TrajUtil;

public class Main
extends PluginBase {
    private JMenu trajMenu = null;
    private final String path;

    public Main() {
        this.setName("TrajStat");
        this.setAuthor("Yaqiang Wang");
        this.setVersion("1.5.6");
        this.setDescription("Trajectory statistics plugin");
        this.path = GlobalUtil.getAppPath(Main.class);
    }

    public void load() {
        if (this.trajMenu == null) {
            this.trajMenu = new JMenu(this.getName());
            JMenuItem mi = new JMenuItem("Load Default Project");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onOpenDefaultProjectClick();
                }
            });
            this.trajMenu.add(mi);
            this.trajMenu.addSeparator();
            mi = new JMenuItem("Calculate Trajectories");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onCalculationClick();
                }
            });
            this.trajMenu.add(mi);
            this.trajMenu.addSeparator();
            mi = new JMenuItem("Convert To TGS Files");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onConvertToTGSClick();
                }
            });
            this.trajMenu.add(mi);
            mi = new JMenuItem("Join TGS File");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onJoinTGSFilesClick();
                }
            });
            this.trajMenu.add(mi);
            mi = new JMenuItem("Convert To Shape File");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onConvertToShapeFileClick();
                }
            });
            this.trajMenu.add(mi);
            this.trajMenu.addSeparator();
            mi = new JMenuItem("Join Trajectory Layers");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Main.this.onJoinTrajLayersClick();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            this.trajMenu.add(mi);
            mi = new JMenuItem("Show Press Profile");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onShowPressProfileClick();
                }
            });
            this.trajMenu.add(mi);
            mi = new JMenuItem("Set Trajectory Legend");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onSetTrajLegendClick();
                }
            });
            this.trajMenu.add(mi);
            this.trajMenu.addSeparator();
            mi = new JMenuItem("Add Data to Trajectory");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onAddDataToTrajClick();
                }
            });
            this.trajMenu.add(mi);
            mi = new JMenuItem("Trajectory Average");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onTrajAveClick();
                }
            });
            this.trajMenu.add(mi);
            this.trajMenu.addSeparator();
            mi = new JMenuItem("Cluster Calculation");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onClusterAnalysisClick();
                }
            });
            this.trajMenu.add(mi);
            mi = new JMenuItem("Cluster Statistics");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onClusterStatClick();
                }
            });
            this.trajMenu.add(mi);
            this.trajMenu.addSeparator();
            mi = new JMenuItem("Create Grid Layer");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onCreateGridLayerClick();
                }
            });
            this.trajMenu.add(mi);
            mi = new JMenuItem("PSCF Analysis");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onPSCFAnalysisClick();
                }
            });
            this.trajMenu.add(mi);
            mi = new JMenuItem("CWT Analysis");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onCWTAnalysisClick();
                }
            });
            this.trajMenu.add(mi);
            mi = new JMenuItem("Save to grid");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onSaveToGridClick();
                }
            });
            this.trajMenu.add(mi);
            this.trajMenu.addSeparator();
            mi = new JMenuItem("About");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onAboutClick();
                }
            });
            this.trajMenu.add(mi);
            mi = new JMenuItem("Help");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.this.onHelpClick();
                }
            });
            this.trajMenu.add(mi);
        }
        IApplication app = this.getApplication();
        JMenuBar mainMenuBar = app.getMainMenuBar();
        mainMenuBar.add(this.trajMenu);
        mainMenuBar.validate();
    }

    public void unload() {
        if (this.trajMenu != null) {
            this.getApplication().getMainMenuBar().remove(this.trajMenu);
            this.getApplication().getMainMenuBar().repaint();
        }
    }

    private void onOpenDefaultProjectClick() {
        IApplication app = this.getApplication();
        String projectFn = this.path + File.separator + "default.mip";
        app.openProjectFile(projectFn);
    }

    private void onCalculationClick() {
        IApplication app = this.getApplication();
        FrmTrajMonth frm = new FrmTrajMonth((Frame)((JFrame)app), false, this.path);
        frm.setLocationRelativeTo(frm.getParent());
        frm.setVisible(true);
    }

    private void onConvertToTGSClick() {
        IApplication app = this.getApplication();
        JFrame appFrame = (JFrame)app;
        String userPath = System.getProperty("user.dir");
        File pathDir = new File(userPath);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        aDlg.setMultiSelectionEnabled(true);
        if (0 == aDlg.showOpenDialog(appFrame)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            appFrame.setCursor(Cursor.getPredefinedCursor(3));
            for (File file : files) {
                String trajfn = file.getAbsolutePath();
                String tgsfn = trajfn + ".tgs";
                try {
                    TrajUtil.trajToTGS(trajfn, tgsfn);
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            appFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void onJoinTGSFilesClick() {
        IApplication app = this.getApplication();
        JFrame appFrame = (JFrame)app;
        String userPath = System.getProperty("user.dir");
        File pathDir = new File(userPath);
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"tgs"};
        GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "TGS File (*.tgs)");
        aDlg.setFileFilter((FileFilter)pFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        aDlg.setMultiSelectionEnabled(true);
        if (0 == aDlg.showOpenDialog(appFrame)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            appFrame.setCursor(Cursor.getPredefinedCursor(3));
            ArrayList<String> tgsfns = new ArrayList<String>();
            for (File file : files) {
                tgsfns.add(file.getAbsolutePath());
            }
            aDlg.setMultiSelectionEnabled(false);
            if (0 == aDlg.showSaveDialog(appFrame)) {
                File sFile = aDlg.getSelectedFile();
                try {
                    TrajUtil.joinTGSFiles(tgsfns, sFile.getAbsolutePath());
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            appFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void onConvertToShapeFileClick() {
        final IApplication app = this.getApplication();
        final JFrame appFrame = (JFrame)app;
        String userPath = System.getProperty("user.dir");
        File pathDir = new File(userPath);
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"tgs"};
        GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "TGS File (*.tgs)");
        aDlg.setFileFilter((FileFilter)pFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        aDlg.setMultiSelectionEnabled(true);
        if (0 == aDlg.showOpenDialog(appFrame)) {
            final File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            SwingWorker<String, String> worker = new SwingWorker<String, String>(){

                @Override
                protected String doInBackground() throws Exception {
                    app.getProgressBar().setVisible(true);
                    app.getProgressBar().setValue(0);
                    appFrame.setCursor(Cursor.getPredefinedCursor(3));
                    int i = 0;
                    for (File file : files) {
                        try {
                            VectorLayer layer = TrajUtil.convertToShapeFile(file.getAbsolutePath(), file.getAbsolutePath().replace(".tgs", ".shp"));
                            if (layer != null) {
                                Main.addTrajLayer(layer, app.getMapDocument().getActiveMapFrame());
                            }
                            app.getProgressBar().setValue((int)((double)(i + 1) / (double)files.length * 100.0));
                            ++i;
                        }
                        catch (FileNotFoundException ex) {
                            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    return "";
                }

                @Override
                protected void done() {
                    app.getProgressBar().setVisible(false);
                    appFrame.setCursor(Cursor.getDefaultCursor());
                }
            };
            worker.execute();
        }
    }

    public static void addTrajLayer(VectorLayer layer, MapFrame mapFrame) {
        GroupNode gNode = mapFrame.getGroupByName("Trajectory");
        int gHandle = gNode == null ? mapFrame.addNewGroup("Trajectory") : gNode.getGroupHandle();
        mapFrame.addLayer((MapLayer)layer, gHandle);
    }

    public static void addLayer(VectorLayer layer, MapFrame mapFrame, String groupName) {
        GroupNode gNode = mapFrame.getGroupByName(groupName);
        int gHandle = gNode == null ? mapFrame.addNewGroup(groupName) : gNode.getGroupHandle();
        mapFrame.addLayer((MapLayer)layer, gHandle);
    }

    private void onJoinTrajLayersClick() throws Exception {
        IApplication app = this.getApplication();
        GroupNode gNode = app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        if (gNode == null) {
            JOptionPane.showMessageDialog(null, "No Trajectory group exist!");
            return;
        }
        if (gNode.getLayers().isEmpty()) {
            JOptionPane.showMessageDialog(null, "No Trajectory layer exist!");
            return;
        }
        FrmMultiSel frmMultiSel = new FrmMultiSel((Frame)((JFrame)app), true);
        frmMultiSel.setTitle("Select Layers");
        frmMultiSel.setLabelText("Layers:");
        DefaultListModel listModel = new DefaultListModel();
        for (LayerNode lNode : gNode.getLayers()) {
            listModel.addElement(new CheckBoxListEntry((Object)lNode.getMapLayer(), true));
        }
        frmMultiSel.setListModel(listModel);
        frmMultiSel.setLocationRelativeTo((JFrame)app);
        frmMultiSel.setVisible(true);
        ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
        if (frmMultiSel.isOK()) {
            int i;
            listModel = frmMultiSel.getListModel();
            for (i = 0; i < listModel.getSize(); ++i) {
                if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
                layers.add((VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue());
            }
            if (layers.isEmpty()) {
                JOptionPane.showMessageDialog(null, "No layer was selected!");
                return;
            }
            JFrame appFrame = (JFrame)app;
            String userPath = System.getProperty("user.dir");
            File pathDir = new File(userPath);
            JFileChooser aDlg = new JFileChooser();
            String[] fileExts = new String[]{"shp"};
            GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "Shape File (*.shp)");
            aDlg.setFileFilter((FileFilter)pFileFilter);
            aDlg.setAcceptAllFileFilterUsed(false);
            aDlg.setCurrentDirectory(pathDir);
            if (0 == aDlg.showOpenDialog(appFrame)) {
                File file = aDlg.getSelectedFile();
                String shpfn = file.getCanonicalPath();
                System.setProperty("user.dir", file.getParent());
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                if (!shpfn.substring(shpfn.length() - extent.length()).equals(extent)) {
                    shpfn = shpfn + "." + extent;
                    file = new File(shpfn);
                }
                VectorLayer outLayer = new VectorLayer(ShapeTypes.POLYLINE_Z);
                for (Field field : ((VectorLayer)layers.get(0)).getFields()) {
                    outLayer.editAddField(new Field(field.getColumnName(), field.getDataType()));
                }
                for (VectorLayer layer : layers) {
                    for (i = 0; i < layer.getShapeNum(); ++i) {
                        int shapeNum = outLayer.getShapeNum();
                        if (!outLayer.editInsertShape((Shape)layer.getShapes().get(i), shapeNum)) continue;
                        for (int j = 0; j < outLayer.getFieldNumber(); ++j) {
                            outLayer.editCellValue(j, shapeNum, layer.getCellValue(j, i));
                        }
                    }
                }
                if (outLayer.getShapeNum() <= 0) {
                    JOptionPane.showMessageDialog(null, "No valid shapes created!");
                    return;
                }
                outLayer.setLayerName(file.getName());
                LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYLINE, (Color)Color.black, (float)1.0f);
                aLS.setFieldName("Year");
                outLayer.setLegendScheme(aLS);
                outLayer.setLayerDrawType(LayerDrawType.TRAJECTORY_LINE);
                outLayer.setFileName(shpfn);
                outLayer.saveFile(shpfn);
                Main.addTrajLayer(outLayer, app.getMapDocument().getActiveMapFrame());
            }
        }
    }

    private void onShowPressProfileClick() {
        IApplication app = this.getApplication();
        FrmChart frmChart = new FrmChart((Frame)((JFrame)app), false);
        frmChart.setLocationRelativeTo((JFrame)app);
        frmChart.setVisible(true);
    }

    private void onSetTrajLegendClick() {
        IApplication app = this.getApplication();
        GroupNode gNode = app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        if (gNode == null) {
            JOptionPane.showMessageDialog(null, "No Trajectory group exist!");
            return;
        }
        if (gNode.getLayers().isEmpty()) {
            JOptionPane.showMessageDialog(null, "No Trajectory layer exist!");
            return;
        }
        FrmMultiSel frmMultiSel = new FrmMultiSel((Frame)((JFrame)app), true);
        frmMultiSel.setTitle("Select Layers");
        frmMultiSel.setLabelText("Layers:");
        DefaultListModel listModel = new DefaultListModel();
        for (LayerNode lNode : gNode.getLayers()) {
            listModel.addElement(new CheckBoxListEntry((Object)lNode.getMapLayer(), true));
        }
        frmMultiSel.setListModel(listModel);
        frmMultiSel.setVisible(true);
        ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
        if (frmMultiSel.isOK()) {
            listModel = frmMultiSel.getListModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
                layers.add((VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue());
            }
            if (layers.isEmpty()) {
                JOptionPane.showMessageDialog(null, "No layer was selected!");
                return;
            }
            FrmLegendSet frmLegend = new FrmLegendSet((Frame)((JFrame)app), true);
            frmLegend.setLegendScheme(((VectorLayer)layers.get(0)).getLegendScheme());
            if (frmLegend.isOK()) {
                LegendScheme aLS = frmLegend.getLegendScheme();
                for (VectorLayer layer : layers) {
                    layer.setLegendScheme(aLS);
                }
            }
            app.getMapDocument().getActiveMapFrame().getMapView().paintLayers();
        }
    }

    private void onAddDataToTrajClick() {
        IApplication app = this.getApplication();
        GroupNode gNode = app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        if (gNode == null) {
            JOptionPane.showMessageDialog(null, "No Trajectory group exist!");
            return;
        }
        if (gNode.getLayers().isEmpty()) {
            JOptionPane.showMessageDialog(null, "No Trajectory layer exist!");
            return;
        }
        FrmAddData frmAddData = new FrmAddData((Frame)((JFrame)app), false);
        frmAddData.setLocationRelativeTo((JFrame)app);
        frmAddData.setVisible(true);
    }

    private void onTrajAveClick() {
        IApplication app = this.getApplication();
        GroupNode gNode = app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        if (gNode == null) {
            JOptionPane.showMessageDialog(null, "No Trajectory group exist!");
            return;
        }
        if (gNode.getLayers().isEmpty()) {
            JOptionPane.showMessageDialog(null, "No Trajectory layer exist!");
            return;
        }
        FrmMultiSel frmMultiSel = new FrmMultiSel((Frame)((JFrame)app), true);
        frmMultiSel.setTitle("Select Layers");
        frmMultiSel.setLabelText("Layers:");
        DefaultListModel listModel = new DefaultListModel();
        for (LayerNode lNode : gNode.getLayers()) {
            listModel.addElement(new CheckBoxListEntry((Object)lNode.getMapLayer(), true));
        }
        frmMultiSel.setListModel(listModel);
        frmMultiSel.setVisible(true);
        ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
        if (frmMultiSel.isOK()) {
            int i;
            listModel = frmMultiSel.getListModel();
            for (i = 0; i < listModel.getSize(); ++i) {
                if (!((CheckBoxListEntry)listModel.get(i)).isSelected()) continue;
                layers.add((VectorLayer)((CheckBoxListEntry)listModel.get(i)).getValue());
            }
            if (layers.isEmpty()) {
                JOptionPane.showMessageDialog(null, "No layer was selected!");
                return;
            }
            List fldNames = ((VectorLayer)layers.get(0)).getFieldNames();
            Object[] selValues = new Object[fldNames.size()];
            for (i = 0; i < selValues.length; ++i) {
                selValues[i] = fldNames.get(i);
            }
            String value = JOptionPane.showInputDialog(null, "Choose a field", "Input", 1, null, selValues, selValues[0]).toString();
            if (value == null) {
                return;
            }
            String fieldName = value.toString();
            ArrayList<String> valueList = new ArrayList<String>();
            ArrayList<List> pointList = new ArrayList<List>();
            ArrayList<Integer> trajNums = new ArrayList<Integer>();
            for (VectorLayer layer : layers) {
                for (i = 0; i < layer.getAttributeTable().getNumRecords(); ++i) {
                    String vStr = layer.getCellValue(fieldName, i).toString();
                    if (vStr.equals("Null")) continue;
                    List points = ((Shape)layer.getShapes().get(i)).getPoints();
                    if (!valueList.contains(vStr)) {
                        valueList.add(vStr);
                        pointList.add(points);
                        trajNums.add(1);
                        continue;
                    }
                    int n = valueList.indexOf(vStr);
                    List ps = (List)pointList.get(n);
                    for (int j = 0; j < points.size() && j < ps.size(); ++j) {
                        PointZ point = (PointZ)ps.get(j);
                        PointZ pp = (PointZ)points.get(j);
                        point.X += pp.X;
                        point.Y += pp.Y;
                        point.Z += pp.Z;
                        point.M += pp.M;
                    }
                    trajNums.set(n, (Integer)trajNums.get(n) + 1);
                }
            }
            for (i = 0; i < pointList.size(); ++i) {
                List plist = (List)pointList.get(i);
                int n = (Integer)trajNums.get(i);
                for (int j = 0; j < plist.size(); ++j) {
                    PointZ point = (PointZ)plist.get(j);
                    point.X /= (double)n;
                    point.Y /= (double)n;
                    point.Z /= (double)n;
                    point.M /= (double)n;
                }
            }
            String userPath = System.getProperty("user.dir");
            File pathDir = new File(userPath);
            JFileChooser aDlg = new JFileChooser();
            String[] fileExts = new String[]{"shp"};
            GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "Shape File (*.shp)");
            aDlg.setFileFilter((FileFilter)pFileFilter);
            aDlg.setAcceptAllFileFilterUsed(false);
            aDlg.setCurrentDirectory(pathDir);
            if (0 == aDlg.showOpenDialog((JFrame)app)) {
                File file = aDlg.getSelectedFile();
                String shpfn = "";
                try {
                    shpfn = file.getCanonicalPath();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
                System.setProperty("user.dir", file.getParent());
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                if (!shpfn.substring(shpfn.length() - extent.length()).equals(extent)) {
                    shpfn = shpfn + "." + extent;
                }
                VectorLayer trajLayer = new VectorLayer(ShapeTypes.POLYLINE_Z);
                trajLayer.editAddField(fieldName, DataType.STRING);
                for (i = 0; i < pointList.size(); ++i) {
                    try {
                        PolylineZShape lineShape = new PolylineZShape();
                        List points = (List)pointList.get(i);
                        lineShape.setPoints(points);
                        lineShape.setExtent(GeometryUtil.getPointsExtent((List)points));
                        int shapeNum = trajLayer.getShapeNum();
                        if (!trajLayer.editInsertShape((Shape)lineShape, shapeNum)) continue;
                        trajLayer.editCellValue(fieldName, shapeNum, valueList.get(i));
                        continue;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (trajLayer.getShapeNum() <= 0) {
                    JOptionPane.showMessageDialog(null, "No valid shapes created!");
                    return;
                }
                trajLayer.setLayerName(file.getName());
                LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYLINE, (Color)Color.black, (float)1.0f);
                aLS.setFieldName("Year");
                trajLayer.setLegendScheme(aLS);
                trajLayer.setLayerDrawType(LayerDrawType.TRAJECTORY_LINE);
                trajLayer.setFileName(shpfn);
                trajLayer.saveFile(shpfn);
                Main.addTrajLayer(trajLayer, app.getMapDocument().getActiveMapFrame());
            }
        }
    }

    private void onConvertToLineClick() {
        IApplication app = this.getApplication();
        GroupNode gNode = app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        if (gNode == null) {
            JOptionPane.showMessageDialog(null, "No Trajectory group exist!");
            return;
        }
        if (gNode.getLayers().isEmpty()) {
            JOptionPane.showMessageDialog(null, "No Trajectory layer exist!");
            return;
        }
        FrmConvertToLine frm = new FrmConvertToLine((Frame)((JFrame)app), false);
        frm.setLocationRelativeTo((JFrame)app);
        frm.setVisible(true);
    }

    private void onClusterAnalysisClick() {
        IApplication app = this.getApplication();
        GroupNode gNode = app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        if (gNode == null) {
            JOptionPane.showMessageDialog(null, "No Trajectory group exist!");
            return;
        }
        if (gNode.getLayers().isEmpty()) {
            JOptionPane.showMessageDialog(null, "No Trajectory layer exist!");
            return;
        }
        FrmClusterCal frm = new FrmClusterCal((Frame)((JFrame)app), false);
        frm.setLocationRelativeTo((JFrame)app);
        frm.setVisible(true);
    }

    private void onClusterStatClick() {
        IApplication app = this.getApplication();
        GroupNode gNode = app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        if (gNode == null) {
            JOptionPane.showMessageDialog(null, "No Trajectory group exist!");
            return;
        }
        if (gNode.getLayers().isEmpty()) {
            JOptionPane.showMessageDialog(null, "No Trajectory layer exist!");
            return;
        }
        FrmClusterStat frm = new FrmClusterStat((Frame)((JFrame)app), false);
        frm.setLocationRelativeTo((JFrame)app);
        frm.setVisible(true);
    }

    private void onCreateGridLayerClick() {
        IApplication app = this.getApplication();
        FrmCreateGridLayer frm = new FrmCreateGridLayer((Frame)((JFrame)app), false);
        frm.setLocationRelativeTo((JFrame)app);
        frm.setVisible(true);
    }

    private void onPSCFAnalysisClick() {
        IApplication app = this.getApplication();
        GroupNode gNode = app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        if (gNode == null) {
            JOptionPane.showMessageDialog(null, "No Trajectory group exist!");
            return;
        }
        if (gNode.getLayers().isEmpty()) {
            JOptionPane.showMessageDialog(null, "No Trajectory layer exist!");
            return;
        }
        FrmPSCF frm = new FrmPSCF((Frame)((JFrame)app), false);
        frm.setLocationRelativeTo((JFrame)app);
        frm.setVisible(true);
    }

    private void onCWTAnalysisClick() {
        IApplication app = this.getApplication();
        GroupNode gNode = app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        if (gNode == null) {
            JOptionPane.showMessageDialog(null, "No Trajectory group exist!");
            return;
        }
        if (gNode.getLayers().isEmpty()) {
            JOptionPane.showMessageDialog(null, "No Trajectory layer exist!");
            return;
        }
        FrmCWT frm = new FrmCWT((Frame)((JFrame)app), false);
        frm.setLocationRelativeTo((JFrame)app);
        frm.setVisible(true);
    }

    private void onSaveToGridClick() {
        IApplication app = this.getApplication();
        FrmToGrid frm = new FrmToGrid((Frame)((JFrame)app), false);
        frm.setLocationRelativeTo((JFrame)app);
        frm.setVisible(true);
    }

    private void onAboutClick() {
        IApplication app = this.getApplication();
        FrmAbout frm = new FrmAbout((Frame)((JFrame)app), false);
        frm.setVersion(this.getVersion());
        frm.setLocationRelativeTo((JFrame)app);
        frm.setVisible(true);
    }

    private void onHelpClick() {
        try {
            URI uri = new URI("http://www.meteothink.org/docs/trajstat/index.html");
            Desktop desktop = null;
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
            }
            if (desktop != null) {
                desktop.browse(uri);
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(FrmAbout.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

