/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.integrate.lsoda;

import org.meteoinfo.math.integrate.lsoda.Utility;

public class SupportingFunctions {
    public static double vmnorm(int n, double[] v, double[] w) {
        double vm = 0.0;
        for (int i = 1; i <= n; ++i) {
            vm = Math.max(vm, Math.abs(v[i]) * w[i]);
        }
        return vm;
    }

    public static double fnorm(int n, double[][] a, double[] w) {
        double an = 0.0;
        for (int i = 1; i <= n; ++i) {
            double sum = 0.0;
            for (int j = 1; j <= n; ++j) {
                sum += Math.abs(a[i][j]) / w[j];
            }
            an = Math.max(an, sum * w[i]);
        }
        return an;
    }

    public static double[] ewset(double[] ycur, int itol, double[] rtol, double[] atol, int n) {
        double[] EWT = new double[n + 1];
        switch (itol) {
            case 1: {
                for (int i = 1; i <= n; ++i) {
                    EWT[i] = rtol[1] * Math.abs(ycur[i]) + atol[1];
                }
                break;
            }
            case 2: {
                for (int i = 1; i <= n; ++i) {
                    EWT[i] = rtol[1] * Math.abs(ycur[i]) + atol[i];
                }
                break;
            }
            case 3: {
                for (int i = 1; i <= n; ++i) {
                    EWT[i] = rtol[i] * Math.abs(ycur[i]) + atol[1];
                }
                break;
            }
            case 4: {
                for (int i = 1; i <= n; ++i) {
                    EWT[i] = rtol[i] * Math.abs(ycur[i]) + atol[i];
                }
                break;
            }
        }
        return EWT;
    }

    public static double[] solsy(double[] y, double[][] wm, int n, int[] ipvt, int miter) {
        if (miter != 2) {
            System.out.println("solsy: miter != 2");
            return y;
        }
        return Utility.solveLinearSys(wm, n, ipvt, y);
    }

    public static double[] intdy(double t, int k, double[] dky, int nq, double tn, double hu, double ETA, double h, double[][] yh, int n) {
        int i;
        if (k < 0 || k > nq) {
            System.err.printf("intdy: k = %d illegal", k);
            dky[0] = -1.0;
            return dky;
        }
        double tp = tn - hu - 100.0 * ETA * (tn + hu);
        if ((t - tp) * (t - tn) > 0.0) {
            System.err.printf("intdy: t = %f illegal\nt not in interval tcur-hu to tcur\n", t);
            dky[0] = -2.0;
            return dky;
        }
        double s = (t - tn) / h;
        int ic = 1;
        for (i = nq + 1 - k; i <= nq; ++i) {
            ic *= i;
        }
        for (i = 1; i <= n; ++i) {
            dky[i] = (double)ic * yh[nq + 1][i];
        }
        for (int j = nq - 1; j >= k; --j) {
            int jp1 = j + 1;
            ic = 1;
            for (int jj = jp1 - k; jj <= j; ++jj) {
                ic *= jj;
            }
            for (int i2 = 1; i2 <= n; ++i2) {
                dky[i2] = (double)ic * yh[jp1][i2] + s * dky[i2];
            }
        }
        if (k == 0) {
            return dky;
        }
        double r = Math.pow(h, -k);
        for (i = 1; i <= n; ++i) {
            dky[i] = r * dky[i];
        }
        return dky;
    }
}

