fn = 'D:/MyProgram/java/MeteoInfoDev/toolbox/OutlierFlag/sample/54826PMMUL201102_T.txt'
df = DataFrame.read_table(fn, delimiter=',', format='%3f',
    index_col=0, index_format='%{yyyyMMddHHmm}D', 
    usecols=['PM10','PM2.5','PM1'])
print(df.head())
pm2_5 = df['PM2.5'].values
pm2_5[pm2_5<-10] = nan
df['PM2.5'] = pm2_5
t = df.index.data

#Hour average
dfh = df.resample('D').mean()
pmh = dfh['PM2.5'].values
th = dfh.index.data

#Plot
plot(t, pm2_5, '-b', label='5Min')
plot(th, pmh, '-r', linewidth=2, label='1Day')
legend()
xlabel('Time')
ylabel(r'$\rm{PM}_\textbf{2.5}$' + u' (µg/m' + r'$\rm{^{3})}$')
tvalues = []
tlabels = []
st = datetime.datetime(t[0].year, t[0].month, t[0].day)
while st <= t[-1]:
    tvalues.append(st)
    if st.day == 1:
        tlabels.append(str(st.day) + '\n%s' % st.strftime('%Y-%m'))
    else:
        tlabels.append(str(st.day))    
    st = st + datetime.timedelta(days=1)
xticks(tvalues, tlabels)

#savefig('D:/Temp/figure/dataframe_resample.png', 600, 300, dpi=300)