/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic.cylinder;

import com.jogamp.opengl.GL2;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.meteoinfo.chart.graphic.TriMeshGraphic;

public class Cylinder {
    private float baseRadius;
    private float topRadius;
    private float height;
    private int sectorCount;
    private int stackCount;
    private boolean smooth;
    private int baseIndex;
    private int topIndex;
    private List<Vector3f> unitCircleVertices;
    private List<Vector3f> vertices;
    private List<Vector3f> normals;
    private List<Integer> indices;
    private List<Integer> lineIndices;
    private List<Vector2f> texCoords;
    private List<Vector3f> interleavedVertices;
    private int interleavedStride;

    public Cylinder(float baseRadius, float topRadius, float height, int sectorCount, int stackCount, boolean smooth) {
        this.baseRadius = baseRadius;
        this.topRadius = topRadius;
        this.height = height;
        this.sectorCount = sectorCount;
        this.stackCount = stackCount;
        this.smooth = smooth;
        this.updateVertices();
    }

    public void updateVertices() {
        this.buildUnitCircleVertices();
        if (this.smooth) {
            this.buildVerticesSmooth();
        } else {
            this.buildVerticesFlat();
        }
    }

    protected TriMeshGraphic buildTriMeshGraphic() {
        TriMeshGraphic triMeshGraphic = new TriMeshGraphic();
        int n = this.vertices.size();
        float[] vertexPosition = new float[n * 3];
        float[] vertexNormal = new float[n * 3];
        int i = 0;
        int j = 0;
        while (i < n) {
            Vector3f v = this.vertices.get(i);
            vertexPosition[j] = v.x;
            vertexPosition[j + 1] = v.y;
            vertexPosition[j + 2] = v.z;
            v = this.normals.get(i);
            vertexNormal[j] = v.x;
            vertexNormal[j + 1] = v.y;
            vertexNormal[j + 2] = v.z;
            ++i;
            j += 3;
        }
        int[] vertexIndices = this.indices.stream().mapToInt(Integer::intValue).toArray();
        triMeshGraphic.setVertexPosition(vertexPosition);
        triMeshGraphic.setVertexNormal(vertexNormal);
        triMeshGraphic.setVertexIndices(vertexIndices);
        return triMeshGraphic;
    }

    public float getBaseRadius() {
        return this.baseRadius;
    }

    public void setBaseRadius(float value) {
        if (this.baseRadius != value) {
            this.baseRadius = value;
            this.updateVertices();
        }
    }

    public float getTopRadius() {
        return this.topRadius;
    }

    public void setTopRadius(float value) {
        if (this.topRadius != value) {
            this.topRadius = value;
            this.updateVertices();
        }
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float value) {
        if (this.height != value) {
            this.height = value;
            this.updateVertices();
        }
    }

    public int getSectorCount() {
        return this.sectorCount;
    }

    public void setSectorCount(int value) {
        if (this.sectorCount != value) {
            this.sectorCount = value;
            this.updateVertices();
        }
    }

    public int getStackCount() {
        return this.stackCount;
    }

    public void setStackCount(int value) {
        if (this.stackCount != value) {
            this.stackCount = value;
            this.updateVertices();
        }
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public void setSmooth(boolean value) {
        if (this.smooth != value) {
            this.smooth = value;
            this.updateVertices();
        }
    }

    public List<Vector3f> getVertices() {
        return this.vertices;
    }

    public List<Vector3f> getNormals() {
        return this.normals;
    }

    public List<Vector2f> getTexCoords() {
        return this.texCoords;
    }

    public List<Integer> getIndices() {
        return this.indices;
    }

    public List<Vector3f> getInterleavedVertices() {
        return this.interleavedVertices;
    }

    public int getInterleavedStride() {
        return this.interleavedStride;
    }

    void buildInterleavedVertices() {
        this.interleavedVertices = new ArrayList<Vector3f>();
        int count = this.vertices.size();
        for (int i = 0; i < count; ++i) {
            this.interleavedVertices.add(this.vertices.get(i));
            this.interleavedVertices.add(this.normals.get(i));
        }
    }

    void buildUnitCircleVertices() {
        float sectorStep = (float)(Math.PI * 2 / (double)this.sectorCount);
        this.unitCircleVertices = new ArrayList<Vector3f>();
        float z = 0.0f;
        for (int i = 0; i <= this.sectorCount; ++i) {
            float sectorAngle = (float)i * sectorStep;
            float x = (float)Math.cos(sectorAngle);
            float y = (float)Math.sin(sectorAngle);
            this.unitCircleVertices.add(new Vector3f(x, y, z));
        }
    }

    void clearArrays() {
        this.vertices = new ArrayList<Vector3f>();
        this.normals = new ArrayList<Vector3f>();
        this.indices = new ArrayList<Integer>();
        this.lineIndices = new ArrayList<Integer>();
        this.texCoords = new ArrayList<Vector2f>();
    }

    void addVertex(float x, float y, float z) {
        this.vertices.add(new Vector3f(x, y, z));
    }

    void addNormal(float nx, float ny, float nz) {
        this.normals.add(new Vector3f(nx, ny, nz));
    }

    void addNormal(Vector3f n) {
        this.normals.add(n);
    }

    void addTexCoord(float s, float t) {
        this.texCoords.add(new Vector2f(s, t));
    }

    void addIndices(int i1, int i2, int i3) {
        this.indices.add(i1);
        this.indices.add(i2);
        this.indices.add(i3);
    }

    void buildVerticesSmooth() {
        int i;
        Vector3f v;
        float z;
        this.clearArrays();
        List<Vector3f> sideNormals = this.getSideNormals();
        for (int i2 = 0; i2 <= this.stackCount; ++i2) {
            z = -(this.height * 0.5f) + (float)i2 / (float)this.stackCount * this.height;
            float radius = this.baseRadius + (float)i2 / (float)this.stackCount * (this.topRadius - this.baseRadius);
            float t = 1.0f - (float)i2 / (float)this.stackCount;
            for (int j = 0; j <= this.sectorCount; ++j) {
                v = this.unitCircleVertices.get(j);
                this.addVertex(v.x * radius, v.y * radius, z);
                Vector3f s = sideNormals.get(j);
                this.addNormal(sideNormals.get(j));
                this.addTexCoord((float)j / (float)this.sectorCount, t);
            }
        }
        int baseVertexIndex = this.vertices.size();
        z = -this.height * 0.5f;
        this.addVertex(0.0f, 0.0f, z);
        this.addNormal(0.0f, 0.0f, -1.0f);
        this.addTexCoord(0.5f, 0.5f);
        for (int i3 = 0; i3 < this.sectorCount; ++i3) {
            Vector3f v2 = this.unitCircleVertices.get(i3);
            this.addVertex(v2.x * this.baseRadius, v2.y * this.baseRadius, z);
            this.addNormal(0.0f, 0.0f, -1.0f);
            this.addTexCoord(-v2.x * 0.5f + 0.5f, -v2.y * 0.5f + 0.5f);
        }
        int topVertexIndex = this.vertices.size();
        z = this.height * 0.5f;
        this.addVertex(0.0f, 0.0f, z);
        this.addNormal(0.0f, 0.0f, 1.0f);
        this.addTexCoord(0.5f, 0.5f);
        for (int i4 = 0; i4 < this.sectorCount; ++i4) {
            v = this.unitCircleVertices.get(i4);
            this.addVertex(v.x * this.topRadius, v.y * this.topRadius, z);
            this.addNormal(0.0f, 0.0f, 1.0f);
            this.addTexCoord(v.x * 0.5f + 0.5f, -v.y * 0.5f + 0.5f);
        }
        for (i = 0; i < this.stackCount; ++i) {
            int k1 = i * (this.sectorCount + 1);
            int k2 = k1 + this.sectorCount + 1;
            int j = 0;
            while (j < this.sectorCount) {
                this.addIndices(k1, k1 + 1, k2);
                this.addIndices(k2, k1 + 1, k2 + 1);
                this.lineIndices.add(k1);
                this.lineIndices.add(k2);
                this.lineIndices.add(k2);
                this.lineIndices.add(k2 + 1);
                if (i == 0) {
                    this.lineIndices.add(k1);
                    this.lineIndices.add(k1 + 1);
                }
                ++j;
                ++k1;
                ++k2;
            }
        }
        this.baseIndex = this.indices.size();
        i = 0;
        int k = baseVertexIndex + 1;
        while (i < this.sectorCount) {
            if (i < this.sectorCount - 1) {
                this.addIndices(baseVertexIndex, k + 1, k);
            } else {
                this.addIndices(baseVertexIndex, baseVertexIndex + 1, k);
            }
            ++i;
            ++k;
        }
        this.topIndex = this.indices.size();
        i = 0;
        k = topVertexIndex + 1;
        while (i < this.sectorCount) {
            if (i < this.sectorCount - 1) {
                this.addIndices(topVertexIndex, k, k + 1);
            } else {
                this.addIndices(topVertexIndex, k, topVertexIndex + 1);
            }
            ++i;
            ++k;
        }
        this.buildInterleavedVertices();
    }

    void buildVerticesFlat() {
        int k;
        int j;
        float z;
        int i;
        ArrayList<Vertex> tmpVertices = new ArrayList<Vertex>();
        for (i = 0; i <= this.stackCount; ++i) {
            z = -(this.height * 0.5f) + (float)i / (float)this.stackCount * this.height;
            float radius = this.baseRadius + (float)i / (float)this.stackCount * (this.topRadius - this.baseRadius);
            float t = 1.0f - (float)i / (float)this.stackCount;
            for (j = 0; j <= this.sectorCount; ++j) {
                Vector3f v = this.unitCircleVertices.get(j);
                float s = (float)j / (float)this.sectorCount;
                Vertex vertex = new Vertex();
                vertex.x = v.x * radius;
                vertex.y = v.y * radius;
                vertex.z = z;
                vertex.s = s;
                vertex.t = t;
                tmpVertices.add(vertex);
            }
        }
        this.clearArrays();
        int index = 0;
        for (i = 0; i < this.stackCount; ++i) {
            int vi1 = i * (this.sectorCount + 1);
            int vi2 = (i + 1) * (this.sectorCount + 1);
            j = 0;
            while (j < this.sectorCount) {
                Vertex v1 = (Vertex)tmpVertices.get(vi1);
                Vertex v2 = (Vertex)tmpVertices.get(vi2);
                Vertex v3 = (Vertex)tmpVertices.get(vi1 + 1);
                Vertex v4 = (Vertex)tmpVertices.get(vi2 + 1);
                float[] n = this.computeFaceNormal(v1.x, v1.y, v1.z, v3.x, v3.y, v3.z, v2.x, v2.y, v2.z);
                this.addVertex(v1.x, v1.y, v1.z);
                this.addVertex(v2.x, v2.y, v2.z);
                this.addVertex(v3.x, v3.y, v3.z);
                this.addVertex(v4.x, v4.y, v4.z);
                this.addTexCoord(v1.s, v1.t);
                this.addTexCoord(v2.s, v2.t);
                this.addTexCoord(v3.s, v3.t);
                this.addTexCoord(v4.s, v4.t);
                for (k = 0; k < 4; ++k) {
                    this.addNormal(n[0], n[1], n[2]);
                }
                this.addIndices(index, index + 2, index + 1);
                this.addIndices(index + 1, index + 2, index + 3);
                this.lineIndices.add(index);
                this.lineIndices.add(index + 1);
                this.lineIndices.add(index + 1);
                this.lineIndices.add(index + 3);
                if (i == 0) {
                    this.lineIndices.add(index);
                    this.lineIndices.add(index + 2);
                }
                index += 4;
                ++j;
                ++vi1;
                ++vi2;
            }
        }
        this.baseIndex = this.indices.size();
        int baseVertexIndex = this.vertices.size() / 3;
        z = -this.height * 0.5f;
        this.addVertex(0.0f, 0.0f, z);
        this.addNormal(0.0f, 0.0f, -1.0f);
        this.addTexCoord(0.5f, 0.5f);
        for (i = 0; i < this.sectorCount; ++i) {
            Vector3f v = this.unitCircleVertices.get(i);
            this.addVertex(v.x * this.baseRadius, v.y * this.baseRadius, z);
            this.addNormal(0.0f, 0.0f, -1.0f);
            this.addTexCoord(-v.x * 0.5f + 0.5f, -v.y * 0.5f + 0.5f);
        }
        i = 0;
        k = baseVertexIndex + 1;
        while (i < this.sectorCount) {
            if (i < this.sectorCount - 1) {
                this.addIndices(baseVertexIndex, k + 1, k);
            } else {
                this.addIndices(baseVertexIndex, baseVertexIndex + 1, k);
            }
            ++i;
            ++k;
        }
        this.topIndex = this.indices.size();
        int topVertexIndex = this.vertices.size() / 3;
        z = this.height * 0.5f;
        this.addVertex(0.0f, 0.0f, z);
        this.addNormal(0.0f, 0.0f, 1.0f);
        this.addTexCoord(0.5f, 0.5f);
        for (i = 0; i < this.sectorCount; ++i) {
            Vector3f v = this.unitCircleVertices.get(i);
            this.addVertex(v.x * this.topRadius, v.y * this.topRadius, z);
            this.addNormal(0.0f, 0.0f, 1.0f);
            this.addTexCoord(v.x * 0.5f + 0.5f, -v.y * 0.5f + 0.5f);
        }
        i = 0;
        k = topVertexIndex + 1;
        while (i < this.sectorCount) {
            if (i < this.sectorCount - 1) {
                this.addIndices(topVertexIndex, k, k + 1);
            } else {
                this.addIndices(topVertexIndex, k, topVertexIndex + 1);
            }
            ++i;
            ++k;
        }
        this.buildInterleavedVertices();
    }

    List<Vector3f> getSideNormals() {
        float sectorStep = (float)(Math.PI * 2 / (double)this.sectorCount);
        float zAngle = (float)Math.atan2(this.baseRadius - this.topRadius, this.height);
        float x0 = (float)Math.cos(zAngle);
        float y0 = 0.0f;
        float z0 = (float)Math.sin(zAngle);
        ArrayList<Vector3f> normals = new ArrayList<Vector3f>();
        for (int i = 0; i <= this.sectorCount; ++i) {
            float sectorAngle = (float)i * sectorStep;
            normals.add(new Vector3f((float)(Math.cos(sectorAngle) * (double)x0 - Math.sin(sectorAngle) * (double)y0), (float)(Math.sin(sectorAngle) * (double)x0 + Math.cos(sectorAngle) * (double)y0), z0));
        }
        return normals;
    }

    float[] computeFaceNormal(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        float EPSILON = 1.0E-6f;
        float[] normal = new float[]{0.0f, 0.0f, 0.0f};
        float ey1 = y2 - y1;
        float ez2 = z3 - z1;
        float ez1 = z2 - z1;
        float ey2 = y3 - y1;
        float nx = ey1 * ez2 - ez1 * ey2;
        float ex2 = x3 - x1;
        float ex1 = x2 - x1;
        float ny = ez1 * ex2 - ex1 * ez2;
        float nz = ex1 * ey2 - ey1 * ex2;
        float length = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (length > EPSILON) {
            float lengthInv = 1.0f / length;
            normal[0] = nx * lengthInv;
            normal[1] = ny * lengthInv;
            normal[2] = nz * lengthInv;
        }
        return normal;
    }

    public void draw(GL2 gl) {
    }

    class Vertex {
        public float x;
        public float y;
        public float z;
        public float s;
        public float t;

        Vertex() {
        }
    }
}

