/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JPanel;

public class UpdatingTitleMovingImage
implements MovingImage {
    private Dockable dockable;
    private JPanel content;
    private DockTitleVersion version;
    private DockTitleRequest request;
    private DockTitle.Orientation orientation;

    public UpdatingTitleMovingImage(Dockable dockable, DockTitleVersion version, DockTitle.Orientation orientation) {
        if (dockable == null) {
            throw new IllegalArgumentException("ockable must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version must not be null");
        }
        this.dockable = dockable;
        this.content = new JPanel(new BorderLayout());
        this.content.setOpaque(false);
        this.version = version;
        this.orientation = orientation;
    }

    @Override
    public Point getOffset(Point pressPoint) {
        return null;
    }

    @Override
    public void bind(boolean transparency) {
        this.request = new DockTitleRequest(null, this.dockable, this.version){

            @Override
            protected void answer(DockTitle previous, DockTitle title) {
                if (previous != null) {
                    UpdatingTitleMovingImage.this.dockable.unbind(previous);
                }
                UpdatingTitleMovingImage.this.content.removeAll();
                if (title != null) {
                    title.setOrientation(UpdatingTitleMovingImage.this.orientation);
                    UpdatingTitleMovingImage.this.dockable.bind(title);
                    UpdatingTitleMovingImage.this.content.add(title.getComponent(), "Center");
                }
            }
        };
        this.request.install();
        this.request.request();
    }

    @Override
    public Component getComponent() {
        return this.content;
    }

    @Override
    public void unbind() {
        DockTitle title = (DockTitle)this.request.getAnswer();
        if (title != null) {
            this.dockable.unbind(title);
            this.content.removeAll();
        }
        this.request.uninstall();
        this.request = null;
    }
}

