/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import us.hebi.matlab.mat.format.Charsets;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.types.AbstractStruct;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.util.Preconditions;

class MatStruct
extends AbstractStruct
implements Mat5Serializable {
    private static final byte NULL_TERMINATOR = 0;
    private static final int NULL_TERMINATOR_LENGTH = 1;

    MatStruct(int[] dims) {
        super(dims);
    }

    MatStruct(int[] dims, String[] names, Array[][] values) {
        super(dims);
        Preconditions.checkArgument(this.getNumDimensions() == 2, "Structures are limited to two dimensions");
        int numElements = this.getNumElements();
        for (int field = 0; field < names.length; ++field) {
            for (int i = 0; i < numElements; ++i) {
                this.set(names[field], i, values[field][i]);
            }
        }
    }

    @Override
    protected Array getEmptyValue() {
        return Mat5.EMPTY_MATRIX;
    }

    protected String getClassName() {
        return "";
    }

    protected int getLongestFieldName() {
        int length = 0;
        for (String name : this.getFieldNames()) {
            length = Math.max(length, Mat5WriteUtil.getLimitedNameLength(name));
        }
        return length + 1;
    }

    @Override
    public int getMat5Size(String name) {
        List<String> fieldNames = this.getFieldNames();
        int numElements = this.getNumElements();
        int numFields = fieldNames.size();
        long size = 8L;
        size += (long)Mat5WriteUtil.computeArrayHeaderSize(name, this);
        if (this.getType() == MatlabType.Object) {
            String objectClassName = this.getClassName();
            size += (long)Mat5Type.Int8.computeSerializedSize(objectClassName.length());
        }
        size += (long)Mat5Type.Int32.computeSerializedSize(1);
        int numChars = this.getLongestFieldName() * numFields;
        size += (long)Mat5Type.Int8.computeSerializedSize(numChars);
        for (int i = 0; i < numElements; ++i) {
            for (int field = 0; field < numFields; ++field) {
                size += (long)Mat5WriteUtil.computeArraySize(this.get(fieldNames.get(field), i));
            }
        }
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalStateException("Struct contents are larger than the 2GB variable limit of MAT5 files.");
        }
        return (int)size;
    }

    @Override
    public void writeMat5(String name, boolean isGlobal, Sink sink) throws IOException {
        int i;
        List<String> fieldNames = this.getFieldNames();
        int numElements = this.getNumElements();
        int numFields = fieldNames.size();
        Mat5WriteUtil.writeMatrixTag(name, this, sink);
        Mat5WriteUtil.writeArrayHeader(name, isGlobal, this, sink);
        if (this.getType() == MatlabType.Object) {
            String objectClassName = this.getClassName();
            Mat5Type.Int8.writeBytesWithTag(objectClassName.getBytes(Charsets.US_ASCII), sink);
        }
        int longestName = this.getLongestFieldName();
        int numChars = longestName * numFields;
        Mat5Type.Int32.writeIntsWithTag(new int[]{longestName}, sink);
        byte[] ascii = new byte[numChars];
        Arrays.fill(ascii, (byte)0);
        for (i = 0; i < numFields; ++i) {
            String fieldName = Mat5WriteUtil.getLimitedName(this.getFieldNames().get(i));
            byte[] bytes = fieldName.getBytes(Charsets.US_ASCII);
            System.arraycopy(bytes, 0, ascii, i * longestName, bytes.length);
        }
        Mat5Type.Int8.writeBytesWithTag(ascii, sink);
        Preconditions.checkArgument(this.getNumDimensions() == 2, "Structures are limited to two dimensions");
        for (i = 0; i < numElements; ++i) {
            for (int field = 0; field < numFields; ++field) {
                Mat5WriteUtil.writeNestedArray(this.get(fieldNames.get(field), i), sink);
            }
        }
    }
}

