/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.grib2;

import java.io.IOException;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.unidata.io.RandomAccessFile;

public class GRIB2RecordReader {
    private RandomAccessFile raf;
    private Grib2RecordScanner scanner;

    public GRIB2RecordReader() {
    }

    public GRIB2RecordReader(String fileName) {
        this.open(fileName);
    }

    public void open(String fileName) {
        try {
            this.raf = new RandomAccessFile(fileName, "r");
            this.scanner = new Grib2RecordScanner(this.raf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public boolean hasNext() throws IOException {
        return this.scanner.hasNext();
    }

    public Grib2Record next() throws IOException {
        return this.scanner.next();
    }

    public Grib2Record getDataRecord(long position) throws IOException {
        this.raf.seek(position);
        return this.scanner.next();
    }

    public long getCurrentPosition() {
        return this.raf.getFilePointer();
    }

    public Array readData(Grib2Record record) throws IOException {
        long position = this.raf.getFilePointer();
        float[] data = record.readData(this.raf);
        int ny = record.getGDS().getNy();
        int nx = record.getGDS().getNx();
        Array r = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{ny, nx}, (Object)data);
        this.raf.seek(position);
        return r;
    }
}

