/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mathparser;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.mathparser.ExpressionBase;
import org.meteoinfo.data.mathparser.ValueTypes;

public class NumberExpression
extends ExpressionBase {
    private Object _value;
    private ValueTypes _valueType = ValueTypes.Normal;

    public NumberExpression(Object value) {
        this._value = value;
        if (value.getClass() == GridData.class) {
            this._valueType = ValueTypes.Grid;
        }
        if (value.getClass() == StationData.class) {
            this._valueType = ValueTypes.Station;
        }
    }

    public ValueTypes getValueType() {
        return this._valueType;
    }

    public void setValueType(ValueTypes value) {
        this._valueType = value;
    }

    public Object getValue() {
        return this._value;
    }

    @Override
    public Object evaluate(Object[] numbers) {
        return this._value;
    }

    @Override
    public int getArgumentCount() {
        return 0;
    }

    public static boolean isNumber(char c) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        return Character.isDigit(c) || symbols.getDecimalSeparator() == c;
    }

    public static boolean isNegativeSign(char c) {
        return c == '-';
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

