/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import org.meteoinfo.math.MathEx;
import org.meteoinfo.math.blas.UPLO;
import org.meteoinfo.math.interpolate.Interpolation2D;
import org.meteoinfo.math.matrix.Matrix;

public class KrigingInterpolation2D
implements Interpolation2D {
    private double[] x1;
    private double[] x2;
    private double[] yvi;
    private double alpha;
    private double beta;

    public KrigingInterpolation2D(double[] x1, double[] x2, double[] y) {
        this(x1, x2, y, 1.5);
    }

    public KrigingInterpolation2D(double[] x1, double[] x2, double[] y, double beta) {
        if (beta < 1.0 || beta >= 2.0) {
            throw new IllegalArgumentException("Invalid beta: " + beta);
        }
        if (x1.length != x2.length) {
            throw new IllegalArgumentException("x1.length != x2.length");
        }
        if (x1.length != y.length) {
            throw new IllegalArgumentException("x.length != y.length");
        }
        this.x1 = x1;
        this.x2 = x2;
        this.beta = beta;
        this.pow(x1, x2, y);
        int n = x1.length;
        this.yvi = new double[n + 1];
        Matrix v = new Matrix(n + 1, n + 1);
        v.uplo(UPLO.LOWER);
        for (int i = 0; i < n; ++i) {
            this.yvi[i] = y[i];
            for (int j = i; j < n; ++j) {
                double d1 = x1[i] - x1[j];
                double d2 = x2[i] - x2[j];
                double d = d1 * d1 + d2 * d2;
                double var = this.variogram(d);
                v.set(i, j, var);
                v.set(j, i, var);
            }
            v.set(n, i, 1.0);
            v.set(i, n, 1.0);
        }
        this.yvi[n] = 0.0;
        v.set(n, n, 0.0);
        Matrix.SVD svd = v.svd(true, true);
        this.yvi = svd.solve(this.yvi);
    }

    @Override
    public double interpolate(double x1, double x2) {
        int n = this.x1.length;
        double y = this.yvi[n];
        for (int i = 0; i < n; ++i) {
            double d1 = x1 - this.x1[i];
            double d2 = x2 - this.x2[i];
            double d = d1 * d1 + d2 * d2;
            y += this.yvi[i] * this.variogram(d);
        }
        return y;
    }

    private void pow(double[] x1, double[] x2, double[] y) {
        int n = x1.length;
        double num = 0.0;
        double denom = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d1 = x1[i] - x1[j];
                double d2 = x2[i] - x2[j];
                double d = d1 * d1 + d2 * d2;
                double rb = Math.pow(d, this.beta / 2.0);
                num += rb * 0.5 * MathEx.sqr(y[i] - y[j]);
                denom += rb * rb;
            }
        }
        this.alpha = num / denom;
    }

    private double variogram(double r) {
        return this.alpha * Math.pow(r, this.beta / 2.0);
    }

    public String toString() {
        return "Kriging Interpolation";
    }
}

