/*
 * @(#)CVM.java	1.116 06/11/07
 *
 * Copyright  1990-2008 Sun Microsystems, Inc. All Rights Reserved.  
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER  
 *   
 * This program is free software; you can redistribute it and/or  
 * modify it under the terms of the GNU General Public License version  
 * 2 only, as published by the Free Software Foundation.   
 *   
 * This program is distributed in the hope that it will be useful, but  
 * WITHOUT ANY WARRANTY; without even the implied warranty of  
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  
 * General Public License version 2 for more details (a copy is  
 * included at /legal/license.txt).   
 *   
 * You should have received a copy of the GNU General Public License  
 * version 2 along with this work; if not, write to the Free Software  
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  
 * 02110-1301 USA   
 *   
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa  
 * Clara, CA 95054 or visit www.sun.com if you need additional  
 * information or have any questions. 
 *
 */

package impl.sun.misc;

public final class CVM {

    /* Type specific array copiers: */
    public static void copyBooleanArray(boolean[] src, int src_position,
            boolean[] dst, int dst_position,
            int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }
    public static void copyByteArray(byte[] src, int src_position,
            byte[] dst, int dst_position,
            int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }
    public static void copyCharArray(char[] src, int src_position,
            char[] dst, int dst_position,
            int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }
    public static void copyShortArray(short[] src, int src_position,
            short[] dst, int dst_position,
            int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }
    public static void copyIntArray(int[] src, int src_position,
            int[] dst, int dst_position,
            int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }
    public static void copyFloatArray(float[] src, int src_position,
            float[] dst, int dst_position,
            int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }
    public static void copyLongArray(long[] src, int src_position,
            long[] dst, int dst_position,
            int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }
    public static void copyDoubleArray(double[] src, int src_position,
            double[] dst, int dst_position,
            int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }

    /* copyObjectArray() copies array elements from one array to another.
       Unlike System.arraycopy(), this method can only copy elements for
       non-primitive arrays with some restrictions.  The restrictions are that
       the src and dst array must be of the same type, or the dst array must
       be of type java.lang.Object[] (not just a compatible sub-type).  The
       caller is responsible for doing the appropriate null checks, bounds
       checks, array element type assignment checks if necessary, and ensure
       that the passed in arguments do violate any of these checks and
       restrictions.  If the condition of these checks and restrictions are
       not taken cared of by the caller, copyObjectArray() can fail in
       unpredictable ways.
     */
    public static void copyObjectArray(Object[] src, int src_position,
            Object[] dst, int dst_position,
            int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }
    public static void copyArray(Object[] src, int src_position,
            Object[] dst, int dst_position,
            int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }
}
