/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools.move;

import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.tools.move.AvoidanceMap;
import com.cburch.logisim.tools.move.ConnectionData;
import com.cburch.logisim.tools.move.ConnectorThread;
import com.cburch.logisim.tools.move.MoveGesture;
import com.cburch.logisim.tools.move.MoveRequest;
import com.cburch.logisim.tools.move.MoveResult;
import com.cburch.logisim.tools.move.SearchNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

class Connector {
    private static final int MAX_SECONDS = 10;
    private static final int MAX_ORDERING_TRIES = 10;
    private static final int MAX_SEARCH_ITERATIONS = 20000;
    static final String ALLOW_NEITHER = "neither";
    static final String ALLOW_VERTICAL = "vert";
    static final String ALLOW_HORIZONTAL = "horz";

    private Connector() {
    }

    static MoveResult computeWires(MoveRequest req) {
        MoveGesture gesture = req.getMoveGesture();
        int dx = req.getDeltaX();
        int dy = req.getDeltaY();
        ArrayList<ConnectionData> baseConnects = new ArrayList<ConnectionData>(gesture.getConnections());
        List<ConnectionData> impossible = Connector.pruneImpossible(baseConnects, gesture.getFixedAvoidanceMap(), dx, dy);
        AvoidanceMap selAvoid = AvoidanceMap.create(gesture.getSelected(), dx, dy);
        HashMap<ConnectionData, Set<Location>> pathLocs = new HashMap<ConnectionData, Set<Location>>();
        HashMap<ConnectionData, List<SearchNode>> initNodes = new HashMap<ConnectionData, List<SearchNode>>();
        for (ConnectionData conn : baseConnects) {
            HashSet<Location> connLocs = new HashSet<Location>();
            ArrayList<SearchNode> connNodes = new ArrayList<SearchNode>();
            Connector.processConnection(conn, dx, dy, connLocs, connNodes, selAvoid);
            pathLocs.put(conn, connLocs);
            initNodes.put(conn, connNodes);
        }
        MoveResult bestResult = null;
        int tries = switch (baseConnects.size()) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 8;
            default -> 10;
        };
        long stopTime = System.currentTimeMillis() + 10000L;
        for (int tryNum = 0; tryNum < tries && stopTime - System.currentTimeMillis() > 0L; ++tryNum) {
            MoveResult candidate;
            if (ConnectorThread.isOverrideRequested()) {
                return null;
            }
            ArrayList<ConnectionData> connects = new ArrayList<ConnectionData>(baseConnects);
            if (tryNum < 2) {
                Connector.sortConnects(connects, dx, dy);
                if (tryNum == 1) {
                    Collections.reverse(connects);
                }
            } else {
                Collections.shuffle(connects);
            }
            if ((candidate = Connector.tryList(req, gesture, connects, dx, dy, pathLocs, initNodes, stopTime)) == null) {
                return null;
            }
            if (bestResult == null) {
                bestResult = candidate;
                continue;
            }
            int unsatisfied1 = bestResult.getUnsatisifiedConnections().size();
            int unsatisfied2 = candidate.getUnsatisifiedConnections().size();
            if (unsatisfied2 < unsatisfied1) {
                bestResult = candidate;
                continue;
            }
            if (unsatisfied2 != unsatisfied1) continue;
            int dist1 = bestResult.getTotalDistance();
            int dist2 = candidate.getTotalDistance();
            if (dist2 >= dist1) continue;
            bestResult = candidate;
        }
        if (bestResult == null) {
            bestResult = new MoveResult(req, new ReplacementMap(), impossible, 0);
        } else {
            bestResult.addUnsatisfiedConnections(impossible);
        }
        return bestResult;
    }

    private static ArrayList<Location> convertToPath(SearchNode last) {
        SearchNode next = last;
        ArrayList<Location> ret = new ArrayList<Location>();
        ret.add(next.getLocation());
        for (SearchNode prev = last.getPrevious(); prev != null; prev = prev.getPrevious()) {
            if (prev.getDirection() != next.getDirection()) {
                ret.add(prev.getLocation());
            }
            next = prev;
        }
        if (!((Location)ret.get(ret.size() - 1)).equals(next.getLocation())) {
            ret.add(next.getLocation());
        }
        Collections.reverse(ret);
        return ret;
    }

    private static SearchNode findShortestPath(List<SearchNode> nodes, Set<Location> pathLocs, AvoidanceMap avoid) {
        PriorityQueue<SearchNode> q = new PriorityQueue<SearchNode>(nodes);
        HashSet<SearchNode> visited = new HashSet<SearchNode>();
        int iters = 0;
        while (!q.isEmpty() && iters < 20000) {
            SearchNode node = (SearchNode)q.remove();
            if (++iters % 64 == 0 && ConnectorThread.isOverrideRequested() || node == null) {
                return null;
            }
            if (node.isDestination()) {
                return node;
            }
            boolean added = visited.add(node);
            if (!added) continue;
            Location loc = node.getLocation();
            Direction dir = node.getDirection();
            int neighbors = 3;
            Object allowed = avoid.get(loc);
            if (allowed != null && node.isStart() && pathLocs.contains(loc)) {
                allowed = null;
            }
            if (allowed == ALLOW_NEITHER) {
                neighbors = 0;
            } else if (allowed == ALLOW_VERTICAL) {
                if (dir == null) {
                    dir = Direction.NORTH;
                    neighbors = 2;
                } else {
                    neighbors = dir == Direction.NORTH || dir == Direction.SOUTH ? 1 : 0;
                }
            } else if (allowed == ALLOW_HORIZONTAL) {
                if (dir == null) {
                    dir = Direction.EAST;
                    neighbors = 2;
                } else {
                    neighbors = dir == Direction.EAST || dir == Direction.WEST ? 1 : 0;
                }
            } else if (dir == null) {
                dir = Direction.NORTH;
                neighbors = 4;
            } else {
                neighbors = 3;
            }
            for (int i = 0; i < neighbors; ++i) {
                Direction oDir = switch (i) {
                    case 0 -> dir;
                    case 1 -> {
                        if (neighbors == 2) {
                            yield dir.reverse();
                        }
                        yield dir.getLeft();
                    }
                    case 2 -> dir.getRight();
                    default -> dir.reverse();
                };
                SearchNode nextSearchNode = node.next(oDir, allowed != null);
                if (nextSearchNode == null || visited.contains(nextSearchNode)) continue;
                q.add(nextSearchNode);
            }
        }
        return null;
    }

    private static void processConnection(ConnectionData conn, int dx, int dy, Set<Location> connLocs, List<SearchNode> connNodes, AvoidanceMap selAvoid) {
        Location cur = conn.getLocation();
        Location dest = cur.translate(dx, dy);
        if (selAvoid.get(cur) == null) {
            Direction preferred = conn.getDirection();
            if (preferred == null) {
                preferred = Math.abs(dx) > Math.abs(dy) ? (dx > 0 ? Direction.EAST : Direction.WEST) : (dy > 0 ? Direction.SOUTH : Direction.NORTH);
            }
            connLocs.add(cur);
            connNodes.add(new SearchNode(conn, cur, preferred, dest));
        }
        for (Wire wire : conn.getWirePath()) {
            for (Location loc : wire) {
                boolean added;
                if (selAvoid.get(loc) != null && !loc.equals(dest) || !(added = connLocs.add(loc))) continue;
                Direction dir = null;
                if (wire.endsAt(loc)) {
                    int x1;
                    int x0;
                    int y1;
                    int y0;
                    dir = wire.isVertical() ? ((y0 = loc.getY()) < (y1 = wire.getOtherEnd(loc).getY()) ? Direction.NORTH : Direction.SOUTH) : ((x0 = loc.getX()) < (x1 = wire.getOtherEnd(loc).getX()) ? Direction.WEST : Direction.EAST);
                }
                connNodes.add(new SearchNode(conn, loc, dir, dest));
            }
        }
    }

    private static void processPath(List<Location> path, ConnectionData conn, AvoidanceMap avoid, ReplacementMap repl, Set<Location> unmarkable) {
        Iterator<Location> pathIt = path.iterator();
        Location loc0 = pathIt.next();
        if (!loc0.equals(conn.getLocation())) {
            Location pathLoc = conn.getWirePathStart();
            boolean found = loc0.equals(pathLoc);
            for (Wire wire : conn.getWirePath()) {
                Location nextLoc = wire.getOtherEnd(pathLoc);
                if (found) {
                    repl.remove(wire);
                    avoid.unmarkWire(wire, nextLoc, unmarkable);
                } else if (wire.contains(loc0)) {
                    found = true;
                    if (!loc0.equals(nextLoc)) {
                        avoid.unmarkWire(wire, nextLoc, unmarkable);
                        Wire shortenedWire = Wire.create(pathLoc, loc0);
                        repl.replace(wire, shortenedWire);
                        avoid.markWire(shortenedWire, 0, 0);
                    }
                }
                pathLoc = nextLoc;
            }
        }
        while (pathIt.hasNext()) {
            Location loc1 = pathIt.next();
            Wire newWire = Wire.create(loc0, loc1);
            repl.add(newWire);
            avoid.markWire(newWire, 0, 0);
            loc0 = loc1;
        }
    }

    private static List<ConnectionData> pruneImpossible(List<ConnectionData> connects, AvoidanceMap avoid, int dx, int dy) {
        ArrayList<Wire> pathWires = new ArrayList<Wire>();
        for (ConnectionData conn : connects) {
            pathWires.addAll(conn.getWirePath());
        }
        ArrayList<ConnectionData> impossible = new ArrayList<ConnectionData>();
        Iterator<ConnectionData> it = connects.iterator();
        while (it.hasNext()) {
            ConnectionData conn = it.next();
            Location dest = conn.getLocation().translate(dx, dy);
            if (avoid.get(dest) == null) continue;
            boolean isInPath = false;
            for (Wire wire : pathWires) {
                if (!wire.contains(dest)) continue;
                isInPath = true;
                break;
            }
            if (isInPath) continue;
            it.remove();
            impossible.add(conn);
        }
        return impossible;
    }

    private static void sortConnects(List<ConnectionData> connects, int dx, int dy) {
        connects.sort((ac, bc) -> {
            Location a = ac.getLocation();
            Location b = bc.getLocation();
            int abx = a.getX() - b.getX();
            int aby = a.getY() - b.getY();
            return abx * dx + aby * dy;
        });
    }

    private static MoveResult tryList(MoveRequest req, MoveGesture gesture, List<ConnectionData> connects, int dx, int dy, Map<ConnectionData, Set<Location>> pathLocs, Map<ConnectionData, List<SearchNode>> initNodes, long stopTime) {
        AvoidanceMap avoid = gesture.getFixedAvoidanceMap().cloneMap();
        avoid.markAll(gesture.getSelected(), dx, dy);
        ReplacementMap replacements = new ReplacementMap();
        ArrayList<ConnectionData> unconnected = new ArrayList<ConnectionData>();
        int totalDistance = 0;
        for (ConnectionData conn : connects) {
            Set<Location> connPathLocs;
            if (ConnectorThread.isOverrideRequested()) {
                return null;
            }
            if (System.currentTimeMillis() - stopTime > 0L) {
                unconnected.add(conn);
                continue;
            }
            List<SearchNode> connNodes = initNodes.get(conn);
            SearchNode node = Connector.findShortestPath(connNodes, connPathLocs = pathLocs.get(conn), avoid);
            if (node != null) {
                totalDistance += node.getDistance();
                ArrayList<Location> path = Connector.convertToPath(node);
                Connector.processPath(path, conn, avoid, replacements, connPathLocs);
                continue;
            }
            if (ConnectorThread.isOverrideRequested()) {
                return null;
            }
            unconnected.add(conn);
        }
        return new MoveResult(req, replacements, unconnected, totalDistance);
    }
}

