/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.LibraryUtil;
import java.util.Collections;
import java.util.List;

public abstract class Library {
    private boolean hidden = false;

    public boolean contains(ComponentFactory query) {
        return this.indexOf(query) >= 0;
    }

    public boolean containsFromSource(Tool query) {
        for (Tool tool : this.getTools()) {
            if (!tool.sharesSource(query)) continue;
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        return LibraryUtil.getName(this.getClass());
    }

    public List<Library> getLibraries() {
        return Collections.emptyList();
    }

    public Library getLibrary(String name) {
        for (Library lib : this.getLibraries()) {
            if (!lib.getName().equals(name)) continue;
            return lib;
        }
        return null;
    }

    public boolean removeLibrary(String name) {
        return false;
    }

    public Tool getTool(String name) {
        for (Tool tool : this.getTools()) {
            if (!tool.getName().equals(name)) continue;
            return tool;
        }
        return null;
    }

    public abstract List<? extends Tool> getTools();

    public int indexOf(ComponentFactory query) {
        int index = -1;
        for (Tool tool : this.getTools()) {
            AddTool tool2;
            ++index;
            if (!(tool instanceof AddTool) || (tool2 = (AddTool)tool).getFactory() != query) continue;
            return index;
        }
        return -1;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden() {
        this.hidden = true;
    }

    public String toString() {
        return this.getName();
    }
}

