/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.tools.FactoryDescription;
import com.cburch.logisim.tools.Library;
import java.util.ArrayList;
import java.util.List;

public class FactoryAttributes
implements AttributeSet,
AttributeListener,
Cloneable {
    private final Class<? extends Library> descBase;
    private final FactoryDescription desc;
    private ComponentFactory factory;
    private AttributeSet baseAttrs;
    private final ArrayList<AttributeListener> listeners;

    public FactoryAttributes(Class<? extends Library> descBase, FactoryDescription desc) {
        this.descBase = descBase;
        this.desc = desc;
        this.factory = null;
        this.baseAttrs = null;
        this.listeners = new ArrayList();
    }

    public FactoryAttributes(ComponentFactory factory) {
        this.descBase = null;
        this.desc = null;
        this.factory = factory;
        this.baseAttrs = null;
        this.listeners = new ArrayList();
    }

    @Override
    public void addAttributeListener(AttributeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void attributeListChanged(AttributeEvent baseEvent) {
        AttributeEvent e = null;
        for (AttributeListener l : this.listeners) {
            if (e == null) {
                e = new AttributeEvent(this, baseEvent.getAttribute(), baseEvent.getValue(), baseEvent.getOldValue());
            }
            l.attributeListChanged(e);
        }
    }

    @Override
    public void attributeValueChanged(AttributeEvent baseEvent) {
        AttributeEvent e = null;
        for (AttributeListener l : this.listeners) {
            if (e == null) {
                e = new AttributeEvent(this, baseEvent.getAttribute(), baseEvent.getValue(), baseEvent.getOldValue());
            }
            l.attributeValueChanged(e);
        }
    }

    @Override
    public AttributeSet clone() {
        return (AttributeSet)this.getBase().clone();
    }

    @Override
    public boolean containsAttribute(Attribute<?> attr) {
        return this.getBase().containsAttribute(attr);
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        return this.getBase().getAttribute(name);
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return this.getBase().getAttributes();
    }

    public ComponentFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        return this.desc.getFactory(this.descBase);
    }

    public AttributeSet getBase() {
        AttributeSet ret = this.baseAttrs;
        if (ret == null) {
            ComponentFactory fact = this.factory;
            if (fact == null) {
                this.factory = fact = this.desc.getFactory(this.descBase);
            }
            if (fact == null) {
                ret = AttributeSets.EMPTY;
            } else {
                ret = fact.createAttributeSet();
                ret.addAttributeListener(this);
            }
            this.baseAttrs = ret;
        }
        return ret;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        return this.getBase().getValue(attr);
    }

    boolean isFactoryInstantiated() {
        return this.baseAttrs != null;
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        return this.getBase().isReadOnly(attr);
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return this.getBase().isToSave(attr);
    }

    @Override
    public void removeAttributeListener(AttributeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setReadOnly(Attribute<?> attr, boolean value) {
        this.getBase().setReadOnly(attr, value);
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        this.getBase().setValue(attr, value);
    }
}

