/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.fpga.hdlgenerator.InlinedHdlGeneratorFactory;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import java.awt.Color;
import java.awt.Graphics2D;

public class DoNotConnect
extends InstanceFactory {
    public static final String _ID = "NoConnect";

    public DoNotConnect() {
        super(_ID, Strings.S.getter("noConnectionComponent"), new InlinedHdlGeneratorFactory());
        this.setIconName("noconnect.gif");
        this.setAttributes(new Attribute[]{StdAttr.WIDTH}, new Object[]{BitWidth.ONE});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
        this.setPorts(new Port[]{new Port(0, 0, "inout", StdAttr.WIDTH)});
    }

    private void drawInstance(InstancePainter painter, boolean isGhost) {
        Graphics2D g = (Graphics2D)painter.getGraphics().create();
        Location loc = painter.getLocation();
        g.setColor(isGhost ? Color.GRAY : Color.RED);
        g.drawLine(loc.getX() - 5, loc.getY() - 5, loc.getX() + 5, loc.getY() + 5);
        g.drawLine(loc.getX() - 5, loc.getY() + 5, loc.getX() + 5, loc.getY() - 5);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        return Bounds.create(-5, -5, 10, 10);
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        this.drawInstance(painter, true);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        this.drawInstance(painter, false);
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
    }
}

