/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.wiring.BitExtenderHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class BitExtender
extends InstanceFactory {
    public static final String _ID = "Bit Extender";
    private static final Attribute<BitWidth> ATTR_IN_WIDTH = Attributes.forBitWidth("in_width", Strings.S.getter("extenderInAttr"));
    private static final Attribute<BitWidth> ATTR_OUT_WIDTH = Attributes.forBitWidth("out_width", Strings.S.getter("extenderOutAttr"));
    static final Attribute<AttributeOption> ATTR_TYPE = Attributes.forOption("type", Strings.S.getter("extenderTypeAttr"), new AttributeOption[]{new AttributeOption("zero", "zero", Strings.S.getter("extenderZeroType")), new AttributeOption("one", "one", Strings.S.getter("extenderOneType")), new AttributeOption("sign", "sign", Strings.S.getter("extenderSignType")), new AttributeOption("input", "input", Strings.S.getter("extenderInputType"))});
    public static final BitExtender FACTORY = new BitExtender();

    public BitExtender() {
        super(_ID, Strings.S.getter("extenderComponent"), new BitExtenderHdlGeneratorFactory());
        this.setIconName("extender.gif");
        this.setAttributes(new Attribute[]{ATTR_IN_WIDTH, ATTR_OUT_WIDTH, ATTR_TYPE}, new Object[]{BitWidth.create(8), BitWidth.create(16), ATTR_TYPE.parse("sign")});
        this.setFacingAttribute(StdAttr.FACING);
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(ATTR_OUT_WIDTH), new BitWidthConfigurator(ATTR_IN_WIDTH, 1, 64, 0)));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        this.configurePorts(instance);
        instance.addAttributeListener();
    }

    private void configurePorts(Instance instance) {
        Port p0 = new Port(0, 0, "output", ATTR_OUT_WIDTH);
        Port p1 = new Port(-40, 0, "input", ATTR_IN_WIDTH);
        String type = this.getType(instance.getAttributeSet());
        if (type.equals("input")) {
            instance.setPorts(new Port[]{p0, p1, new Port(-20, -20, "input", 1)});
        } else {
            instance.setPorts(new Port[]{p0, p1});
        }
    }

    private String getType(AttributeSet attrs) {
        AttributeOption topt = attrs.getValue(ATTR_TYPE);
        return (String)topt.getValue();
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == ATTR_TYPE) {
            this.configurePorts(instance);
        }
        instance.fireInvalidated();
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        String type;
        Graphics g = painter.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        int asc = fm.getAscent();
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        String s0 = switch (type = this.getType(painter.getAttributeSet())) {
            case "zero" -> Strings.S.get("extenderZeroLabel");
            case "one" -> Strings.S.get("extenderOneLabel");
            case "sign" -> Strings.S.get("extenderSignLabel");
            case "input" -> Strings.S.get("extenderInputLabel");
            default -> "???";
        };
        String s1 = Strings.S.get("extenderMainLabel");
        Bounds bds = painter.getBounds();
        int x = bds.getX() + bds.getWidth() / 2;
        int y0 = bds.getY() + (bds.getHeight() / 2 + asc) / 2;
        int y1 = bds.getY() + (3 * bds.getHeight() / 2 + asc) / 2;
        GraphicsUtil.drawText(g, s0, x, y0, 0, 1);
        GraphicsUtil.drawText(g, s1, x, y1, 0, 1);
        BitWidth w0 = painter.getAttributeValue(ATTR_OUT_WIDTH);
        BitWidth w1 = painter.getAttributeValue(ATTR_IN_WIDTH);
        painter.drawPort(0, "" + w0.getWidth(), Direction.WEST);
        painter.drawPort(1, "" + w1.getWidth(), Direction.EAST);
        if (type.equals("input")) {
            painter.drawPort(2);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        Value extend;
        String type;
        Value in = state.getPortValue(1);
        BitWidth wout = state.getAttributeValue(ATTR_OUT_WIDTH);
        switch (type = this.getType(state.getAttributeSet())) {
            case "one": {
                extend = Value.TRUE;
                break;
            }
            case "sign": {
                int win = in.getWidth();
                extend = win > 0 ? in.get(win - 1) : Value.ERROR;
                break;
            }
            case "input": {
                extend = state.getPortValue(2);
                if (extend.getWidth() == 1) break;
                extend = Value.ERROR;
                break;
            }
            default: {
                extend = Value.FALSE;
            }
        }
        Value out = in.extendWidth(wout.getWidth(), extend);
        state.setPort(0, out, 1);
    }
}

