/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.Ttl7464HdlGenerator;
import java.awt.Graphics;

public class Ttl7464
extends AbstractTtlGate {
    public static final String _ID = "7464";

    public Ttl7464() {
        super(_ID, (byte)14, new byte[]{8}, new String[]{"A", "E", "F", "G", "H", "I", "Y", "J", "K", "B", "C", "D"}, 70, (HdlGeneratorFactory)new Ttl7464HdlGenerator());
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        int[] posY;
        int[] posX;
        super.paintBase(painter, false, false);
        boolean isIEC = AppPreferences.GATE_SHAPE.get().equals("rectangular");
        int AndOffset = isIEC ? 10 : 0;
        Graphics gfx = painter.getGraphics();
        Drawgates.paintOr(gfx, x + 125, y + 35, 10, isIEC ? 40 : 10, true, false);
        Drawgates.paintAnd(gfx, x + 105 + AndOffset, y + 20, 10, 10, false);
        Drawgates.paintAnd(gfx, x + 105 + AndOffset, y + 30, 10, 10, false);
        Drawgates.paintAnd(gfx, x + 105 + AndOffset, y + 40, 10, 10, false);
        Drawgates.paintAnd(gfx, x + 105 + AndOffset, y + 50, 10, 10, false);
        gfx.drawLine(x + 129, y + 35, x + 130, y + 35);
        gfx.drawLine(x + 130, y + 35, x + 130, y + 7);
        for (int i = 0; i < 4; ++i) {
            if (!isIEC) {
                int tmpOff = i == 0 || i == 3 ? 2 : 0;
                posX = new int[]{x + 105, x + 107 + tmpOff, x + 107 + tmpOff, x + 111};
                posY = new int[]{y + 20 + i * 10, y + 20 + i * 10, y + 32 + i * 2, y + 32 + i * 2};
                gfx.drawPolyline(posX, posY, 4);
            }
            posX = new int[]{x + 10 + i * 20, x + 10 + i * 20, x + 95 + AndOffset};
            posY = new int[]{i == 0 ? y + height - 7 : y + 7, y + 33 - i * 2, y + 33 - i * 2};
            gfx.drawPolyline(posX, posY, 3);
            if (i >= 2) continue;
            posX = new int[]{x + 30 + i * 20, x + 30 + i * 20, x + 95 + AndOffset};
            posY = new int[]{y + height - 7, y + 38 + i * 5, y + 38 + i * 5};
            gfx.drawPolyline(posX, posY, 3);
            posX = new int[]{x + 70 + i * 20, x + 70 + i * 20, x + 95 + AndOffset};
            posY = new int[]{y + height - 7, y + 47 + i * 3, y + 47 + i * 3};
            gfx.drawPolyline(posX, posY, 3);
        }
        posX = new int[]{x + 90, x + 90, x + 95 + AndOffset};
        posY = new int[]{y + 7, y + 23, y + 23};
        gfx.drawPolyline(posX, posY, 3);
        posX = new int[]{x + 110, x + 110, x + 93 + AndOffset, x + 93 + AndOffset, x + 95 + AndOffset};
        posY = new int[]{y + 7, y + 12, y + 12, y + 18, y + 18};
        gfx.drawPolyline(posX, posY, 5);
        posY = new int[]{y + height - 7, y + height - 12, y + height - 12, y + 53, y + 53};
        gfx.drawPolyline(posX, posY, 5);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        Value val1 = state.getPortValue(1).and(state.getPortValue(2));
        Value val2 = state.getPortValue(3).and(state.getPortValue(4).and(state.getPortValue(5)));
        Value val3 = state.getPortValue(7).and(state.getPortValue(8));
        Value val4 = state.getPortValue(9).and(state.getPortValue(10).and(state.getPortValue(11).and(state.getPortValue(0))));
        Value val5 = val1.or(val2.or(val3.or(val4)));
        state.setPort(6, val5.not(), 7);
    }
}

