/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.plexers.PlexersLibrary;
import com.cburch.logisim.util.LineBuffer;
import java.util.SortedMap;
import java.util.TreeMap;

public class PriorityEncoderHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_SELECT_BITS_STRING = "nrOfSelectBits";
    private static final int NR_OF_SELECT_BITS_ID = -1;
    private static final String NR_OF_INPUT_BITS_STRING = "nrOfInputBits";
    private static final int NR_OF_INPUT_BITS_ID = -2;

    public PriorityEncoderHdlGeneratorFactory() {
        this.myParametersList.add(NR_OF_INPUT_BITS_STRING, -2, 8, PlexersLibrary.ATTR_SELECT).add(NR_OF_SELECT_BITS_STRING, -1, 6, PlexersLibrary.ATTR_SELECT);
        this.myWires.addWire("s_inIsZero", 1).addWire("s_address", 6).addWire("s_selectVector0", 64).addWire("s_selectVector1", 32).addWire("s_selectVector2", 16).addWire("s_selectVector3", 8).addWire("s_selectVector4", 4);
        this.myPorts.add("input", "enable", 1, 0).add("input", "inputVector", -2, 0).add("output", "groupSelect", 1, 0).add("output", "enableOut", 1, 0).add("output", "address", -1, 0);
    }

    public SortedMap<String, String> getPortMap(Netlist nets, Object mapInfo) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (!(mapInfo instanceof netlistComponent)) {
            return map;
        }
        netlistComponent comp = (netlistComponent)mapInfo;
        int nrOfBits = comp.nrOfEnds() - 4;
        map.putAll(Hdl.getNetMap("enable", false, comp, nrOfBits + 1, nets));
        StringBuilder vectorList = new StringBuilder();
        for (int i = nrOfBits - 1; i >= 0; --i) {
            if (Hdl.isVhdl()) {
                map.putAll(Hdl.getNetMap("inputVector(" + i + ")", true, comp, i, nets));
                continue;
            }
            if (vectorList.length() > 0) {
                vectorList.append(",");
            }
            vectorList.append(Hdl.getNetName(comp, i, true, nets));
        }
        if (Hdl.isVerilog()) {
            map.put("inputVector", vectorList.toString());
        }
        map.putAll(Hdl.getNetMap("groupSelect", true, comp, nrOfBits + 3, nets));
        map.putAll(Hdl.getNetMap("enableOut", true, comp, nrOfBits + 2, nets));
        map.putAll(Hdl.getNetMap("address", true, comp, nrOfBits + 0, nets));
        return map;
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist nets, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer().pair("selBits", NR_OF_SELECT_BITS_STRING).pair("inBits", NR_OF_INPUT_BITS_STRING);
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("-- Output Signals\ngroupSelect <= {{not}}(s_inIsZero) {{and}} enable;\nenableOut   <= s_inIsZero {{and}} enable;\naddress     <= ({{others}} => '0') {{when}} enable = '0' {{else}}\n               s_address({{selBits}}-1 {{downto}} 0);\n\n-- Control Signals\ns_inIsZero  <= '1' {{when}} inputVector = std_logic_vector(to_unsigned(0,{{inBits}})) {{else}} '0';\n\n-- Processes\nmakeAddr : {{process}}(inputVector, s_selectVector0, s_selectVector1, s_selectVector2, s_selectVector3, s_selectVector4) {{is}}\n{{begin}}\n   s_selectVector0(63 {{downto}} {{inBits}})  <= ({{others}} => '0');\n   s_selectVector0({{inBits}}-1 {{downto}} 0) <= inputVector;\n   {{if}} (s_selectVector0(63 {{downto}} 32) = X\"00000000\") {{then}} s_address(5)      <= '0';\n                                                         s_selectVector1 <= s_selectVector0(31 {{downto}} 0);\n                                                    {{else}} s_address(5)      <= '1';\n                                                         s_selectVector1 <= s_selectVector0(63 {{downto}} 32);\n   {{end}} {{if}};\n   {{if}} (s_selectVector1(31 {{downto}} 16) = X\"0000\") {{then}} s_address(4)      <= '0';\n                                                     s_selectVector2 <= s_selectVector1(15 {{downto}} 0);\n                                                {{else}} s_address(4)      <= '1';\n                                                     s_selectVector2 <= s_selectVector1(31 {{downto}} 16);\n   {{end}} {{if}};\n   {{if}} (s_selectVector2(15 {{downto}} 8) = X\"00\") {{then}} s_address(3)      <= '0';\n                                                  s_selectVector3 <= s_selectVector2(7 {{downto}} 0);\n                                             {{else}} s_address(3)      <= '1';\n                                                  s_selectVector3 <= s_selectVector2(15 {{downto}} 8);\n   {{end}} {{if}};\n   {{if}} (s_selectVector3(7 {{downto}} 4) = X\"0\") {{then}} s_address(2)      <= '0';\n                                                s_selectVector4 <= s_selectVector3(3 {{downto}} 0);\n                                           {{else}} s_address(2)      <= '1';\n                                                s_selectVector4 <= s_selectVector3(7 {{downto}} 4);\n   {{end}} {{if}};\n   {{if}} (s_selectVector4(3 {{downto}} 2) = \"00\") {{then}} s_address(1) <= '0';\n                                                s_address(0) <= s_selectVector4(1);\n                                           {{else}} s_address(1) <= '1';\n                                                s_address(0) <= s_selectVector4(3);\n   {{end}} {{if}};\n{{end}} {{process}} makeAddr;\n");
        } else {
            contents.add("assign groupSelect = ~s_inIsZero&enable;\nassign enableOut = s_inIsZero&enable;\nassign address = (~enable) ? 0 : s_address[{{selBits}}-1:0];\nassign s_inIsZero = (inputVector == 0) ? 1'b1 : 1'b0;\n\nassign s_selectVector0[63:{{selBits}}] = 0;\nassign s_selectVector0[{{selBits}}-1:0] = inputVector;\nassign s_address[5] = (s_selectVector0[63:32] == 0) ? 1'b0 : 1'b1;\nassign s_selectVector1 = (s_selectVector0[63:32] == 0) ? s_selectVector0[31:0] : s_selectVector0[63:32];\nassign s_address[4] = (s_selectVector1[31:16] == 0) ? 1'b0 : 1'b1;\nassign s_selectVector2 = (s_selectVector1[31:16] == 0) ? s_selectVector1[15:0] : s_selectVector1[31:16];\nassign s_address[3] = (s_selectVector2[15:8] == 0) ? 1'b0 : 1'b1;\nassign s_selectVector3 = (s_selectVector2[15:8] == 0) ? s_selectVector2[7:0] : s_selectVector2[15:8];\nassign s_address[2] = (s_selectVector3[7:4] == 0) ? 1'b0 : 1'b1;\nassign s_selectVector4 = (s_selectVector3[7:4] == 0) ? s_selectVector3[3:0] : s_selectVector2[7:4];\nassign s_address[1] = (s_selectVector4[3:2] == 0) ? 1'b0 : 1'b1;\nassign s_address[0] = (s_selectVector4[3:2] == 0) ? s_selectVector4[1] : s_selectVector4[3];\n");
        }
        return contents.empty();
    }
}

