/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.plexers.BitSelector;
import com.cburch.logisim.util.LineBuffer;

public class BitSelectorHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String INPUT_BITS_STRING = "nrOfInputBits";
    private static final int INPUT_BITS_ID = -1;
    private static final String OUTPUTS_BITS_STRING = "nrOfOutputBits";
    private static final int OUTPUT_BITS_ID = -2;
    private static final String SELECT_BITS_STRING = "nrOfselBits";
    private static final int SELECT_BITS_ID = -3;
    private static final String EXTENDED_BITS_STRING = "nrOfExtendedBits";
    private static final int EXTENDED_BITS_ID = -4;

    public BitSelectorHdlGeneratorFactory() {
        this.myParametersList.add(SELECT_BITS_STRING, -3, 6, BitSelector.SELECT_ATTR).add(INPUT_BITS_STRING, -1).add(EXTENDED_BITS_STRING, -4, 6, BitSelector.EXTENDED_ATTR).addBusOnly(BitSelector.GROUP_ATTR, OUTPUTS_BITS_STRING, -2);
        this.myWires.addWire("s_extendedVector", -4);
        this.myPorts.add("input", "dataIn", -1, 1).add("input", "sel", -3, 2).add("output", "dataOut", -2, 0, BitSelector.GROUP_ATTR);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer().pair("extBits", EXTENDED_BITS_STRING).pair("inBits", INPUT_BITS_STRING).pair("outBits", OUTPUTS_BITS_STRING);
        int outputBits = attrs.getValue(BitSelector.GROUP_ATTR).getWidth();
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("s_extendedVector(({{extBits}}-1) {{downto}} {{inBits}}) <= ({{others}} => '0');\ns_extendedVector(({{inBits}}-1) {{downto}} 0) <= dataIn;\n").add(outputBits > 1 ? "dataOut <= s_extendedVector( ((to_integer(unsigned(sel))+1) * {{outBits}})-1 {{downto}} to_integer(unsigned(sel))*{{outBits}} );" : "dataOut <= s_extendedVector( to_integer(unsigned(sel)) );");
        } else {
            contents.add("assign s_extendedVector[{{extBits}}-1:{{inBits}}] = 0;\nassign s_extendedVector[{{inBits}}-1:0] = dataIn;\n");
            if (outputBits > 1) {
                contents.add("wire[513:0] s_selectVector;\nreg[{{outBits}}-1:0] s_selected_slice;\nassign s_selectVector[513:{{extBits}}] = 0;\nassign s_selectVector[{{extBits}}-1:0] = s_extendedVector;\nassign dataOut = s_selected_slice;\n\nalways @(*)\nbegin\n   case (sel)\n");
                for (int i = 15; i > 0; --i) {
                    contents.add("{{1}}{{2}} : s_selected_slice <= s_selectVector[({{3}}*{{outBits}})-1:{{2}}*{{outBits}}];", LineBuffer.getIndent(2), i, i + 1);
                }
                contents.add("      default : s_selected_slice <= s_selectVector[{{outBits}}-1:0];\n   endcase\nend\n");
            } else {
                contents.add("assign dataOut = s_extendedVector[sel];");
            }
        }
        return contents.empty();
    }
}

