/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.gui.icons.FlipFlopIcon;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.AbstractFlipFlop;
import com.cburch.logisim.std.memory.AbstractFlipFlopHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;

public class TFlipFlop
extends AbstractFlipFlop {
    public static final String _ID = "T Flip-Flop";

    public TFlipFlop() {
        super(_ID, new FlipFlopIcon(1), Strings.S.getter("tFlipFlopComponent"), 1, false, (HdlGeneratorFactory)new TFFHDLGeneratorFactory());
    }

    @Override
    protected Value computeValue(Value[] inputs, Value curValue) {
        if (curValue == Value.UNKNOWN) {
            curValue = Value.FALSE;
        }
        if (inputs[0] == Value.TRUE) {
            return curValue.not();
        }
        return curValue;
    }

    @Override
    protected String getInputName(int index) {
        return "T";
    }

    private static class TFFHDLGeneratorFactory
    extends AbstractFlipFlopHdlGeneratorFactory {
        public TFFHDLGeneratorFactory() {
            super(1, StdAttr.EDGE_TRIGGER);
            this.myPorts.add("input", "t", 1, 0);
        }

        @Override
        public LineBuffer getUpdateLogic() {
            return LineBuffer.getHdlBuffer().add("{{assign}}s_nextState{{=}}s_currentState{{xor}}t;");
        }
    }
}

