/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.draw.shapes.SvgCreator;
import com.cburch.draw.shapes.SvgReader;
import com.cburch.draw.util.EditableLabel;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.base.Text;
import com.cburch.logisim.std.memory.RegisterData;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RegisterShape
extends DynamicElement {
    static final Font DEFAULT_FONT = new Font("monospaced", 0, 10);
    private final EditableLabel label;

    public RegisterShape(int x, int y, DynamicElement.Path p) {
        super(p, Bounds.create(x, y, 1, 1));
        this.label = new EditableLabel(x, y, "0", DEFAULT_FONT);
        this.label.setColor(Color.BLACK);
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(9);
        this.calculateBounds();
    }

    void calculateBounds() {
        BitWidth widthVal = this.path.leaf().getAttributeSet().getValue(StdAttr.WIDTH);
        int width = widthVal == null ? 8 : widthVal.getWidth();
        String zeros = StringUtil.toHexString(width, 0L);
        this.label.setText(zeros);
        int x = this.bounds.getX();
        int y = this.bounds.getY();
        this.bounds = StringUtil.estimateBounds(zeros, this.label.getFont()).translate(x, y);
        this.label.setLocation(this.bounds.getCenterX(), this.bounds.getCenterY());
    }

    @Override
    public void translate(int dx, int dy) {
        super.translate(dx, dy);
        this.label.setLocation(this.bounds.getX(), this.bounds.getY());
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return UnmodifiableList.create(new Attribute[]{Text.ATTR_FONT, ATTR_LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR});
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == Text.ATTR_FONT) {
            return (V)this.label.getFont();
        }
        return super.getValue(attr);
    }

    @Override
    public void updateValue(Attribute<?> attr, Object value) {
        if (attr == Text.ATTR_FONT) {
            this.label.setFont((Font)value);
            this.calculateBounds();
        }
    }

    @Override
    public void paintDynamic(Graphics g, CircuitState state) {
        this.calculateBounds();
        int x = this.bounds.getX();
        int y = this.bounds.getY();
        int w = this.bounds.getWidth();
        int h = this.bounds.getHeight();
        GraphicsUtil.switchToWidth(g, 1);
        if (state == null) {
            g.setColor(Color.lightGray);
            g.fillRect(x, y, w, h);
        }
        g.setColor(Color.BLACK);
        g.drawRect(x, y, w, h);
        if (state != null) {
            BitWidth widthVal = this.path.leaf().getAttributeSet().getValue(StdAttr.WIDTH);
            int width = widthVal == null ? 8 : widthVal.getWidth();
            RegisterData data = (RegisterData)this.getData(state);
            long val = data == null ? 0L : data.value.toLongValue();
            this.label.setText(StringUtil.toHexString(width, val));
        }
        this.label.paint(g);
        this.drawLabel(g);
    }

    @Override
    public Element toSvgElement(Document doc) {
        return this.toSvgElement(doc.createElement("visible-register"));
    }

    @Override
    public Element toSvgElement(Element ret) {
        ret = super.toSvgElement(ret);
        Font font = this.label.getFont();
        if (!font.equals(DEFAULT_FONT)) {
            SvgCreator.setFontAttribute(ret, font, "value-");
        }
        return ret;
    }

    @Override
    public void parseSvgElement(Element elt) {
        super.parseSvgElement(elt);
        this.setValue(Text.ATTR_FONT, SvgReader.getFontAttribute(elt, "value-", "monospaced", 10));
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("registerComponent");
    }

    public String toString() {
        return "Register:" + String.valueOf(this.getBounds());
    }
}

