/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io.extra;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceDataSingleton;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class Switch
extends InstanceFactory {
    public static final String _ID = "Switch";
    private static final int DEPTH = 3;

    public Switch() {
        super(_ID, Strings.S.getter("switchComponent"));
        this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.WIDTH, IoLibrary.ATTR_COLOR, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT}, new Object[]{Direction.EAST, BitWidth.ONE, Color.WHITE, "", Direction.NORTH, StdAttr.DEFAULT_LABEL_FONT});
        this.setFacingAttribute(StdAttr.FACING);
        this.setIconName("switch.gif");
        this.setKeyConfigurator(new DirectionConfigurator(StdAttr.LABEL_LOC, 512));
        this.setInstancePoker(Poker.class);
        this.setInstanceLogger(Logger.class);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        instance.computeLabelTextField(10);
        this.updateports(instance);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        return Bounds.create(-20, -15, 20, 30).rotate(Direction.EAST, facing, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            instance.computeLabelTextField(10);
            this.updateports(instance);
        } else if (attr == StdAttr.WIDTH) {
            this.updateports(instance);
        } else if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(10);
        }
    }

    private void paint(InstancePainter painter, boolean ghost) {
        Bounds bds = painter.getBounds();
        int x = bds.getX();
        int y = bds.getY();
        int w = bds.getWidth();
        int h = bds.getHeight();
        int circle = 4;
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        if (!ghost) {
            painter.drawPort(facing == Direction.SOUTH || facing == Direction.EAST ? 0 : 1);
        }
        boolean active = false;
        if (painter.getShowState() && !ghost) {
            InstanceDataSingleton data = (InstanceDataSingleton)painter.getData();
            active = data != null && (Boolean)data.getValue() != false;
        }
        Color color = painter.getAttributeValue(IoLibrary.ATTR_COLOR);
        if (!painter.shouldDrawColor()) {
            int hue = (color.getRed() + color.getGreen() + color.getBlue()) / 3;
            color = new Color(hue, hue, hue);
        }
        Graphics g = painter.getGraphics();
        if (active) {
            int[] yr;
            int[] xr;
            int[] yp;
            int[] xp;
            if (facing == Direction.NORTH || facing == Direction.WEST) {
                Location p = painter.getLocation();
                int px = p.getX();
                int py = p.getY();
                GraphicsUtil.switchToWidth(g, 3);
                g.setColor(Value.trueColor);
                if (facing == Direction.NORTH) {
                    g.drawLine(px, py, px, py + 10);
                } else {
                    g.drawLine(px, py, px + 10, py);
                }
                GraphicsUtil.switchToWidth(g, 1);
            }
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                xp = new int[]{x, x + w - 3, x + w, x + w, x};
                yp = new int[]{y + 3, y, y + 3, y + h, y + h};
                xr = new int[]{x, x + w - 3, x + w - 3, x};
                yr = new int[]{y + 3, y, y + h - 3, y + h};
            } else {
                xp = new int[]{x + 3, x + w, x + w, x + 3, x};
                yp = new int[]{y, y, y + h, y + h, y + 3};
                xr = new int[]{x, x + w - 3, x + w, x + 3};
                yr = new int[]{y + 3, y + 3, y + h, y + h};
            }
            if (!ghost) {
                g.setColor(color.darker());
                g.fillPolygon(xp, yp, xp.length);
                g.setColor(color);
                g.fillPolygon(xr, yr, xr.length);
                g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
            }
            g.drawPolygon(xp, yp, xp.length);
            g.drawPolygon(xr, yr, xr.length);
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                g.drawLine(x + (w - 3) / 2, y + 1 + 1, x + (w - 3) / 2, y + h - 1 - 1);
                g.drawLine(x + w - 3, y + h - 3, x + w, y + h);
                g.drawLine(x + (w - 3) / 6, y + (h - 3) / 2 + 3, x + (w - 3) / 3, y + (h - 3) / 2 + 2);
                g.drawOval(x + (w - 3) * 3 / 4 - circle / 2, y + ((h - 3) / 2 - circle / 2) + 1 + 0, circle, circle - 1);
            } else {
                g.drawLine(x + w - 3, y + 3, x + w, y);
                g.drawLine(x + 1 + 1, y + (h - 3) / 2 + 3, x + w - 1 - 1, y + (h - 3) / 2 + 3);
                g.drawLine(x + (w - 3) / 2 + 3, y + (h - 3) * 5 / 6 + 3, x + (w - 3) / 2 + 2, y + (h - 3) * 2 / 3 + 3);
                g.drawOval(x + 0 + (w - 3 - circle) / 2 + 1, y + ((h - 3) / 4 - circle / 2) + 3, circle - 1, circle);
            }
        } else {
            int[] yr;
            int[] xr;
            int[] yp;
            int[] xp;
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                xp = new int[]{x, x + 3, x + w, x + w, x};
                yp = new int[]{y + 3, y, y + 3, y + h, y + h};
                xr = new int[]{x + 3, x + w, x + w, x + 3};
                yr = new int[]{y, y + 3, y + h, y + h - 3};
            } else {
                xp = new int[]{x + 3, x + w, x + w, x + 3, x};
                yp = new int[]{y, y, y + h, y + h, y + h - 3};
                xr = new int[]{x + 3, x + w, x + w - 3, x};
                yr = new int[]{y, y, y + h - 3, y + h - 3};
            }
            if (!ghost) {
                g.setColor(color.darker());
                g.fillPolygon(xp, yp, xp.length);
                g.setColor(color);
                g.fillPolygon(xr, yr, xr.length);
                g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
            }
            g.drawPolygon(xp, yp, xp.length);
            g.drawPolygon(xr, yr, xr.length);
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                g.drawLine(x + 3, y + h - 3, x, y + h);
                g.drawLine(x + (w - 3) / 2 + 3, y + 1 + 1, x + (w - 3) / 2 + 3, y + h - 1 - 1);
                g.drawLine(x + 3 + w / 6, y + (h - 3) / 2 + 0, x + 3 + w / 3, y + (h - 3) / 2 + 1);
                g.drawOval(x + (w - 3) * 3 / 4 - circle / 2 + 3, y + ((h - 3) / 2 - circle / 2) + 2 + 1, circle, circle - 1);
            } else {
                g.drawLine(x + 1 + 1, y + (h - 3) / 2, x + w - 1 - 1, y + (h - 3) / 2);
                g.drawLine(x + w - 3, y + h - 3, x + w, y + h);
                g.drawLine(x + (w - 3) / 2 + 0, y + (h - 3) * 5 / 6, x + (w - 3) / 2 + 1, y + (h - 3) * 2 / 3);
                g.drawOval(x + 2 + (w - 3 - circle) / 2 + 1, y + ((h - 3) / 4 - circle / 2), circle - 1, circle);
            }
        }
        if (!ghost) {
            painter.drawLabel();
            painter.drawPort(facing == Direction.SOUTH || facing == Direction.EAST ? 1 : 0);
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        this.paint(painter, true);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        this.paint(painter, false);
    }

    @Override
    public void propagate(InstanceState state) {
        InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
        Value val = data == null || (Boolean)data.getValue() == false ? Value.createUnknown(state.getAttributeValue(StdAttr.WIDTH)) : state.getPortValue(0);
        state.setPort(1, val, 1);
    }

    private void updateports(Instance instance) {
        Port[] ps = new Port[2];
        BitWidth b = instance.getAttributeValue(StdAttr.WIDTH);
        Direction dir = instance.getAttributeValue(StdAttr.FACING);
        ps[0] = dir == Direction.EAST ? new Port(-20, 0, "input", b) : (dir == Direction.WEST ? new Port(20, 0, "input", b) : (dir == Direction.NORTH ? new Port(0, 20, "input", b) : new Port(0, -20, "input", b)));
        ps[0].setToolTip(Strings.S.getter("pinInputName"));
        ps[1] = new Port(0, 0, "output", b);
        ps[1].setToolTip(Strings.S.getter("pinOutputName"));
        instance.setPorts(ps);
    }

    public static class Poker
    extends InstancePoker {
        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
            this.setActive(state, data == null || (Boolean)data.getValue() == false);
        }

        private void setActive(InstanceState state, boolean active) {
            InstanceDataSingleton data = (InstanceDataSingleton)state.getData();
            if (data == null) {
                state.setData(new InstanceDataSingleton(active));
            } else {
                data.setValue(active);
            }
            state.getInstance().fireInvalidated();
        }
    }

    public static class Logger
    extends InstanceLogger {
        @Override
        public String getLogName(InstanceState state, Object option) {
            return state.getAttributeValue(StdAttr.LABEL);
        }

        @Override
        public BitWidth getBitWidth(InstanceState state, Object option) {
            return BitWidth.ONE;
        }

        @Override
        public Value getLogValue(InstanceState state, Object option) {
            return state.getPortValue(1);
        }
    }
}

