/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io.extra;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.extra.DiagramState;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class DigitalOscilloscope
extends InstanceFactory {
    public static final String _ID = "Digital Oscilloscope";
    private static final Attribute<Integer> ATTR_INPUTS = Attributes.forIntegerRange("inputs", Strings.S.getter("gateInputsAttr"), 1, 32);
    private static final Attribute<Integer> ATTR_NSTATE = Attributes.forIntegerRange("nState", Strings.S.getter("NStateAttr"), 4, 35);
    private static final AttributeOption NO = new AttributeOption("no", Strings.S.getter("noOption"));
    private static final AttributeOption TRIG_RISING = new AttributeOption("rising", Strings.S.getter("stdTriggerRising"));
    private static final AttributeOption TRIG_FALLING = new AttributeOption("falling", Strings.S.getter("stdTriggerFalling"));
    private static final AttributeOption BOTH = new AttributeOption("both", Strings.S.getter("bothOption"));
    private static final Attribute<AttributeOption> VERT_LINE = Attributes.forOption("frontlines", Strings.S.getter("DrawClockFrontLine"), new AttributeOption[]{NO, TRIG_RISING, TRIG_FALLING, BOTH});
    private static final Attribute<Boolean> SHOW_CLOCK = Attributes.forBoolean("showclock", Strings.S.getter("ShowClockAttribute"));
    private static final Attribute<Color> ATTR_COLOR = Attributes.forColor("color", Strings.S.getter("BorderColor"));
    private final int border = 10;

    public DigitalOscilloscope() {
        super(_ID, Strings.S.getter("DigitalOscilloscopeComponent"));
        this.setAttributes(new Attribute[]{ATTR_INPUTS, ATTR_NSTATE, VERT_LINE, SHOW_CLOCK, ATTR_COLOR, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT}, new Object[]{3, 10, TRIG_RISING, true, new Color(0, 208, 208), "", Direction.NORTH, StdAttr.DEFAULT_LABEL_FONT});
        this.setIconName("digitaloscilloscope.gif");
        this.setKeyConfigurator(new DirectionConfigurator(StdAttr.LABEL_LOC, 512));
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        instance.computeLabelTextField(8);
        this.updateports(instance);
    }

    private DiagramState getDiagramState(InstanceState state) {
        byte inputs = (byte)(state.getAttributeValue(ATTR_INPUTS).byteValue() + 1);
        byte length = (byte)(state.getAttributeValue(ATTR_NSTATE).byteValue() * 2);
        DiagramState ret = (DiagramState)state.getData();
        if (ret == null) {
            ret = new DiagramState(inputs, length);
            state.setData(ret);
        } else {
            ret.updateSize(inputs, length);
        }
        return ret;
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        int width = attrs.getValue(ATTR_NSTATE) * 30 + 20 + 15;
        int height = attrs.getValue(SHOW_CLOCK) != false ? (attrs.getValue(ATTR_INPUTS) + 1) * 30 + 30 + 2 : attrs.getValue(ATTR_INPUTS) * 30 + 30;
        byte showclock = (byte)(attrs.getValue(SHOW_CLOCK) != false ? 32 : 0);
        return Bounds.create(0, -10 - showclock, width, height);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == ATTR_NSTATE || attr == ATTR_INPUTS || attr == SHOW_CLOCK) {
            instance.recomputeBounds();
            this.updateports(instance);
            instance.computeLabelTextField(8);
        } else if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(8);
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        Bounds bds = painter.getBounds();
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        g.drawRoundRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight(), 10, 10);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        byte i;
        Color baseColor = new Color(AppPreferences.COMPONENT_COLOR.get());
        Bounds bds = painter.getBounds();
        byte showclock = (byte)(painter.getAttributeValue(SHOW_CLOCK) != false ? 1 : 0);
        int x = bds.getX();
        int y = bds.getY();
        int width = bds.getWidth();
        int height = bds.getHeight();
        byte inputs = (byte)(painter.getAttributeValue(ATTR_INPUTS).byteValue() + showclock);
        byte length = (byte)(painter.getAttributeValue(ATTR_NSTATE).byteValue() * 2);
        DiagramState diagramstate = this.getDiagramState(painter);
        Graphics2D g = (Graphics2D)painter.getGraphics();
        painter.drawRoundBounds(painter.getAttributeValue(ATTR_COLOR));
        g.setColor(Color.WHITE);
        g.fillRoundRect(x + 10, y + 10, width - 20, height - 20, 5, 5);
        if (painter.getAttributeValue(VERT_LINE) != NO) {
            g.setColor(painter.getAttributeValue(ATTR_COLOR).darker());
            g.setStroke(new BasicStroke(0.5f, 1, 1, 0.0f, new float[]{6.0f, 4.0f}, 8.0f));
            for (byte j = 1; j < length; j = (byte)(j + 1)) {
                if ((painter.getAttributeValue(VERT_LINE) != TRIG_RISING && painter.getAttributeValue(VERT_LINE) != BOTH || diagramstate.getState(0, j) != Boolean.TRUE || diagramstate.getState(0, j - 1) != Boolean.FALSE) && (painter.getAttributeValue(VERT_LINE) != TRIG_FALLING && painter.getAttributeValue(VERT_LINE) != BOTH || diagramstate.getState(0, j) != Boolean.FALSE || diagramstate.getState(0, j - 1) != Boolean.TRUE)) continue;
                g.drawLine(x + 10 + 15 * j, y + 10, x + 10 + 15 * j, y + height - 10);
            }
        }
        byte nck = (byte)(length / 2);
        g.setFont(new Font("sans serif", 0, 8));
        for (i = 0; i < inputs; i = (byte)(i + 1)) {
            g.setColor(painter.getAttributeValue(ATTR_COLOR).darker().darker().darker());
            GraphicsUtil.switchToWidth(g, 1);
            g.drawLine(x + 10, y + 10 + i * 30 + 30 + showclock * 2, x + 10 + 15 * length + 4, y + 10 + i * 30 + 30 + showclock * 2);
            GraphicsUtil.switchToWidth(g, 2);
            if (diagramstate.getmoveback() && diagramstate.getState(i, length - 1) != null) {
                g.setColor(baseColor);
                g.drawLine(x + 10 + 15 * length, y + 10 + i * 30 + 30 + showclock * 2, x + 10 + 15 * length + 4, y + 10 + i * 30 + 30 + showclock * 2);
            }
            g.fillPolygon(new int[]{x + 10 + 15 * length + 4, x + 10 + 15 * length + 13, x + 10 + 15 * length + 4}, new int[]{y + 10 + i * 30 + 27 + showclock * 2, y + 10 + i * 30 + 30 + showclock * 2, y + 10 + i * 30 + 33 + showclock * 2}, 3);
            if (showclock == 1 && i == 0) {
                g.setColor(painter.getAttributeValue(ATTR_COLOR).darker().darker());
            } else {
                g.setColor(Color.BLACK);
            }
            for (byte j = 0; j < length; j = (byte)(j + 1)) {
                if (j != 0 && diagramstate.getState(i + (showclock == 0 ? (byte)1 : 0), j) != diagramstate.getState(i + (showclock == 0 ? (byte)1 : 0), j - 1) && diagramstate.getState(i + (showclock == 0 ? (byte)1 : 0), j) != null && diagramstate.getState(i + (showclock == 0 ? (byte)1 : 0), j - 1) != null) {
                    g.drawLine(x + 10 + 15 * j, y + 20 + 30 * i + showclock * 2, x + 10 + 15 * j, y + 10 + 30 * (i + 1) + showclock * 2);
                }
                if (diagramstate.getState(i + (showclock == 0 ? (byte)1 : 0), j) == Boolean.TRUE) {
                    g.drawLine(x + 10 + 15 * j, y + 20 + 30 * i + showclock * 2, x + 10 + 15 * (j + 1), y + 20 + 30 * i + showclock * 2);
                    if (j == length - 1) {
                        g.drawLine(x + 10 + 15 * (j + 1), y + 20 + 30 * i + showclock * 2, x + 10 + 15 * (j + 1), y + 10 + 30 * (i + 1) + showclock * 2);
                    }
                    if (i != 0 || painter.getAttributeValue(VERT_LINE) == NO || showclock != 1) continue;
                    nck = (byte)(nck - 1);
                    int cknum = diagramstate.getclocknumber() - nck > 0 ? diagramstate.getclocknumber() - nck : 100 + (diagramstate.getclocknumber() - nck - 1);
                    g.setColor(painter.getAttributeValue(ATTR_COLOR).darker());
                    GraphicsUtil.drawCenteredText(g, Integer.toString(cknum), x + 10 + 15 * j + 7, y + 10 + 5);
                    if (showclock == 1 && i == 0) {
                        g.setColor(painter.getAttributeValue(ATTR_COLOR).darker().darker());
                        continue;
                    }
                    g.setColor(baseColor);
                    continue;
                }
                if (diagramstate.getState(i + (showclock == 0 ? (byte)1 : 0), j) != Boolean.FALSE) continue;
                g.drawLine(x + 10 + 15 * j, y + 10 + 30 * (i + 1) + showclock * 2, x + 10 + 15 * (j + 1), y + 10 + 30 * (i + 1) + showclock * 2);
            }
        }
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        g.drawRoundRect(x + 10, y + 10, width - 20, height - 20, 5, 5);
        for (i = 1; i < inputs + 2; i = (byte)(i + 1)) {
            painter.drawPort(i);
        }
        painter.drawClock(0, Direction.EAST);
        painter.drawLabel();
    }

    @Override
    public void propagate(InstanceState state) {
        byte inputs = (byte)(state.getAttributeValue(ATTR_INPUTS).byteValue() + 1);
        byte length = (byte)(state.getAttributeValue(ATTR_NSTATE).byteValue() * 2);
        Value clock = state.getPortValue(0);
        Value enable = state.getPortValue(inputs);
        Value clear = state.getPortValue(inputs + 1);
        DiagramState diagramstate = this.getDiagramState(state);
        if (clock != Value.UNKNOWN && clear != Value.TRUE && enable != Value.FALSE) {
            Value lastclock = diagramstate.setLastClock(clock);
            if (lastclock != Value.UNKNOWN) {
                if (lastclock != clock) {
                    if (diagramstate.getusedcell() < length - 1) {
                        diagramstate.setusedcell((byte)(diagramstate.getusedcell() + 1));
                    }
                    if (diagramstate.getmoveback()) {
                        diagramstate.moveback();
                        if (clock == Value.TRUE) {
                            diagramstate.setclocknumber((byte)(diagramstate.getclocknumber() + 1));
                        }
                    }
                    if (diagramstate.getusedcell() == length - 1) {
                        diagramstate.hastomoveback(true);
                    }
                    for (byte i = 0; i < inputs; i = (byte)(i + 1)) {
                        diagramstate.setState(i, diagramstate.getusedcell(), state.getPortValue(i) == Value.TRUE ? Boolean.TRUE : (state.getPortValue(i) == Value.FALSE ? Boolean.FALSE : null));
                    }
                } else if (diagramstate.getusedcell() != -1) {
                    for (byte i = 1; i < inputs; i = (byte)(i + 1)) {
                        diagramstate.setState(i, diagramstate.getusedcell(), state.getPortValue(i) == Value.TRUE ? Boolean.TRUE : (state.getPortValue(i) == Value.FALSE ? Boolean.FALSE : null));
                    }
                }
            }
        } else if (clear == Value.TRUE) {
            diagramstate.clear();
            diagramstate.setusedcell((byte)-1);
            diagramstate.setLastClock(Value.UNKNOWN);
            diagramstate.hastomoveback(false);
            diagramstate.setclocknumber((byte)(length / 2));
        }
    }

    private void updateports(Instance instance) {
        byte inputs = instance.getAttributeValue(ATTR_INPUTS).byteValue();
        Port[] port = new Port[inputs + 3];
        for (byte i = 0; i <= inputs; i = (byte)(i + 1)) {
            port[i] = new Port(0, 30 * i, "input", 1);
        }
        port[inputs + 1] = new Port(20, 30 * inputs + 20, "input", 1);
        port[inputs + 1].setToolTip(Strings.S.getter("priorityEncoderEnableInTip"));
        port[inputs + 2] = new Port(30, 30 * inputs + 20, "input", 1);
        port[inputs + 2].setToolTip(Strings.S.getter("ClearDiagram"));
        port[0].setToolTip(Strings.S.getter("DigitalOscilloscopeClock"));
        instance.setPorts(port);
    }
}

