/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import com.cburch.logisim.std.io.SevenSegment;
import com.cburch.logisim.std.io.SevenSegmentScanningDecodedHdlGeneratorFactory;
import com.cburch.logisim.std.io.SevenSegmentScanningGenericHdlGenerator;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;
import java.util.List;

public class SevenSegmendScanningSelectedHdlGenerator
extends SevenSegmentScanningDecodedHdlGeneratorFactory {
    public static final String HDL_IDENTIFIER = "SevenSegmentScanning";
    public static final int SELECT_DIGIT_INVERTED_ID = -7;
    public static final String SELECT_DIGIT_INVERTED_STRING = "activeLowSelectPins";

    public SevenSegmendScanningSelectedHdlGenerator() {
        this.myParametersList.add(SELECT_DIGIT_INVERTED_STRING, -7);
        this.myPorts.removePorts();
        this.myPorts.add("input", SevenSegmentScanningGenericHdlGenerator.SevenSegmentSegmenInputs, -1, 9).add("output", SevenSegmentScanningGenericHdlGenerator.SevenSegmentControlOutput, -2, 10).add("input", "fpgaGlobalClock", 1, 11);
        int id = 0;
        for (String segName : SevenSegment.getLabels()) {
            this.myPorts.add("output", segName, 1, id++);
        }
    }

    public static LineBuffer getGenericMap(int nrOfRows, int nrOfColumns, long fpgaClockFrequency, boolean activeLow, boolean selectActiveLow) {
        int scanningReload = (int)(fpgaClockFrequency / 1000L);
        int nrOfScanningBitsCount = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(scanningReload);
        int nrOfControl = SevenSegmendScanningSelectedHdlGenerator.nrOfControlBits(nrOfRows, nrOfColumns);
        HashMap<String, String> generics = new HashMap<String, String>();
        generics.put("nrOfSegments", Integer.toString(nrOfRows * 8));
        generics.put("nrOfDigits", Integer.toString(nrOfRows));
        generics.put("nrOfControl", Integer.toString(nrOfControl));
        generics.put("activeLow", activeLow ? "1" : "0");
        generics.put(SELECT_DIGIT_INVERTED_STRING, selectActiveLow ? "1" : "0");
        generics.put("nrOfScanningCounterBits", Integer.toString(nrOfScanningBitsCount));
        generics.put("scanningCounterReloadValue", Integer.toString(scanningReload - 1));
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(generics, true);
    }

    public static List<String> getDecodedCode() {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("controlOutput", SevenSegmentScanningGenericHdlGenerator.SevenSegmentControlOutput).pair("nMax", "nrOfDigits").pair("sVal", SELECT_DIGIT_INVERTED_STRING).pair("nrBits", "nrOfControl");
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("genSels : {{for}} n {{in}} {{nMax}} - 1 {{downto}} 0 {{generate}}\n  {{controlOutput}}(n) <= '1'\n     {{when}} (s_columnCounterReg = std_logic_vector(to_unsigned(n, {{nrBits}})) {{and}} {{sVal}} = 0) {{or}}\n          (s_columnCounterReg /= std_logic_vector(to_unsigned(n, {{nrBits}})) {{and}} {{sVal}} = 1) {{else}} '0';\n{{end}} {{generate}};\n\n").empty();
        } else {
            contents.add("genvar n;\n\ngenerate\n  for (n = 0; n < {{nMax}}; n = n + 1)\n    assign {{controlOutput}}[n] = s_columnCounterReg == n ? ~{{sVal}} : {{sVal}};\nendgenerate\n\n").empty();
        }
        return contents.get();
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().add(SevenSegmendScanningSelectedHdlGenerator.getTickCounterCode()).add(SevenSegmendScanningSelectedHdlGenerator.getDecodedCode());
        return contents;
    }
}

