/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;

public class LedArrayLedDefaultHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public static final int NR_OF_LEDS_ID = -1;
    public static final int ACTIVE_LOW_ID = -2;
    public static final String NR_OF_LEDS_STRING = "nrOfLeds";
    public static final String ACTIVE_LOW_STRING = "activeLow";
    public static final String HDL_IDENTIFIER = "LedArrayLedDefault";

    public LedArrayLedDefaultHdlGeneratorFactory() {
        this.myParametersList.add(NR_OF_LEDS_STRING, -1).add(ACTIVE_LOW_STRING, -2);
        this.myPorts.add("input", LedArrayGenericHdlGeneratorFactory.LedArrayInputs, -1, 0).add("output", LedArrayGenericHdlGeneratorFactory.LedArrayOutputs, -1, 1);
    }

    public static LineBuffer getGenericMap(int nrOfRows, int nrOfColumns, long fpgaClockFrequency, boolean activeLow) {
        HashMap<String, String> generics = new HashMap<String, String>();
        generics.put(NR_OF_LEDS_STRING, Integer.toString(nrOfRows * nrOfColumns));
        generics.put(ACTIVE_LOW_STRING, activeLow ? "1" : "0");
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(generics, true);
    }

    public static LineBuffer getPortMap(int id) {
        HashMap<String, String> ports = new HashMap<String, String>();
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayOutputs, String.format("%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayOutputs, id));
        ports.put(LedArrayGenericHdlGeneratorFactory.LedArrayInputs, String.format("s_%s%d", LedArrayGenericHdlGeneratorFactory.LedArrayInputs, id));
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(ports, false);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("ins", LedArrayGenericHdlGeneratorFactory.LedArrayInputs).pair("outs", LedArrayGenericHdlGeneratorFactory.LedArrayOutputs);
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("genLeds : {{for}} n {{in}} (nrOfLeds-1) {{downto}} 0 {{generate}}\n   {{outs}}(n) <= {{not}}({{ins}}(n)) {{when}} activeLow = 1 {{else}} {{ins}}(n);\n{{end}} {{generate}};\n").empty();
        } else {
            contents.add("genvar i;\ngenerate\n   for (i = 0; i < nrOfLeds; i = i + 1)\n   begin:outputs\n      assign {{outs}}[i] = (activeLow == 1) ? ~{{ins}}[i] : {{ins}}[i];\n   end\nendgenerate\n").empty();
        }
        return contents;
    }
}

