/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.draw.shapes.DrawAttr;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.gui.icons.DipSwitchIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.AbstractSimpleIoHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class DipSwitch
extends InstanceFactory {
    public static final String _ID = "DipSwitch";
    public static final int MAX_SWITCH = 32;
    public static final int MIN_SWITCH = 1;
    public static final Attribute<BitWidth> ATTR_SIZE = Attributes.forBitWidth("number", Strings.S.getter("nrOfSwitch"), 1, 32);

    public static ArrayList<String> getLabels(int size) {
        ArrayList<String> labelNames = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            labelNames.add(DipSwitch.getInputLabel(i));
        }
        return labelNames;
    }

    public static String getInputLabel(int id) {
        return "sw_" + (id + 1);
    }

    public DipSwitch() {
        super(_ID, Strings.S.getter("DipSwitchComponent"), new AbstractSimpleIoHdlGeneratorFactory(true), true);
        int dipSize = 8;
        this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR, StdAttr.LABEL_VISIBILITY, ATTR_SIZE, StdAttr.MAPINFO}, new Object[]{Direction.NORTH, "", Direction.EAST, StdAttr.DEFAULT_LABEL_FONT, StdAttr.DEFAULT_LABEL_COLOR, true, BitWidth.create(dipSize), new ComponentMapInformationContainer(dipSize, 0, 0, DipSwitch.getLabels(dipSize), null, null)});
        this.setFacingAttribute(StdAttr.FACING);
        this.setIcon(new DipSwitchIcon());
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(ATTR_SIZE), new DirectionConfigurator(StdAttr.LABEL_LOC, 512)));
        this.setInstancePoker(Poker.class);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
        instance.computeLabelTextField(8);
        int dipSize = instance.getAttributeValue(ATTR_SIZE).getWidth();
        instance.getAttributeSet().setValue(StdAttr.MAPINFO, new ComponentMapInformationContainer(dipSize, 0, 0, DipSwitch.getLabels(dipSize), null, null));
    }

    private void updatePorts(Instance instance) {
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        int n = instance.getAttributeValue(ATTR_SIZE).getWidth();
        int cx = 0;
        int cy = 0;
        int dx = 0;
        int dy = 0;
        if (facing == Direction.WEST) {
            dy = -10;
        } else if (facing == Direction.EAST) {
            dy = 10;
        } else if (facing == Direction.SOUTH) {
            cx = -10 * (n + 1);
            dx = 10;
        } else {
            dx = 10;
        }
        Port[] ps = new Port[n];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = new Port(cx + (i + 1) * dx, cy + (i + 1) * dy, "output", 1);
            ps[i].setToolTip(Strings.S.getter("DIP" + (i + 1)));
        }
        instance.setPorts(ps);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        int n = attrs.getValue(ATTR_SIZE).getWidth();
        return Bounds.create(0, 0, (n + 1) * 10, 40).rotate(Direction.NORTH, facing, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(8);
        } else if (attr == ATTR_SIZE) {
            instance.recomputeBounds();
            this.updatePorts(instance);
            instance.computeLabelTextField(8);
            ComponentMapInformationContainer map = instance.getAttributeValue(StdAttr.MAPINFO);
            if (map != null) {
                map.setNrOfInports(instance.getAttributeValue(ATTR_SIZE).getWidth(), DipSwitch.getLabels(instance.getAttributeValue(ATTR_SIZE).getWidth()));
            }
        } else if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.updatePorts(instance);
            instance.computeLabelTextField(8);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int i;
        int segmentWidth = 10;
        State state = (State)painter.getData();
        if (state == null || state.size != painter.getAttributeValue(ATTR_SIZE).getWidth()) {
            int val = state == null ? 0 : state.Value;
            state = new State(val, painter.getAttributeValue(ATTR_SIZE).getWidth());
            painter.setData(state);
        }
        int n = painter.getAttributeValue(ATTR_SIZE).getWidth();
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        if (facing == Direction.SOUTH) {
            x -= 10 * (n + 1);
            y -= 40;
        }
        Graphics g = painter.getGraphics();
        g.translate(x, y);
        double rotate = 0.0;
        if (facing != Direction.NORTH && facing != Direction.SOUTH && g instanceof Graphics2D) {
            rotate = -facing.getRight().toRadians();
            ((Graphics2D)g).rotate(rotate);
        }
        g.setColor(Color.DARK_GRAY);
        g.fillRect(1, 1, (n + 1) * 10 - 2, 38);
        g.setFont(DrawAttr.DEFAULT_FONT);
        if (n > 9) {
            g.setFont(g.getFont().deriveFont(g.getFont().getSize2D() * 0.6f));
        }
        for (i = 0; i < n; ++i) {
            g.setColor(state.isBitSet(i) ? Value.trueColor : Color.white);
            g.fillRect(7 + i * 10, 16, 6, 20);
            g.setColor(Color.white);
            String s = Integer.toString(i + 1);
            GraphicsUtil.drawCenteredText(g, s, 9 + i * 10, 8);
        }
        for (i = 0; i < n; ++i) {
            g.setColor(state.isBitSet(i) ? Color.DARK_GRAY : Color.GRAY);
            int ypos = state.isBitSet(i) ? 17 : 26;
            g.fillRect(8 + i * 10, ypos, 4, 9);
        }
        if (rotate != 0.0) {
            ((Graphics2D)g).rotate(-rotate);
        }
        g.translate(-x, -y);
        painter.drawLabel();
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        State pins = (State)state.getData();
        if (pins == null || pins.size != state.getAttributeValue(ATTR_SIZE).getWidth()) {
            int val = pins == null ? 0 : pins.Value;
            pins = new State(val, state.getAttributeValue(ATTR_SIZE).getWidth());
            state.setData(pins);
        }
        for (int i = 0; i < pins.size; ++i) {
            Value pinstate = pins.isBitSet(i) ? Value.TRUE : Value.FALSE;
            state.setPort(i, pinstate, 1);
        }
    }

    public static class Poker
    extends InstancePoker {
        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            State val = (State)state.getData();
            Location loc = state.getInstance().getLocation();
            Direction facing = state.getInstance().getAttributeValue(StdAttr.FACING);
            int n = state.getInstance().getAttributeValue(ATTR_SIZE).getWidth();
            int i = facing == Direction.SOUTH ? n + (e.getX() - loc.getX() - 5) / 10 : (facing == Direction.EAST ? (e.getY() - loc.getY() - 5) / 10 : (facing == Direction.WEST ? (loc.getY() - e.getY() - 5) / 10 : (e.getX() - loc.getX() - 5) / 10));
            val.toggleBit(i);
            state.getInstance().fireInvalidated();
        }
    }

    private static class State
    implements InstanceData,
    Cloneable {
        private int Value;
        private final int size;

        public State(int value, int size) {
            this.Value = value;
            this.size = size;
        }

        public boolean isBitSet(int bitindex) {
            if (bitindex >= this.size) {
                return false;
            }
            int mask = 1 << bitindex;
            return (this.Value & mask) != 0;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void toggleBit(int bitindex) {
            if (bitindex < 0 || bitindex >= this.size) {
                return;
            }
            int mask = 1 << bitindex;
            this.Value ^= mask;
        }
    }
}

