/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.analyze.model.VariableList;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.circuit.SplitterAttributes;
import com.cburch.logisim.circuit.SplitterFactory;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.CircuitDetermination;
import com.cburch.logisim.std.gates.GateAttributes;
import com.cburch.logisim.std.gates.NandGate;
import com.cburch.logisim.std.gates.NotGate;
import com.cburch.logisim.std.wiring.Constant;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.std.wiring.ProbeAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CircuitBuilder {
    private static final int SPINE_DISTANCE = 10;
    private static final int BUS_SPINE_TO_WIRE_SPINE_DISTANCE = 20;
    private static final int MINIMAL_PIN_DISTANCE = 30;
    private static final int SPLITTER_HEIGHT = 20;
    private static final int TOP_BORDER = 40;
    private static final int INVERTER_WIDTH = 30;
    private static final int NAND_WIDTH = 40;
    private static final int GATE_HEIGHT = 40;

    public static CircuitMutation build(Circuit destCirc, AnalyzerModel model, boolean twoInputs, boolean useNands) {
        CircuitMutation result = new CircuitMutation(destCirc);
        result.clear();
        Layout[] layouts = new Layout[model.getOutputs().bits.size()];
        int maxWidth = 0;
        for (int i = 0; i < layouts.length; ++i) {
            String output = model.getOutputs().bits.get(i);
            Expression expr = model.getOutputExpressions().getExpression(output);
            CircuitDetermination det = CircuitDetermination.create(expr);
            if (det != null) {
                if (twoInputs) {
                    det.convertToTwoInputs();
                }
                if (useNands) {
                    det.convertToNands();
                }
                det.repair();
                layouts[i] = CircuitBuilder.layoutGates(det);
                maxWidth = Math.max(maxWidth, layouts[i].width);
                continue;
            }
            layouts[i] = null;
        }
        InputData inputData = CircuitBuilder.computeInputData(model);
        InputData outputData = new InputData();
        outputData.startY = inputData.startY;
        int x = inputData.getStartX();
        int y = inputData.getStartY() + inputData.getInverterHeight();
        int outputX = x + maxWidth + 20;
        for (int i = 0; i < layouts.length; ++i) {
            int height;
            String outputName = model.getOutputs().bits.get(i);
            Layout layout = layouts[i];
            if (layout == null) {
                outputData.addInput(outputName, null);
                height = -10;
            } else {
                int dy = 0;
                if (layout.outputY < 20) {
                    dy = 20 - layout.outputY;
                }
                height = Math.max(dy + layout.height, 40);
                Location output = Location.create(outputX, y + dy + layout.outputY, true);
                outputData.addInput(outputName, new SingleInput(outputX, y + dy + layout.outputY));
                CircuitBuilder.placeComponents(result, layouts[i], x, y + dy, inputData, output);
            }
            y += height + 10;
        }
        CircuitBuilder.placeInputs(model, result, inputData, useNands);
        CircuitBuilder.placeOutputs(model, result, outputData);
        return result;
    }

    private static InputData computeInputData(AnalyzerModel model) {
        InputData ret = new InputData();
        VariableList inputs = model.getInputs();
        int nameLength = 1;
        int busLength = 1;
        int nrOfBusses = 0;
        for (int i = 0; i < inputs.vars.size(); ++i) {
            if (inputs.vars.get((int)i).name.length() > nameLength) {
                nameLength = inputs.vars.get((int)i).name.length();
            }
            if (inputs.vars.get((int)i).width > busLength) {
                busLength = inputs.vars.get((int)i).width;
            }
            if (inputs.vars.get((int)i).width <= 1) continue;
            ++nrOfBusses;
        }
        int spineX = 100 + nameLength * 10 + (busLength - 1) * 10;
        ret.pinX = spineX - 10;
        if (nrOfBusses > 0) {
            spineX += nrOfBusses * 10 + 20;
        }
        int cnt = 0;
        for (int i = 0; i < inputs.vars.size(); ++i) {
            Var inp = inputs.vars.get(i);
            if (inp.width == 1) {
                String name = inputs.bits.get(cnt++);
                ret.addInput(name, new SingleInput(spineX));
                spineX += 10;
                continue;
            }
            for (int idx = inp.width - 1; idx >= 0; --idx) {
                String name = inputs.bits.get(cnt++);
                ret.addInput(name, new SingleInput(spineX));
                spineX += 10;
            }
        }
        spineX = ret.createInvertedLocs(spineX);
        spineX += 10;
        VariableList outputs = model.getOutputs();
        int nrOutBusses = 0;
        for (int i = 0; i < outputs.vars.size(); ++i) {
            if (outputs.vars.get((int)i).width <= 1) continue;
            ++nrOutBusses;
        }
        nrOfBusses = Math.max(nrOfBusses, nrOutBusses);
        ret.startX = spineX;
        ret.startY = 40 + nrOfBusses * 20 + (nrOfBusses > 0 ? 10 : 0);
        return ret;
    }

    private static Layout layoutGates(CircuitDetermination det) {
        return CircuitBuilder.layoutGatesSub(det);
    }

    private static Layout layoutGatesSub(CircuitDetermination det) {
        int minHeight;
        int outputY;
        CircuitDetermination subDet;
        if (det instanceof CircuitDetermination.Input) {
            CircuitDetermination.Input input = (CircuitDetermination.Input)det;
            return new Layout(input.getName(), input.isInvertedVersion());
        }
        if (det instanceof CircuitDetermination.Value) {
            CircuitDetermination.Value value = (CircuitDetermination.Value)det;
            if (value.getValue() == 1 || value.getValue() == 0) {
                return new Layout(Integer.toString(value.getValue()), false);
            }
            InstanceFactory factory = Constant.FACTORY;
            AttributeSet attrs = factory.createAttributeSet();
            attrs.setValue(Constant.ATTR_VALUE, Long.valueOf(value.getValue()));
            Bounds bds = factory.getOffsetBounds(attrs);
            return new Layout(bds.getWidth(), bds.getHeight(), -bds.getY(), factory, attrs, new Layout[0], 0);
        }
        CircuitDetermination.Gate gate = (CircuitDetermination.Gate)det;
        ComponentFactory factory = gate.getFactory();
        ArrayList<CircuitDetermination> inputs = gate.getInputs();
        if (gate.isNandNot() && !((subDet = inputs.get(0)) instanceof CircuitDetermination.Input) && !(subDet instanceof CircuitDetermination.Value)) {
            int minHeight2;
            Layout[] sub = new Layout[]{CircuitBuilder.layoutGatesSub(subDet)};
            sub[0].y = 0;
            AttributeSet attrs = factory.createAttributeSet();
            attrs.setValue(GateAttributes.ATTR_SIZE, GateAttributes.SIZE_NARROW);
            attrs.setValue(GateAttributes.ATTR_INPUTS, 2);
            Bounds bds = factory.getOffsetBounds(attrs);
            int betweenWidth = 40;
            if (sub[0].width == 0) {
                betweenWidth = 0;
            }
            int width = sub[0].width + betweenWidth + bds.getWidth();
            int outputY2 = sub[0].y + sub[0].outputY;
            int height = sub[0].height;
            int minOutputY = CircuitBuilder.roundUp(-bds.getY());
            if (minOutputY > outputY2) {
                int dy = minOutputY - outputY2;
                sub[0].y += dy;
                height += dy;
                outputY2 += dy;
            }
            if ((minHeight2 = outputY2 + bds.getY() + bds.getHeight()) > height) {
                height = minHeight2;
            }
            return new Layout(width, height, outputY2, factory, attrs, sub, sub[0].width);
        }
        Layout[] sub = new Layout[inputs.size()];
        int subWidth = 0;
        int subHeight = 0;
        for (int i = 0; i < sub.length; ++i) {
            sub[i] = CircuitBuilder.layoutGatesSub(inputs.get(i));
            if (sub.length % 2 == 0 && i == (sub.length + 1) / 2 && sub[i - 1].height + sub[i].height == 0) {
                subHeight += 10;
            }
            sub[i].y = subHeight;
            subWidth = Math.max(subWidth, sub[i].width);
            subHeight += sub[i].height + 10;
        }
        subHeight -= 10;
        AttributeSet attrs = factory.createAttributeSet();
        if (factory == NotGate.FACTORY) {
            attrs.setValue(NotGate.ATTR_SIZE, NotGate.SIZE_NARROW);
        } else {
            attrs.setValue(GateAttributes.ATTR_SIZE, GateAttributes.SIZE_NARROW);
            int ins = sub.length;
            attrs.setValue(GateAttributes.ATTR_INPUTS, ins);
        }
        Bounds bds = factory.getOffsetBounds(attrs);
        int betweenWidth = 40 + 10 * (sub.length / 2 - 1);
        if (sub.length == 1) {
            betweenWidth = 20;
        }
        if (subWidth == 0) {
            betweenWidth = 0;
        }
        int width = subWidth + betweenWidth + bds.getWidth();
        if (sub.length % 2 == 1) {
            int i = (sub.length - 1) / 2;
            outputY = sub[i].y + sub[i].outputY;
        } else {
            int i0 = sub.length / 2 - 1;
            int i1 = sub.length / 2;
            int o0 = sub[i0].y + sub[i0].outputY;
            int o1 = sub[i1].y + sub[i1].outputY;
            outputY = CircuitBuilder.roundDown((o0 + o1) / 2);
        }
        int height = subHeight;
        int minOutputY = CircuitBuilder.roundUp(-bds.getY());
        if (minOutputY > outputY) {
            int dy = minOutputY - outputY;
            for (Layout layout : sub) {
                layout.y += dy;
            }
            height += dy;
            outputY += dy;
        }
        if ((minHeight = outputY + bds.getY() + bds.getHeight()) > height) {
            height = minHeight;
        }
        return new Layout(width, height, outputY, factory, attrs, sub, subWidth);
    }

    private static void placeComponents(CircuitMutation result, Layout layout, int x, int y, InputData inputData, Location output) {
        if (layout.inputName != null) {
            int inputX = inputData.getSpineX(layout.inputName, layout.inverted);
            Location input = Location.create(inputX, output.getY(), true);
            inputData.registerConnection(layout.inputName, input, layout.inverted);
            result.add(Wire.create(input, output));
            return;
        }
        Location compOutput = Location.create(x + layout.width, output.getY(), true);
        Component parent = layout.factory.createComponent(compOutput, layout.attrs);
        result.add(parent);
        if (!compOutput.equals(output)) {
            result.add(Wire.create(compOutput, output));
        }
        if (layout.factory == NandGate.FACTORY && layout.subLayouts.length == 1 && layout.subLayouts[0].inputName == null) {
            Layout sub = layout.subLayouts[0];
            Location input0 = parent.getEnd(1).getLocation();
            Location input1 = parent.getEnd(2).getLocation();
            int midX = input0.getX() - 20;
            Location subOutput = Location.create(midX, output.getY(), true);
            Location midInput0 = Location.create(midX, input0.getY(), true);
            Location midInput1 = Location.create(midX, input1.getY(), true);
            result.add(Wire.create(subOutput, midInput0));
            result.add(Wire.create(midInput0, input0));
            result.add(Wire.create(subOutput, midInput1));
            result.add(Wire.create(midInput1, input1));
            int subX = x + layout.subX - sub.width;
            CircuitBuilder.placeComponents(result, sub, subX, y + sub.y, inputData, subOutput);
            return;
        }
        if (layout.subLayouts.length == parent.getEnds().size() - 2) {
            int index = layout.subLayouts.length / 2 + 1;
            ComponentFactory factory = parent.getFactory();
            if (factory instanceof AbstractGate) {
                AbstractGate gate = (AbstractGate)factory;
                Value val = gate.getIdentity();
                long valLong = val.toLongValue();
                Location loc = parent.getEnd(index).getLocation();
                AttributeSet attrs = Constant.FACTORY.createAttributeSet();
                attrs.setValue(Constant.ATTR_VALUE, valLong);
                result.add(Constant.FACTORY.createComponent(loc, attrs));
            }
        }
        for (int i = 0; i < layout.subLayouts.length; ++i) {
            Location subOutput;
            Layout sub = layout.subLayouts[i];
            int inputIndex = i + 1;
            Location subDest = parent.getEnd(inputIndex).getLocation();
            int subOutputY = y + sub.y + sub.outputY;
            if (sub.inputName != null) {
                int destY = subDest.getY();
                if (i == 0 && destY < subOutputY || i == layout.subLayouts.length - 1 && destY > subOutputY) {
                    subOutputY = destY;
                }
            }
            int numSubs = layout.subLayouts.length;
            if (subOutputY == subDest.getY()) {
                subOutput = subDest;
            } else {
                int back = i < numSubs / 2 ? (subOutputY < subDest.getY() ? i : (numSubs - 1) / 2 - i) : (subOutputY > subDest.getY() ? numSubs - 1 - i : i - numSubs / 2);
                int subOutputX = subDest.getX() - 20 - 10 * back;
                subOutput = Location.create(subOutputX, subOutputY, true);
                Location mid = Location.create(subOutputX, subDest.getY(), true);
                result.add(Wire.create(subOutput, mid));
                result.add(Wire.create(mid, subDest));
            }
            int subX = x + layout.subX - sub.width;
            int subY = y + sub.y;
            CircuitBuilder.placeComponents(result, sub, subX, subY, inputData, subOutput);
        }
    }

    private static void placeInputInverters(CircuitMutation result, InputData inputData, boolean useNands) {
        int invPosY = inputData.getStartY() + 20;
        for (int i = 0; i < inputData.getNrOfInputs(); ++i) {
            String inputName = inputData.getInputName(i);
            if (!inputData.hasInvertedConnections(inputName)) continue;
            if (useNands) {
                fact = NandGate.FACTORY;
                attrs = ((AbstractGate)fact).createAttributeSet();
                attrs.setValue(GateAttributes.ATTR_SIZE, GateAttributes.SIZE_NARROW);
                Location ipLoc1 = Location.create(inputData.getSpineX("1", false), invPosY - 10, true);
                inputData.registerConnection("1", ipLoc1, false);
                Location Ploc = Location.create(inputData.getInverterXLoc(), invPosY, true);
                result.add(fact.createComponent(Ploc, attrs));
                Location ipLoc2 = Location.create(inputData.getInverterXLoc() - 40, invPosY - 10, true);
                result.add(Wire.create(ipLoc1, ipLoc2));
                ipLoc1 = Location.create(inputData.getSpineX(inputName, false), invPosY + 10, true);
                ipLoc2 = Location.create(inputData.getInverterXLoc() - 40, invPosY + 10, true);
                result.add(Wire.create(ipLoc1, ipLoc2));
                inputData.registerConnection(inputName, ipLoc1, false);
                IPloc3 = Location.create(inputData.getSpineX(inputName, true), invPosY, true);
                result.add(Wire.create(Ploc, IPloc3));
                inputData.registerConnection(inputName, IPloc3, true);
            } else {
                fact = NotGate.FACTORY;
                attrs = fact.createAttributeSet();
                Location Ploc = Location.create(inputData.getInverterXLoc(), invPosY, true);
                result.add(fact.createComponent(Ploc, attrs));
                Location IPloc1 = Location.create(inputData.getSpineX(inputName, false), invPosY, true);
                Location IPloc2 = Location.create(inputData.getInverterXLoc() - 30, invPosY, true);
                result.add(Wire.create(IPloc1, IPloc2));
                inputData.registerConnection(inputName, IPloc1, false);
                IPloc3 = Location.create(inputData.getSpineX(inputName, true), invPosY, true);
                result.add(Wire.create(Ploc, IPloc3));
                inputData.registerConnection(inputName, IPloc3, true);
            }
            CircuitBuilder.createSpine(result, inputData.getInputLocs((String)inputName, (boolean)true).ys, new CompareYs());
            invPosY += 40;
        }
    }

    private static void placeConstants(CircuitMutation result, InputData inputData) {
        Location loc;
        AttributeSet attrs;
        InstanceFactory fact = Constant.FACTORY;
        if (!inputData.getInputLocs((String)"0", (boolean)false).ys.isEmpty()) {
            attrs = fact.createAttributeSet();
            attrs.setValue(StdAttr.FACING, Direction.SOUTH);
            attrs.setValue(Constant.ATTR_VALUE, 0L);
            loc = Location.create(inputData.getSpineX("0", false), inputData.startY - 10, true);
            result.add(fact.createComponent(loc, attrs));
            inputData.registerConnection("0", loc, false);
            CircuitBuilder.createSpine(result, inputData.getInputLocs((String)"0", (boolean)false).ys, new CompareYs());
        }
        if (!inputData.getInputLocs((String)"1", (boolean)false).ys.isEmpty()) {
            attrs = fact.createAttributeSet();
            attrs.setValue(StdAttr.FACING, Direction.SOUTH);
            attrs.setValue(Constant.ATTR_VALUE, 1L);
            loc = Location.create(inputData.getSpineX("1", false), inputData.startY - 10, true);
            result.add(fact.createComponent(loc, attrs));
            inputData.registerConnection("1", loc, false);
            CircuitBuilder.createSpine(result, inputData.getInputLocs((String)"1", (boolean)false).ys, new CompareYs());
        }
    }

    private static void placeInputs(AnalyzerModel model, CircuitMutation result, InputData inputData, boolean useNands) {
        ArrayList<Location> forbiddenYs = new ArrayList<Location>();
        CompareYs compareYs = new CompareYs();
        int curX = inputData.getPinX();
        int curY = inputData.getStartY() + 20;
        VariableList inputs = model.getInputs();
        CircuitBuilder.placeInputInverters(result, inputData, useNands);
        CircuitBuilder.placeConstants(result, inputData);
        int idx = 0;
        int busNr = 0;
        int busY = inputData.startY - 10;
        for (int nr = 0; nr < inputs.vars.size(); ++nr) {
            Var inp = inputs.vars.get(nr);
            if (inp.width == 1) {
                name = inputData.getInputName(idx++);
                SingleInput singleInput = inputData.getInputLocs(name, false);
                int spineX = singleInput.spineX;
                Location spineLoc = Location.create(spineX, curY, true);
                if (!singleInput.ys.isEmpty()) {
                    forbiddenYs.sort(compareYs);
                    while (Collections.binarySearch(forbiddenYs, spineLoc, compareYs) >= 0) {
                        spineLoc = Location.create(spineX, curY += 10, true);
                    }
                    singleInput.ys.add(spineLoc);
                }
                Location loc = Location.create(curX, curY, true);
                CircuitBuilder.placeInput(result, loc, name, 1);
                ArrayList<Location> spine = singleInput.ys;
                if (!spine.isEmpty()) {
                    result.add(Wire.create(loc, spineLoc));
                    CircuitBuilder.createSpine(result, spine, compareYs);
                }
                forbiddenYs.addAll(singleInput.ys);
            } else {
                name = inp.name;
                Location ploc = Location.create(curX, curY, true);
                CircuitBuilder.placeInput(result, ploc, name, inp.width);
                String msbName = inputData.getInputName(idx);
                SingleInput singleInput = inputData.getInputLocs(msbName, false);
                int spineX = singleInput.spineX;
                Location sloc = Location.create(spineX - 10, busY - 20, true);
                CircuitBuilder.placeSplitter(result, sloc, inp.width, true);
                Location BI1 = Location.create(ploc.getX() + 10 + busNr * 10, ploc.getY(), true);
                Location BI2 = Location.create(BI1.getX(), sloc.getY(), true);
                result.add(Wire.create(ploc, BI1));
                result.add(Wire.create(BI1, BI2));
                result.add(Wire.create(BI2, sloc));
                ++busNr;
                for (int bit = inp.width - 1; bit >= 0; --bit) {
                    msbName = inputData.getInputName(idx++);
                    singleInput = inputData.getInputLocs(msbName, false);
                    spineX = singleInput.spineX;
                    ArrayList<Location> spine = singleInput.ys;
                    if (!spine.isEmpty()) {
                        Location bloc = Location.create(spineX, busY, true);
                        spine.add(bloc);
                        forbiddenYs.sort(compareYs);
                        CircuitBuilder.createSpine(result, spine, compareYs);
                    }
                    forbiddenYs.addAll(singleInput.ys);
                }
                busY -= 20;
            }
            curY += 30;
        }
    }

    private static void createSpine(CircuitMutation result, List<Location> spine, Comparator<Location> compareYs) {
        spine.sort(compareYs);
        Location prev = spine.get(0);
        int n = spine.size();
        for (int k = 1; k < n; ++k) {
            Location cur = spine.get(k);
            if (cur.equals(prev)) continue;
            result.add(Wire.create(prev, cur));
            prev = cur;
        }
    }

    private static void placeInput(CircuitMutation result, Location loc, String name, int nrOfBits) {
        Pin factory = Pin.FACTORY;
        AttributeSet attrs = factory.createAttributeSet();
        attrs.setValue(StdAttr.FACING, Direction.EAST);
        attrs.setValue(Pin.ATTR_TYPE, Pin.INPUT);
        attrs.setValue(Pin.ATTR_BEHAVIOR, Pin.SIMPLE);
        attrs.setValue(StdAttr.LABEL, name);
        attrs.setValue(ProbeAttributes.PROBEAPPEARANCE, ProbeAttributes.getDefaultProbeAppearance());
        attrs.setValue(StdAttr.WIDTH, BitWidth.create(nrOfBits));
        result.add(factory.createComponent(loc, attrs));
    }

    private static void placeSplitter(CircuitMutation result, Location loc, int nrOfBits, boolean input) {
        SplitterFactory factory = SplitterFactory.instance;
        AttributeSet attrs = factory.createAttributeSet();
        attrs.setValue(StdAttr.FACING, Direction.SOUTH);
        attrs.setValue(SplitterAttributes.ATTR_FANOUT, nrOfBits);
        attrs.setValue(SplitterAttributes.ATTR_WIDTH, BitWidth.create(nrOfBits));
        attrs.setValue(SplitterAttributes.ATTR_APPEARANCE, input ? SplitterAttributes.APPEAR_LEFT : SplitterAttributes.APPEAR_RIGHT);
        attrs.setValue(SplitterAttributes.ATTR_SPACING, 1);
        result.add(factory.createComponent(loc, attrs));
    }

    private static void placeOutputs(AnalyzerModel model, CircuitMutation result, InputData outputData) {
        int idx;
        int startX = 0;
        int nrOfBusses = 0;
        VariableList outputs = model.getOutputs();
        for (idx = 0; idx < outputData.getNrOfInputs(); ++idx) {
            int posX;
            String name = outputData.getInputName(idx);
            int n = posX = outputData.getInputLocs(name, false) == null ? 0 : outputData.getInputLocs((String)name, (boolean)false).spineX;
            if (posX <= startX) continue;
            startX = posX;
        }
        for (idx = 0; idx < outputs.vars.size(); ++idx) {
            if (outputs.vars.get((int)idx).width <= 1) continue;
            ++nrOfBusses;
        }
        int pinX = startX + outputData.getNrOfInputs() * 10 + 10;
        if (nrOfBusses > 0) {
            pinX += (nrOfBusses - 1) * 10 + 20;
        }
        int pinY = outputData.getStartY() + 20;
        int busX = pinX - 10;
        int busID = 0;
        int cnt = 0;
        for (int idx2 = 0; idx2 < outputs.vars.size(); ++idx2) {
            Var outp = outputs.vars.get(idx2);
            String name = outputData.getInputName(cnt);
            if (outp.width == 1) {
                pointP = Location.create(pinX, pinY, true);
                CircuitBuilder.placeOutput(result, pointP, outp.name, 1);
                SingleInput singleOutput = outputData.getInputLocs(name, false);
                if (singleOutput != null) {
                    Location pointC = Location.create(singleOutput.spineX, singleOutput.spineY, true);
                    int xOffset = startX + cnt * 10;
                    Location pointI1 = Location.create(xOffset, pointC.getY(), true);
                    Location pointI2 = Location.create(xOffset, pointP.getY(), true);
                    if (pointC.getX() != pointI1.getX()) {
                        result.add(Wire.create(pointC, pointI1));
                    }
                    if (pointI1.getY() != pointI2.getY()) {
                        result.add(Wire.create(pointI1, pointI2));
                    }
                    if (pointI2.getX() != pointP.getX()) {
                        result.add(Wire.create(pointI2, pointP));
                    }
                }
                ++cnt;
            } else {
                pointP = Location.create(pinX, pinY, true);
                CircuitBuilder.placeOutput(result, pointP, outp.name, outp.width);
                int sStartX = startX + cnt * 10;
                Location pointS = Location.create(sStartX + (outp.width - 1) * 10 + 10, 40 + busID * 20, true);
                CircuitBuilder.placeSplitter(result, pointS, outp.width, false);
                Location pointI1 = Location.create(busX - busID * 10, pointS.getY(), true);
                Location pointI2 = Location.create(pointI1.getX(), pointP.getY(), true);
                ++busID;
                if (pointS.getX() != pointI1.getX()) {
                    result.add(Wire.create(pointS, pointI1));
                }
                if (pointI1.getY() != pointI2.getY()) {
                    result.add(Wire.create(pointI1, pointI2));
                }
                if (pointI2.getX() != pointP.getX()) {
                    result.add(Wire.create(pointI2, pointP));
                }
                for (int bit = 0; bit < outp.width; ++bit) {
                    Location pointSe = Location.create(sStartX + bit * 10, pointS.getY() + 20, true);
                    String tName = outputData.getInputName(cnt + bit);
                    SingleInput singleOutput = outputData.getInputLocs(tName, false);
                    if (singleOutput == null) continue;
                    Location pointC = Location.create(singleOutput.spineX, singleOutput.spineY, true);
                    if (pointSe.getX() == pointC.getX()) {
                        result.add(Wire.create(pointSe, pointC));
                        continue;
                    }
                    Location pointI = Location.create(pointSe.getX(), pointC.getY(), true);
                    result.add(Wire.create(pointC, pointI));
                    result.add(Wire.create(pointSe, pointI));
                }
                cnt += outp.width;
            }
            pinY += 30;
        }
    }

    private static void placeOutput(CircuitMutation result, Location loc, String name, int nrOfBits) {
        Pin factory = Pin.FACTORY;
        AttributeSet attrs = factory.createAttributeSet();
        attrs.setValue(StdAttr.FACING, Direction.WEST);
        attrs.setValue(Pin.ATTR_TYPE, Pin.OUTPUT);
        attrs.setValue(Pin.ATTR_BEHAVIOR, Pin.SIMPLE);
        attrs.setValue(ProbeAttributes.PROBEAPPEARANCE, ProbeAttributes.getDefaultProbeAppearance());
        attrs.setValue(StdAttr.LABEL, name);
        attrs.setValue(StdAttr.WIDTH, BitWidth.create(nrOfBits));
        result.add(factory.createComponent(loc, attrs));
    }

    private static int roundDown(int value) {
        return value / 10 * 10;
    }

    private static int roundUp(int value) {
        return (value + 9) / 10 * 10;
    }

    private CircuitBuilder() {
    }

    private static class Layout {
        int y;
        final int width;
        final int height;
        final ComponentFactory factory;
        final AttributeSet attrs;
        final int outputY;
        final int subX;
        final Layout[] subLayouts;
        String inputName;
        boolean inverted;

        Layout(int width, int height, int outputY, ComponentFactory factory, AttributeSet attrs, Layout[] subLayouts, int subX) {
            this.width = width;
            this.height = CircuitBuilder.roundUp(height);
            this.outputY = outputY;
            this.factory = factory;
            this.attrs = attrs;
            this.subLayouts = subLayouts;
            this.subX = subX;
            this.inputName = null;
        }

        Layout(String inputName, boolean inverted) {
            this(0, 0, 0, null, null, null, 0);
            this.inputName = inputName;
            this.inverted = inverted;
        }
    }

    private static class InputData {
        int startX;
        int startY;
        int pinX;
        private final List<String> names = new ArrayList<String>();
        private final Map<String, SingleInput> inputs = new HashMap<String, SingleInput>();
        private final Map<String, SingleInput> invertedInputs = new HashMap<String, SingleInput>();

        InputData() {
        }

        public void addInput(String name, SingleInput info) {
            this.inputs.put(name, info);
            this.names.add(name);
        }

        public int createInvertedLocs(int spineX) {
            int cur = spineX + 10;
            this.addInput("0", new SingleInput(cur));
            this.addInput("1", new SingleInput(cur += 20));
            cur += 60;
            for (int i = 0; i < this.getNrOfInputs(); ++i) {
                this.invertedInputs.put(this.names.get(i), new SingleInput(cur));
                cur += 10;
            }
            return cur;
        }

        public int getInverterXLoc() {
            boolean hasZero;
            boolean hasOne = !this.inputs.get((Object)"1").ys.isEmpty();
            boolean bl = hasZero = !this.inputs.get((Object)"0").ys.isEmpty();
            if (hasOne) {
                return this.invertedInputs.get((Object)this.names.get((int)0)).spineX - 10;
            }
            if (hasZero) {
                return this.invertedInputs.get((Object)this.names.get((int)0)).spineX - 20;
            }
            return this.invertedInputs.get((Object)this.names.get((int)0)).spineX - 20 - 10;
        }

        public boolean hasInvertedConnections(String name) {
            SingleInput inp = this.invertedInputs.get(name);
            if (inp == null) {
                return false;
            }
            return !inp.ys.isEmpty();
        }

        int getNrOfInputs() {
            return this.names.size();
        }

        int getSpineX(String input, boolean inverted) {
            SingleInput data = inverted ? this.invertedInputs.get(input) : this.inputs.get(input);
            return data.spineX;
        }

        int getStartX() {
            return this.startX;
        }

        int getStartY() {
            return this.startY;
        }

        int getPinX() {
            return this.pinX;
        }

        public int getInverterHeight() {
            int nr = this.names.size();
            if (this.names.contains("0")) {
                --nr;
            }
            if (this.names.contains("1")) {
                --nr;
            }
            return nr * 40;
        }

        public SingleInput getInputLocs(String Name2, boolean inverted) {
            return inverted ? this.invertedInputs.get(Name2) : this.inputs.get(Name2);
        }

        public String getInputName(int index) {
            if (index < 0 || index >= this.getNrOfInputs()) {
                return null;
            }
            return this.names.get(index);
        }

        void registerConnection(String input, Location loc, boolean inverted) {
            SingleInput data = inverted ? this.invertedInputs.get(input) : this.inputs.get(input);
            data.ys.add(loc);
        }
    }

    private static class SingleInput {
        final int spineX;
        int spineY;
        final ArrayList<Location> ys = new ArrayList();

        SingleInput(int spineX) {
            this.spineX = spineX;
        }

        SingleInput(int spineX, int spineY) {
            this.spineX = spineX;
            this.spineY = spineY;
        }
    }

    private static class CompareYs
    implements Comparator<Location> {
        private CompareYs() {
        }

        @Override
        public int compare(Location a, Location b) {
            return a.getY() - b.getY();
        }
    }
}

