/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.arith.Shifter;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;

public class ShifterHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String SHIFT_MODE_STRING = "shifterMode";
    private static final int SHIFT_MODE_ID = -1;

    public ShifterHdlGeneratorFactory() {
        this.myParametersList.add(SHIFT_MODE_STRING, -1, 4, Shifter.ATTR_SHIFT, new HashMap<AttributeOption, Integer>(){
            {
                this.put(Shifter.SHIFT_LOGICAL_LEFT, 0);
                this.put(Shifter.SHIFT_ROLL_LEFT, 1);
                this.put(Shifter.SHIFT_LOGICAL_RIGHT, 2);
                this.put(Shifter.SHIFT_ARITHMETIC_RIGHT, 3);
                this.put(Shifter.SHIFT_ROLL_RIGHT, 4);
            }
        });
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        this.myPorts.add("input", "dataA", 0, 0, StdAttr.WIDTH).add("input", "shiftAmount", 0, 1, Shifter.SHIFT_BITS_ATTR).add("output", "result", 0, 2, StdAttr.WIDTH);
        for (int stage = 0; stage < attrs.getValue(Shifter.SHIFT_BITS_ATTR); ++stage) {
            this.myWires.addWire(String.format("s_stage%dResult", stage), attrs.getValue(StdAttr.WIDTH).getWidth()).addWire(String.format("s_stage%dShiftIn", stage), 1 << stage);
        }
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer().pair("shiftMode", SHIFT_MODE_STRING);
        int nrOfBits = attrs.getValue(StdAttr.WIDTH).getWidth();
        Integer nrOfShiftBits = attrs.getValue(Shifter.SHIFT_BITS_ATTR);
        contents.addRemarkBlock("ShifterMode represents when:\n0 : Logical Shift Left\n1 : Rotate Left\n2 : Logical Shift Right\n3 : Arithmetic Shift Right\n4 : Rotate Right\n");
        if (Hdl.isVhdl()) {
            if (nrOfBits == 1) {
                contents.addVhdlKeywords().add("result <= dataA {{when}} {{shiftMode}} = 1 {{or}}\n                     {{shiftMode}} = 3 {{or}}\n                     {{shiftMode}} = 4 {{else}} dataA {{and}} {{not}}(shiftAmount);\n");
            } else {
                for (int stage = 0; stage < nrOfShiftBits; ++stage) {
                    contents.add(this.getStageFunctionalityVhdl(stage, nrOfBits));
                }
                contents.empty().addRemarkBlock("The result is assigned here").add("result <= s_stage{{1}}Result;", nrOfShiftBits - 1);
            }
        } else if (nrOfBits == 1) {
            contents.add("assign result = ( ({{shiftMode}} == 1) ||\n                  ({{shiftMode}} == 3) ||\n                  ({{shiftMode}} == 4) ) ? dataA : dataA&(~shiftAmount);\n");
        } else {
            for (int stage = 0; stage < nrOfShiftBits; ++stage) {
                contents.add(this.getStageFunctionalityVerilog(stage, nrOfBits));
            }
            contents.empty().addRemarkBlock("The result is assigned here").add("assign result = s_stage{{1}}Result;", nrOfShiftBits - 1);
        }
        return contents.empty();
    }

    private LineBuffer getStageFunctionalityVerilog(int stageNumber, int nrOfBits) {
        LineBuffer contents = LineBuffer.getBuffer().pair("shiftMode", SHIFT_MODE_STRING).pair("stageNumber", stageNumber).pair("nrOfBits1", nrOfBits - 1).pair("nrOfBits2", nrOfBits - 2);
        int nrOfBitsToShift = 1 << stageNumber;
        contents.empty().addRemarkBlock(String.format("Stage %d of the binary shift tree is defined here", stageNumber));
        if (stageNumber == 0) {
            contents.add("assign s_stage0ShiftIn = (({{shiftMode}} == 1) || ({{shiftMode}} == 3))\n     ? dataA[{{shiftMode}}] : ({{nrOfBits1}} == 4) ? dataA[0] : 0;\n\nassign s_stage0Result  = (shiftAmount == 0)\n     ? dataA\n     : (({{shiftMode}} == 0) || ({{shiftMode}} == 1))\n        ? {dataA[{{nrOfBits2}}:0],s_stage0ShiftIn}\n        : {s_stage0ShiftIn,dataA[{{nrOfBits1}}:1]};\n\n");
        } else {
            contents.pair("stageNumber1", stageNumber - 1).pair("nrOfBitsToShift", nrOfBitsToShift).pair("nrOfBitsToShift1", nrOfBitsToShift - 1).pair("bitsShiftDiff", nrOfBits - nrOfBitsToShift).pair("bitsShiftDiff1", nrOfBits - nrOfBitsToShift - 1).add("assign s_stage{{stageNumber}}ShiftIn = ({{shiftMode}} == 1) ?\n                           s_stage{{stageNumber1}}Result[{{nrOfBits1}}:{{bitsShiftDiff}}] :\n                           ({{shiftMode}} == 3) ?\n                           { {{nrOfBitsToShift}}{s_stage{{stageNumber1}}Result[{{nrOfBits1}}]} } :\n                           ({{shiftMode}} == 4) ?\n                           s_stage{{stageNumber1}}Result[{{nrOfBitsToShift1}}:0] : 0;\n\nassign s_stage{{stageNumber}}Result  = (shiftAmount[{{stageNumber}}]==0) ?\n                           s_stage{{stageNumber1}}Result :\n                           (({{shiftMode}} == 0)||({{shiftMode}} == 1)) ?\n                           {s_stage{{stageNumber1}}Result[{{bitsShiftDiff1}}:0],s_stage{{stageNumber}}ShiftIn} :\n                           {s_stage{{stageNumber}}ShiftIn,s_stage{{stageNumber1}}Result[{{nrOfBits1}}:{{nrOfBitsToShift}}]};\n\n");
        }
        return contents;
    }

    private LineBuffer getStageFunctionalityVhdl(int stageNumber, int nrOfBits) {
        int nrOfBitsToShift = 1 << stageNumber;
        LineBuffer contents = LineBuffer.getBuffer().addVhdlKeywords().pair("shiftMode", SHIFT_MODE_STRING).pair("stageNumber", stageNumber).pair("stageNumber1", stageNumber - 1).pair("nrOfBits1", nrOfBits - 1).pair("nrOfBits2", nrOfBits - 2).pair("bitsShiftDiff", nrOfBits - nrOfBitsToShift).pair("bitsShiftDiff1", nrOfBits - nrOfBitsToShift - 1).pair("nrOfBitsToShift", nrOfBitsToShift).pair("nrOfBitsToShift1", nrOfBitsToShift - 1).empty().addRemarkBlock(String.format("Stage %d of the binary shift tree is defined here", stageNumber));
        if (stageNumber == 0) {
            contents.add("s_stage0ShiftIn <= dataA({{nrOfBits1}}) {{when}} {{shiftMode}} = 1 {{or}} {{shiftMode}} = 3 {{else}}\n                   dataA(0) {{when}} {{shiftMode}} = 4 {{else}} '0';\n\ns_stage0Result  <= dataA\n").add(nrOfBits == 2 ? "                      {{when}} shiftAmount = '0' {{else}}" : "                      {{when}} shiftAmount(0) = '0' {{else}}").add("                   dataA({{nrOfBits2}} {{downto}} 0)&s_stage0ShiftIn\n                      {{when}} {{shiftMode}} = 0 {{or}} {{shiftMode}} = 1 {{else}}\n                   s_stage0ShiftIn&dataA( {{nrOfBits1}} {{downto}} 1 );\n");
        } else {
            contents.add("s_stage{{stageNumber}}ShiftIn <= s_stage{{stageNumber1}}Result( {{nrOfBits1}} {{downto}} {{bitsShiftDiff}} ) {{when}} {{shiftMode}} = 1 {{else}}\n                   ({{others}} => s_stage{{stageNumber1}}Result({{stageNumber1}})) {{when}} {{shiftMode}} = 3 {{else}}\n                   s_stage{{stageNumber1}}Result( {{nrOfBitsToShift1}} {{downto}} 0 ) {{when}} {{shiftMode}} = 4 {{else}}\n                   ({{others}} => '0');\n\ns_stage{{stageNumber}}Result  <= s_stage{{stageNumber1}}Result\n                      {{when}} shiftAmount({{stageNumber}}) = '0' {{else}}\n                   s_stage{{stageNumber1}}Result( {{bitsShiftDiff1}} {{downto}} 0 )&s_stage{{stageNumber}}ShiftIn\n                      {{when}} {{shiftMode}} = 0 {{or}} {{shiftMode}} = 1 {{else}}\n                   s_stage{{stageNumber}}ShiftIn&s_stage{{stageNumber1}}Result( {{nrOfBits1}} {{downto}} {{nrOfBitsToShift}} );\n");
        }
        return contents;
    }
}

