/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.arith.AdderHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Adder
extends InstanceFactory {
    public static final String _ID = "Adder";
    static final int PER_DELAY = 1;
    public static final int IN0 = 0;
    public static final int IN1 = 1;
    public static final int OUT = 2;
    public static final int C_IN = 3;
    public static final int C_OUT = 4;

    static Value[] computeSum(BitWidth width, Value valueA, Value valueB, Value cIn) {
        int w = width.getWidth();
        if (cIn == Value.UNKNOWN || cIn == Value.NIL) {
            cIn = Value.FALSE;
        }
        if (valueA.isFullyDefined() && valueB.isFullyDefined() && cIn.isFullyDefined()) {
            if (w == 64) {
                long ax = valueA.toLongValue();
                long bx = valueB.toLongValue();
                long cx = cIn.toLongValue();
                long mask = Long.MAX_VALUE;
                boolean aLast = ax < 0L;
                boolean bLast = bx < 0L;
                boolean cInLast = (ax & Long.MAX_VALUE) + (bx & Long.MAX_VALUE) + cx < 0L;
                boolean cOut = aLast && bLast || aLast && cInLast || bLast && cInLast;
                long sum = valueA.toLongValue() + valueB.toLongValue() + cIn.toLongValue();
                return new Value[]{Value.createKnown(width, sum), cOut ? Value.TRUE : Value.FALSE};
            }
            long sum = valueA.toLongValue() + valueB.toLongValue() + cIn.toLongValue();
            return new Value[]{Value.createKnown(width, sum), (sum >> w & 1L) == 0L ? Value.FALSE : Value.TRUE};
        }
        Value[] bits = new Value[w];
        Value carry = cIn;
        for (int i = 0; i < w; ++i) {
            if (carry == Value.ERROR) {
                bits[i] = Value.ERROR;
                continue;
            }
            if (carry == Value.UNKNOWN) {
                bits[i] = Value.UNKNOWN;
                continue;
            }
            Value ab = valueA.get(i);
            Value bb = valueB.get(i);
            if (ab == Value.ERROR || bb == Value.ERROR) {
                bits[i] = Value.ERROR;
                carry = Value.ERROR;
                continue;
            }
            if (ab == Value.UNKNOWN || bb == Value.UNKNOWN) {
                bits[i] = Value.UNKNOWN;
                carry = Value.UNKNOWN;
                continue;
            }
            int sum = (ab == Value.TRUE ? 1 : 0) + (bb == Value.TRUE ? 1 : 0) + (carry == Value.TRUE ? 1 : 0);
            bits[i] = (sum & 1) == 1 ? Value.TRUE : Value.FALSE;
            carry = sum >= 2 ? Value.TRUE : Value.FALSE;
        }
        return new Value[]{Value.create(bits), carry};
    }

    public Adder() {
        super(_ID, Strings.S.getter("adderComponent"), new AdderHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.WIDTH}, new Object[]{BitWidth.create(8)});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("+"));
        Port[] ps = new Port[]{new Port(-40, -10, "input", StdAttr.WIDTH), new Port(-40, 10, "input", StdAttr.WIDTH), new Port(0, 0, "output", StdAttr.WIDTH), new Port(-20, -20, "input", 1), new Port(-20, 20, "output", 1)};
        ps[0].setToolTip(Strings.S.getter("adderInputTip"));
        ps[1].setToolTip(Strings.S.getter("adderInputTip"));
        ps[2].setToolTip(Strings.S.getter("adderOutputTip"));
        ps[3].setToolTip(Strings.S.getter("adderCarryInTip"));
        ps[4].setToolTip(Strings.S.getter("adderCarryOutTip"));
        this.setPorts(ps);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        int nrOfBits = attrs.getValue(StdAttr.WIDTH).getWidth();
        return nrOfBits == 1 ? "FullAdder" : CorrectLabel.getCorrectLabel(this.getName());
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        g.setColor(new Color(AppPreferences.COMPONENT_SECONDARY_COLOR.get()));
        painter.drawPort(0);
        painter.drawPort(1);
        painter.drawPort(2);
        painter.drawPort(3, "c in", Direction.NORTH);
        painter.drawPort(4, "c out", Direction.SOUTH);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        g.drawLine(x - 15, y, x - 5, y);
        g.drawLine(x - 10, y - 5, x - 10, y + 5);
        GraphicsUtil.switchToWidth(g, 1);
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        Value a = state.getPortValue(0);
        Value b = state.getPortValue(1);
        Value cIn = state.getPortValue(3);
        Value[] outs = Adder.computeSum(dataWidth, a, b, cIn);
        int delay = (dataWidth.getWidth() + 2) * 1;
        state.setPort(2, outs[0], delay);
        state.setPort(4, outs[1], delay);
    }
}

