/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.util;

import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.util.AssemblerToken;
import com.cburch.logisim.util.StringGetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AssemblerAsmInstruction {
    private final AssemblerToken instruction;
    private final ArrayList<AssemblerToken[]> parameters;
    private final int size;
    private final HashMap<AssemblerToken, StringGetter> errors;
    private Byte[] bytes;
    private long programCounter;

    public AssemblerAsmInstruction(AssemblerToken instruction, int size) {
        this.instruction = instruction;
        this.parameters = new ArrayList();
        this.errors = new HashMap();
        this.size = size;
        this.bytes = null;
        this.programCounter = -1L;
    }

    public String getOpcode() {
        return this.instruction.getValue();
    }

    public AssemblerToken getInstruction() {
        return this.instruction;
    }

    public int getNrOfParameters() {
        return this.parameters.size();
    }

    public void addParameter(AssemblerToken[] param) {
        this.parameters.add(param);
    }

    public int getSizeInBytes() {
        return this.size;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void setError(AssemblerToken token, StringGetter error) {
        this.errors.put(token, error);
    }

    public Map<AssemblerToken, StringGetter> getErrors() {
        return this.errors;
    }

    public Byte[] getBytes() {
        return this.bytes;
    }

    public void setProgramCounter(long value) {
        this.programCounter = value;
    }

    public long getProgramCounter() {
        return this.programCounter;
    }

    public void setInstructionByteCode(int instruction, int nrOfBytes) {
        if (this.bytes == null) {
            this.bytes = new Byte[this.size];
        }
        for (int i = 0; i < nrOfBytes && i < this.size; ++i) {
            this.bytes[i] = (byte)(instruction >> i * 8 & 0xFF);
        }
    }

    public void setInstructionByteCode(int[] instruction, int nrOfBytes) {
        if (this.bytes == null) {
            this.bytes = new Byte[this.size];
        }
        for (int j = 0; j < instruction.length; ++j) {
            for (int i = 0; i < nrOfBytes && i < this.size; ++i) {
                this.bytes[j * nrOfBytes + i] = (byte)(instruction[j] >> i * 8 & 0xFF);
            }
        }
    }

    public AssemblerToken[] getParameter(int index) {
        if (index < 0 || index >= this.parameters.size()) {
            return null;
        }
        return this.parameters.get(index);
    }

    public boolean replaceLabels(Map<String, Long> labels, Map<AssemblerToken, StringGetter> errors) {
        for (AssemblerToken[] parameter : this.parameters) {
            for (AssemblerToken assemblerToken : parameter) {
                if (assemblerToken.getType() != 16) continue;
                String name = assemblerToken.getValue();
                if (!labels.containsKey(name)) {
                    errors.put(assemblerToken, Strings.S.getter("AssemblerCouldNotFindAddressForLabel"));
                    return false;
                }
                assemblerToken.setType(7);
                assemblerToken.setValue(String.format("0x%08X", labels.get(name)));
            }
        }
        return true;
    }

    public boolean replaceDefines(Map<String, Integer> defines, Map<AssemblerToken, StringGetter> errors) {
        for (AssemblerToken[] parameter : this.parameters) {
            for (AssemblerToken assemblerToken : parameter) {
                if (assemblerToken.getType() != 8) continue;
                String name = assemblerToken.getValue();
                if (!defines.containsKey(name)) {
                    errors.put(assemblerToken, Strings.S.getter("AssemblerCouldNotFindValueForDefine"));
                    return false;
                }
                assemblerToken.setType(7);
                assemblerToken.setValue(String.format("0x%08X", defines.get(name)));
            }
        }
        return true;
    }

    public void replacePcAndDoCalc(long pc, Map<AssemblerToken, StringGetter> errors) {
        for (int idx = 0; idx < this.parameters.size(); ++idx) {
            int i;
            AssemblerToken[] parameter = this.parameters.get(idx);
            boolean found = false;
            for (AssemblerToken assemblerToken : parameter) {
                if (assemblerToken.getType() != 22) continue;
                found = true;
                assemblerToken.setType(7);
                assemblerToken.setValue(String.format("0x%08X", pc));
            }
            if (!found || parameter.length <= 1) continue;
            HashSet<Integer> toBeRemoved = new HashSet<Integer>();
            for (i = 0; i < parameter.length; ++i) {
                if (!AssemblerToken.MATH_OPERATORS.contains(parameter[i].getType())) continue;
                long beforeValue = -1L;
                if (i == 0 || !parameter[i - 1].isNumber()) {
                    beforeValue = 0L;
                    continue;
                }
                if (i + 1 >= parameter.length || !parameter[i + 1].isNumber()) {
                    errors.put(parameter[i], Strings.S.getter("AssemblerExpectedImmediateValueAfterMath"));
                    continue;
                }
                if (beforeValue < 0L) {
                    toBeRemoved.add(i - 1);
                    beforeValue = parameter[i - 1].getLongValue();
                }
                long afterValue = parameter[i + 1].getLongValue();
                toBeRemoved.add(i);
                long result = 0L;
                switch (parameter[i].getType()) {
                    case 15: {
                        result = beforeValue + afterValue;
                        break;
                    }
                    case 14: {
                        result = beforeValue - afterValue;
                        break;
                    }
                    case 20: {
                        result = beforeValue << (int)afterValue;
                        break;
                    }
                    case 21: {
                        result = beforeValue >> (int)afterValue;
                        break;
                    }
                    case 17: {
                        result = beforeValue * afterValue;
                        break;
                    }
                    case 18: {
                        if (afterValue == 0L) {
                            errors.put(parameter[i + 1], Strings.S.getter("AssemblerDivZero"));
                            break;
                        }
                        result = beforeValue / afterValue;
                        break;
                    }
                    case 19: {
                        if (afterValue == 0L) {
                            errors.put(parameter[i + 1], Strings.S.getter("AssemblerDivZero"));
                            break;
                        }
                        result = beforeValue % afterValue;
                    }
                }
                parameter[i + 1].setType(7);
                parameter[i + 1].setValue(String.format("0x%X", result));
            }
            int newNrOfParameters = parameter.length - toBeRemoved.size();
            AssemblerToken[] newParameter = new AssemblerToken[newNrOfParameters];
            int j = 0;
            for (i = 0; i < parameter.length; ++i) {
                if (toBeRemoved.contains(i)) continue;
                newParameter[j] = parameter[i];
                ++j;
            }
            this.parameters.set(idx, newParameter);
        }
    }
}

