/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.rv32im;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.rv32im.RV32imSupport;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import java.util.ArrayList;
import java.util.Arrays;

public class Rv32imMemoryOrderingInstructions
implements AssemblerExecutionInterface {
    private static final int FENCE = 15;
    private static final int I_FLAG = 8;
    private static final int O_FLAG = 4;
    private static final int R_FLAG = 2;
    private static final int W_FLAG = 1;
    private static final int INSTR_FENCE = 0;
    private static final int INSTR_FENCE_TSO = 1;
    private static final String[] AsmOpcodes = new String[]{"FENCE", "FENCE.TSO"};
    private int instruction = 0;
    private boolean valid = false;
    private int succ;
    private int pred;
    private int fm;
    private int operation;

    @Override
    public ArrayList<String> getInstructions() {
        ArrayList<String> opcodes = new ArrayList<String>(Arrays.asList(AsmOpcodes));
        return opcodes;
    }

    @Override
    public boolean execute(Object state, CircuitState cState) {
        if (!this.valid) {
            return false;
        }
        OptionPane.showMessageDialog(null, Strings.S.get("Rv32imMOINotImplmented"));
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(AsmOpcodes[this.operation].toLowerCase());
        if (this.operation != 1) {
            while (s.length() < 10) {
                s.append(" ");
            }
            this.addMasks(s, this.succ);
            s.append(",");
            this.addMasks(s, this.pred);
        }
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = this.decodeBin();
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private boolean decodeBin() {
        if (RV32imSupport.getOpcode(this.instruction) == 15) {
            if (RV32imSupport.getFunct3(this.instruction) != 0) {
                return false;
            }
            this.succ = this.instruction >> 20 & 0xF;
            this.pred = this.instruction >> 24 & 0xF;
            this.fm = this.instruction >> 28 & 0xF;
            int rwmask = 3;
            this.operation = this.fm == 8 && this.succ == rwmask && this.pred == rwmask ? 1 : 0;
            return true;
        }
        return false;
    }

    private void addMasks(StringBuilder buffer, int value) {
        if ((value & 8) != 0) {
            buffer.append("i");
        }
        if ((value & 4) != 0) {
            buffer.append("o");
        }
        if ((value & 2) != 0) {
            buffer.append("r");
        }
        if ((value & 1) != 0) {
            buffer.append("w");
        }
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.getInstructions().contains(instruction.toUpperCase())) {
            return 4;
        }
        return -1;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        int operation = -1;
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            if (!AsmOpcodes[i].equals(instr.getOpcode().toUpperCase())) continue;
            operation = i;
        }
        if (operation < 0) {
            this.valid = false;
            return false;
        }
        instr.setError(instr.getInstruction(), Strings.S.getter("RV32imAssemblerNotSupportedYet"));
        this.valid = false;
        return true;
    }
}

