/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.file;

import com.cburch.logisim.soc.file.ElfHeader;
import com.cburch.logisim.soc.file.SymbolTable;
import java.util.ArrayList;
import java.util.List;

public class SectionHeader {
    public static final int SH_NAME = 0;
    public static final int SH_TYPE = 1;
    public static final int SH_FLAGS = 2;
    public static final int SH_ADDR = 3;
    public static final int SH_OFFSET = 4;
    public static final int SH_SIZE = 5;
    public static final int SH_LINK = 6;
    public static final int SH_INFO = 7;
    public static final int SH_ADDR_ALIGN = 8;
    public static final int SH_ENTSIZE = 9;
    public static final int SHF_WRITE = 1;
    public static final int SHF_ALLOC = 2;
    public static final int SHF_EXEC_INSTR = 4;
    public static final int SHF_MASK_PROC = -268435456;
    public static final int SHT_NULL = 0;
    public static final int SHT_PROG_BITS = 1;
    public static final int SHT_SYMTAB = 2;
    public static final int SHT_STRTAB = 3;
    public static final int SHT_RELA = 4;
    public static final int SHT_HASH = 5;
    public static final int SHT_DYNAMIC = 6;
    public static final int SHT_NOTE = 7;
    public static final int SHT_NO_BITS = 8;
    public static final int SHT_REL = 9;
    public static final int SHT_SHLIB = 10;
    public static final int SHT_DYN_SYM = 11;
    public static final int SHT_LO_PROC = 0x70000000;
    public static final int SHT_HI_PROC = Integer.MAX_VALUE;
    public static final int SHT_LO_USER = Integer.MIN_VALUE;
    public static final int SHT_HI_USER = -1;
    private final Integer shName;
    private final Integer shType;
    private Long shFlags;
    private Long shAddr;
    private final Long shOffset;
    private Long shSize;
    private final Integer shLink;
    private final Integer shInfo;
    private final Long shAddrAlign;
    private final Long shEntSize;
    private final boolean is32Bit;
    private String name;
    private final ArrayList<SymbolTable> symbols;

    public SectionHeader(byte[] buffer, boolean is32Bit, boolean isLittleEndian, int offset) {
        this.is32Bit = is32Bit;
        int index = offset;
        int increment = is32Bit ? 4 : 8;
        this.shName = ElfHeader.getIntValue(buffer, index, 4, isLittleEndian);
        this.shType = ElfHeader.getIntValue(buffer, index += 4, 4, isLittleEndian);
        this.shFlags = ElfHeader.getLongValue(buffer, index += 4, increment, isLittleEndian);
        this.shAddr = ElfHeader.getLongValue(buffer, index += increment, increment, isLittleEndian);
        this.shOffset = ElfHeader.getLongValue(buffer, index += increment, increment, isLittleEndian);
        this.shSize = ElfHeader.getLongValue(buffer, index += increment, increment, isLittleEndian);
        this.shLink = ElfHeader.getIntValue(buffer, index += increment, 4, isLittleEndian);
        this.shInfo = ElfHeader.getIntValue(buffer, index += 4, 4, isLittleEndian);
        this.shAddrAlign = ElfHeader.getLongValue(buffer, index += 4, increment, isLittleEndian);
        this.shEntSize = ElfHeader.getLongValue(buffer, index += increment, increment, isLittleEndian);
        this.name = "";
        this.symbols = new ArrayList();
    }

    public SectionHeader(String name) {
        this.symbols = new ArrayList();
        this.name = name;
        this.is32Bit = true;
        this.shName = -1;
        this.shType = 1;
        this.shFlags = 2L;
        if (!name.equals(".rodata")) {
            this.shFlags = this.shFlags | 1L;
        }
        this.shAddr = 0L;
        this.shOffset = -1L;
        this.shSize = -1L;
        this.shLink = 0;
        this.shInfo = 0;
        this.shAddrAlign = 0L;
        this.shEntSize = 0L;
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getName() {
        return this.name;
    }

    public void addSymbol(SymbolTable info) {
        this.symbols.add(info);
    }

    public List<SymbolTable> getSymbols() {
        return this.symbols;
    }

    public boolean isWritable() {
        return (this.shFlags & 1L) != 0L;
    }

    public boolean isAllocated() {
        return (this.shFlags & 2L) != 0L;
    }

    public boolean isExecutable() {
        return (this.shFlags & 4L) != 0L;
    }

    public void setStartAddress(long addr) {
        this.shAddr = addr;
    }

    public void addExecutableFlag() {
        this.shFlags = this.shFlags | 4L;
    }

    public void setSize(long size) {
        this.shSize = size;
    }

    public Object getValue(int identifier) {
        return switch (identifier) {
            case 0 -> this.shName;
            case 1 -> this.shType;
            case 2 -> ElfHeader.returnCorrectValue(this.shFlags, this.is32Bit);
            case 3 -> ElfHeader.returnCorrectValue(this.shAddr, this.is32Bit);
            case 4 -> ElfHeader.returnCorrectValue(this.shOffset, this.is32Bit);
            case 5 -> ElfHeader.returnCorrectValue(this.shSize, this.is32Bit);
            case 6 -> this.shLink;
            case 7 -> this.shInfo;
            case 8 -> ElfHeader.returnCorrectValue(this.shAddrAlign, this.is32Bit);
            case 9 -> ElfHeader.returnCorrectValue(this.shEntSize, this.is32Bit);
            default -> null;
        };
    }
}

