/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocSimulationManager;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class SocBusInfo {
    private String busId;
    private SocSimulationManager socManager;
    private Component myComp;

    public SocBusInfo(String id) {
        this.busId = id;
        this.socManager = null;
    }

    public void setBusId(String value) {
        this.busId = value;
    }

    public String getBusId() {
        return this.busId;
    }

    public void setSocSimulationManager(SocSimulationManager man, Component comp) {
        this.socManager = man;
        this.myComp = comp;
    }

    public SocSimulationManager getSocSimulationManager() {
        return this.socManager;
    }

    public Component getComponent() {
        return this.myComp;
    }

    public void paint(Graphics g, Bounds b) {
        String ident = this.socManager == null ? null : this.socManager.getSocBusDisplayString(this.busId);
        Color color = ident == null ? Color.RED : Color.GREEN;
        g.setColor(color);
        g.fillRect(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        g.setColor(Color.BLACK);
        GraphicsUtil.drawCenteredText(g, ident == null ? Strings.S.get("SocBusNotConnected") : ident, b.getCenterX(), b.getCenterY());
    }
}

