/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.proj;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.util.Dag;
import com.cburch.logisim.vhdl.base.VhdlContent;
import com.cburch.logisim.vhdl.base.VhdlEntity;

public class Dependencies {
    private final MyListener myListener = new MyListener();
    private final Dag depends = new Dag();

    Dependencies(LogisimFile file) {
        this.addDependencies(file);
    }

    private void addDependencies(LogisimFile file) {
        file.addLibraryListener(this.myListener);
        for (Circuit circuit : file.getCircuits()) {
            this.processCircuit(circuit);
        }
    }

    public boolean canAdd(Circuit circ, Circuit sub) {
        return this.depends.canFollow(sub, circ);
    }

    public boolean canRemove(Circuit circ) {
        return !this.depends.hasPredecessors(circ);
    }

    public boolean canRemove(VhdlContent vhdl) {
        return !this.depends.hasPredecessors(vhdl);
    }

    private void processCircuit(Circuit circ) {
        circ.addCircuitListener(this.myListener);
        for (Component comp : circ.getNonWires()) {
            ComponentFactory componentFactory = comp.getFactory();
            if (componentFactory instanceof SubcircuitFactory) {
                SubcircuitFactory factory = (SubcircuitFactory)componentFactory;
                this.depends.addEdge(circ, factory.getSubcircuit());
                continue;
            }
            componentFactory = comp.getFactory();
            if (!(componentFactory instanceof VhdlEntity)) continue;
            VhdlEntity factory = (VhdlEntity)componentFactory;
            this.depends.addEdge(circ, factory.getContent());
        }
    }

    private class MyListener
    implements LibraryListener,
    CircuitListener {
        private MyListener() {
        }

        @Override
        public void circuitChanged(CircuitEvent e) {
            switch (e.getAction()) {
                case 1: {
                    Component comp = (Component)e.getData();
                    ComponentFactory componentFactory = comp.getFactory();
                    if (componentFactory instanceof SubcircuitFactory) {
                        SubcircuitFactory factory = (SubcircuitFactory)componentFactory;
                        Dependencies.this.depends.addEdge(e.getCircuit(), factory.getSubcircuit());
                        break;
                    }
                    componentFactory = comp.getFactory();
                    if (!(componentFactory instanceof VhdlEntity)) break;
                    VhdlEntity factory = (VhdlEntity)componentFactory;
                    Dependencies.this.depends.addEdge(e.getCircuit(), factory.getContent());
                    break;
                }
                case 2: {
                    Component comp = (Component)e.getData();
                    ComponentFactory componentFactory = comp.getFactory();
                    if (componentFactory instanceof SubcircuitFactory) {
                        SubcircuitFactory factory = (SubcircuitFactory)componentFactory;
                        boolean found = false;
                        for (Component o : e.getCircuit().getNonWires()) {
                            if (o.getFactory() != factory) continue;
                            found = true;
                            break;
                        }
                        if (found) break;
                        Dependencies.this.depends.removeEdge(e.getCircuit(), factory.getSubcircuit());
                        break;
                    }
                    ComponentFactory found = comp.getFactory();
                    if (!(found instanceof VhdlEntity)) break;
                    VhdlEntity factory = (VhdlEntity)found;
                    boolean found2 = false;
                    for (Component o : e.getCircuit().getNonWires()) {
                        if (o.getFactory() != factory) continue;
                        found2 = true;
                        break;
                    }
                    if (found2) break;
                    Dependencies.this.depends.removeEdge(e.getCircuit(), factory.getContent());
                    break;
                }
                case 5: {
                    Dependencies.this.depends.removeNode(e.getCircuit());
                }
            }
        }

        @Override
        public void libraryChanged(LibraryEvent e) {
            switch (e.getAction()) {
                case 0: {
                    AddTool tool;
                    ComponentFactory factory;
                    Object object = e.getData();
                    if (!(object instanceof AddTool) || !((factory = (tool = (AddTool)object).getFactory()) instanceof SubcircuitFactory)) break;
                    SubcircuitFactory circFact = (SubcircuitFactory)factory;
                    Dependencies.this.processCircuit(circFact.getSubcircuit());
                    break;
                }
                case 1: {
                    Object factory = e.getData();
                    if (!(factory instanceof AddTool)) break;
                    AddTool tool = (AddTool)factory;
                    if ((factory = tool.getFactory()) instanceof SubcircuitFactory) {
                        SubcircuitFactory circFact = (SubcircuitFactory)factory;
                        Circuit circ = circFact.getSubcircuit();
                        Dependencies.this.depends.removeNode(circ);
                        circ.removeCircuitListener(this);
                        break;
                    }
                    if (!(factory instanceof VhdlEntity)) break;
                    VhdlEntity circFact = (VhdlEntity)factory;
                    Dependencies.this.depends.removeNode(circFact.getContent());
                }
            }
        }
    }
}

