/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.instance;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.tools.AbstractCaret;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.Pokable;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InstancePokerAdapter
extends AbstractCaret
implements Pokable {
    static final Logger logger = LoggerFactory.getLogger(InstancePokerAdapter.class);
    private InstanceComponent comp;
    private Canvas canvas;
    private InstancePoker poker;
    private InstanceStateImpl state;
    private ComponentDrawContext context;

    public InstancePokerAdapter(InstanceComponent comp, Class<? extends InstancePoker> pokerClass) {
        try {
            this.comp = comp;
            this.poker = pokerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception t) {
            this.handleError(t, pokerClass);
            this.poker = null;
        }
    }

    private void checkCurrent() {
        CircuitState s1;
        CircuitState s0;
        if (this.state != null && this.canvas != null && (s0 = this.state.getCircuitState()) != (s1 = this.canvas.getCircuitState())) {
            this.state = new InstanceStateImpl(s1, this.comp);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this.poker != null) {
            this.context.setGraphics(g);
            this.poker.paint(new InstancePainter(this.context, this.comp));
        }
    }

    @Override
    public Bounds getBounds(Graphics gfx) {
        if (this.poker != null) {
            this.context.setGraphics(gfx);
            return this.poker.getBounds(new InstancePainter(this.context, this.comp));
        }
        return Bounds.EMPTY_BOUNDS;
    }

    @Override
    public Caret getPokeCaret(ComponentUserEvent event) {
        MouseEvent e;
        if (this.poker == null) {
            return null;
        }
        this.canvas = event.getCanvas();
        CircuitState circState = event.getCircuitState();
        InstanceStateImpl state = new InstanceStateImpl(circState, this.comp);
        boolean isAccepted = this.poker.init(state, e = new MouseEvent(event.getCanvas(), 501, System.currentTimeMillis(), 0, event.getX(), event.getY(), 1, false));
        if (isAccepted) {
            this.state = state;
            this.context = new ComponentDrawContext(event.getCanvas(), event.getCanvas().getCircuit(), circState, null, null);
            this.mousePressed(e);
            return this;
        }
        this.poker = null;
        return null;
    }

    private void handleError(Throwable t, Class<? extends InstancePoker> pokerClass) {
        String className = pokerClass.getName();
        logger.error("Error while instantiating poker {}: {}", (Object)className, (Object)t.getClass().getName());
        String msg = t.getMessage();
        if (msg != null) {
            logger.error("  ({})", (Object)msg);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.poker != null) {
            this.poker.keyPressed(this.state, e);
            this.checkCurrent();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.poker != null) {
            this.poker.keyReleased(this.state, e);
            this.checkCurrent();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.poker != null) {
            this.poker.keyTyped(this.state, e);
            this.checkCurrent();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.poker != null) {
            this.poker.mouseDragged(this.state, e);
            this.checkCurrent();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.poker != null) {
            this.poker.mousePressed(this.state, e);
            this.checkCurrent();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.poker != null) {
            this.poker.mouseReleased(this.state, e);
            this.checkCurrent();
        }
    }

    @Override
    public void stopEditing() {
        if (this.poker != null) {
            this.poker.stopEditing(this.state);
            this.checkCurrent();
        }
    }
}

