/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.draw.toolbar.AbstractToolbarModel;
import com.cburch.draw.toolbar.ToolbarItem;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.icons.AppearEditIcon;
import com.cburch.logisim.gui.icons.FatArrowIcon;
import com.cburch.logisim.gui.icons.ProjectAddIcon;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.gui.main.LogisimToolbarItem;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.MenuListener;
import com.cburch.logisim.util.UnmodifiableList;
import java.util.List;

class ToolboxToolbarModel
extends AbstractToolbarModel
implements MenuListener.EnabledListener {
    private final Frame frame;
    private final LogisimToolbarItem itemAdd;
    private final LogisimToolbarItem itemAddVhdl;
    private final LogisimToolbarItem itemUp;
    private final LogisimToolbarItem itemDown;
    private final LogisimToolbarItem itemAppearance;
    private final LogisimToolbarItem itemDelete;
    private final List<ToolbarItem> items;

    public ToolboxToolbarModel(Frame frame, MenuListener menu) {
        this.frame = frame;
        this.itemAdd = new LogisimToolbarItem(menu, new ProjectAddIcon(false), LogisimMenuBar.ADD_CIRCUIT, Strings.S.getter("projectAddCircuitTip"));
        this.itemAddVhdl = new LogisimToolbarItem(menu, new ProjectAddIcon(), LogisimMenuBar.ADD_VHDL, Strings.S.getter("projectAddVhdlItem"));
        this.itemUp = new LogisimToolbarItem(menu, new FatArrowIcon(Direction.NORTH), LogisimMenuBar.MOVE_CIRCUIT_UP, Strings.S.getter("projectMoveCircuitUpTip"));
        this.itemDown = new LogisimToolbarItem(menu, new FatArrowIcon(Direction.SOUTH), LogisimMenuBar.MOVE_CIRCUIT_DOWN, Strings.S.getter("projectMoveCircuitDownTip"));
        this.itemAppearance = new LogisimToolbarItem(menu, new AppearEditIcon(), LogisimMenuBar.TOGGLE_APPEARANCE, Strings.S.getter("projectEditAppearanceTip"));
        this.itemDelete = new LogisimToolbarItem(menu, new ProjectAddIcon(true), LogisimMenuBar.REMOVE_CIRCUIT, Strings.S.getter("projectRemoveCircuitTip"));
        this.items = UnmodifiableList.create(new ToolbarItem[]{this.itemAdd, this.itemAddVhdl, this.itemUp, this.itemDown, this.itemAppearance, this.itemDelete});
        menu.addEnabledListener(this);
    }

    @Override
    public List<ToolbarItem> getItems() {
        return this.items;
    }

    @Override
    public boolean isSelected(ToolbarItem item) {
        return item == this.itemAppearance && this.frame.getEditorView().equals("appearance");
    }

    @Override
    public void itemSelected(ToolbarItem item) {
        if (item instanceof LogisimToolbarItem) {
            LogisimToolbarItem toolbarItem = (LogisimToolbarItem)item;
            toolbarItem.doAction();
        }
    }

    @Override
    public void menuEnableChanged(MenuListener source) {
        this.fireToolbarAppearanceChanged();
    }
}

