/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.gui.main.Clipboard;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.gui.main.SelectionActions;
import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.std.base.BaseLibrary;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class LayoutEditHandler
extends EditHandler
implements ProjectListener,
LibraryListener,
PropertyChangeListener {
    private final Frame frame;

    LayoutEditHandler(Frame frame) {
        this.frame = frame;
        Project proj = frame.getProject();
        Clipboard.addPropertyChangeListener("contents", this);
        proj.addProjectListener(this);
        proj.addLibraryListener(this);
    }

    @Override
    public void addControlPoint() {
    }

    @Override
    public void computeEnabled() {
        Project proj = this.frame.getProject();
        Selection sel = proj == null ? null : proj.getSelection();
        boolean selEmpty = sel == null || sel.isEmpty();
        boolean canChange = proj != null && proj.getLogisimFile().contains(proj.getCurrentCircuit());
        boolean selectAvailable = false;
        for (Library lib : proj.getLogisimFile().getLibraries()) {
            if (!(lib instanceof BaseLibrary)) continue;
            selectAvailable = true;
            break;
        }
        this.setEnabled(LogisimMenuBar.CUT, !selEmpty && selectAvailable && canChange);
        this.setEnabled(LogisimMenuBar.COPY, !selEmpty && selectAvailable);
        this.setEnabled(LogisimMenuBar.PASTE, selectAvailable && canChange && !Clipboard.isEmpty());
        this.setEnabled(LogisimMenuBar.DELETE, !selEmpty && selectAvailable && canChange);
        this.setEnabled(LogisimMenuBar.DUPLICATE, !selEmpty && selectAvailable && canChange);
        this.setEnabled(LogisimMenuBar.SELECT_ALL, selectAvailable);
        this.setEnabled(LogisimMenuBar.RAISE, false);
        this.setEnabled(LogisimMenuBar.LOWER, false);
        this.setEnabled(LogisimMenuBar.RAISE_TOP, false);
        this.setEnabled(LogisimMenuBar.LOWER_BOTTOM, false);
        this.setEnabled(LogisimMenuBar.ADD_CONTROL, false);
        this.setEnabled(LogisimMenuBar.REMOVE_CONTROL, false);
    }

    @Override
    public void copy() {
        Project proj = this.frame.getProject();
        Selection sel = this.frame.getCanvas().getSelection();
        proj.doAction(SelectionActions.copy(sel));
    }

    @Override
    public void cut() {
        Project proj = this.frame.getProject();
        Selection sel = this.frame.getCanvas().getSelection();
        proj.doAction(SelectionActions.cut(sel));
    }

    @Override
    public void delete() {
        Project proj = this.frame.getProject();
        Selection sel = this.frame.getCanvas().getSelection();
        proj.doAction(SelectionActions.clear(sel));
    }

    @Override
    public void duplicate() {
        Project proj = this.frame.getProject();
        Selection sel = this.frame.getCanvas().getSelection();
        proj.doAction(SelectionActions.duplicate(sel));
    }

    @Override
    public void libraryChanged(LibraryEvent e) {
        int action = e.getAction();
        if (action == 3) {
            this.computeEnabled();
        } else if (action == 4) {
            this.computeEnabled();
        }
    }

    @Override
    public void lower() {
    }

    @Override
    public void lowerBottom() {
    }

    @Override
    public void paste() {
        Project proj = this.frame.getProject();
        Selection sel = this.frame.getCanvas().getSelection();
        this.selectSelectTool(proj);
        Action action = SelectionActions.pasteMaybe(proj, sel);
        if (action != null) {
            proj.doAction(action);
        }
    }

    @Override
    public void projectChanged(ProjectEvent e) {
        int action = e.getAction();
        if (action == 0) {
            this.computeEnabled();
        } else if (action == 1) {
            this.computeEnabled();
        } else if (action == 3) {
            this.computeEnabled();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("contents")) {
            this.computeEnabled();
        }
    }

    @Override
    public void raise() {
    }

    @Override
    public void raiseTop() {
    }

    @Override
    public void removeControlPoint() {
    }

    @Override
    public void selectAll() {
        Project proj = this.frame.getProject();
        Selection sel = this.frame.getCanvas().getSelection();
        this.selectSelectTool(proj);
        Circuit circ = proj.getCurrentCircuit();
        sel.addAll(circ.getWires());
        sel.addAll(circ.getNonWires());
        proj.repaintCanvas();
    }

    private void selectSelectTool(Project proj) {
        for (Library sub : proj.getLogisimFile().getLibraries()) {
            BaseLibrary baseLibrary;
            Tool tool;
            if (!(sub instanceof BaseLibrary) || (tool = (baseLibrary = (BaseLibrary)sub).getTool("Edit Tool")) == null) continue;
            proj.setTool(tool);
        }
    }
}

