/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.chrono.ChronoPanel;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.gui.log.LogMenuListener;
import com.cburch.logisim.gui.log.LogPanel;
import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.gui.log.OptionsPanel;
import com.cburch.logisim.gui.log.SelectionPanel;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.util.JDialogOk;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.WindowMenuItemManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogFrame
extends LFrame.SubWindowWithSimulation {
    private final LogMenuListener menuListener;
    private static final long serialVersionUID = 1L;
    private Simulator curSimulator = null;
    private Model curModel;
    private final Map<CircuitState, Model> modelMap = new HashMap<CircuitState, Model>();
    private final MyListener myListener = new MyListener();
    private final MyChangeListener myChangeListener = new MyChangeListener();
    private final WindowMenuManager windowManager;
    private final LogPanel[] panels;
    private final JTabbedPane tabbedPane;

    private static String computeTitle(Model data, Project proj) {
        String name = data == null ? "???" : data.getCircuitState().getCircuit().getName();
        return Strings.S.get("logFrameTitle", name, proj.getLogisimFile().getDisplayName());
    }

    public JButton makeSelectionButton() {
        JButton button = new JButton(Strings.S.get("addRemoveSignals"));
        button.addActionListener(event -> SelectionPanel.doDialog(this));
        return button;
    }

    public LogFrame(Project project) {
        super(project);
        this.windowManager = new WindowMenuManager(project);
        this.menuListener = new LogMenuListener(this.menubar);
        project.addProjectListener(this.myListener);
        project.addLibraryListener(this.myListener);
        this.setSimulator(project.getSimulator(), project.getCircuitState());
        this.panels = new LogPanel[]{new OptionsPanel(this), new ChronoPanel(this)};
        this.tabbedPane = new JTabbedPane();
        for (LogPanel panel : this.panels) {
            this.tabbedPane.addTab(panel.getTitle(), null, panel, panel.getToolTipText());
        }
        this.tabbedPane.addChangeListener(this.myChangeListener);
        this.myChangeListener.stateChanged(null);
        Container contents = this.getContentPane();
        int w = Math.max(550, project.getFrame().getWidth());
        int h = 300;
        this.tabbedPane.setPreferredSize(new Dimension(w, h));
        contents.add((Component)this.tabbedPane, "Center");
        LocaleManager.addLocaleListener(this.myListener);
        this.myListener.localeChanged();
        this.pack();
        h = this.getSize().height;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle r = project.getFrame().getBounds();
        int x = r.x;
        int y = r.y + r.height;
        if (y + h > d.height) {
            y = r.y >= h ? r.y - h : (r.y > d.height - h ? 0 : d.height - h);
        }
        this.setLocation(x, y);
        this.setMinimumSize(new Dimension(300, 200));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                LogFrame.this.myChangeListener.stateChanged(null);
            }
        });
    }

    @Override
    public LogisimMenuBar getLogisimMenuBar() {
        return this.menubar;
    }

    public LogMenuListener getMenuListener() {
        return this.menuListener;
    }

    public Model getModel() {
        return this.curModel;
    }

    LogPanel[] getPrefPanels() {
        return this.panels;
    }

    private boolean setSimulator(Simulator value, CircuitState state) {
        if (value == null == (this.curModel == null) && (value == null || value.getCircuitState() == this.curModel.getCircuitState())) {
            return false;
        }
        this.menubar.setCircuitState(value, state);
        if (this.curSimulator != null) {
            this.curSimulator.removeSimulatorListener(this.myListener);
        }
        if (this.curModel != null) {
            this.curModel.setSelected(false);
        }
        Model oldModel = this.curModel;
        Model data = null;
        if (value != null && (data = this.modelMap.get(value.getCircuitState())) == null) {
            data = new Model(value.getCircuitState());
            this.modelMap.put(data.getCircuitState(), data);
        }
        this.curSimulator = value;
        this.curModel = data;
        if (this.curSimulator != null) {
            this.curSimulator.addSimulatorListener(this.myListener);
        }
        if (this.curModel != null) {
            this.curModel.setSelected(true);
        }
        this.setTitle(LogFrame.computeTitle(this.curModel, this.project));
        if (this.panels != null) {
            for (LogPanel panel : this.panels) {
                panel.modelChanged(oldModel, this.curModel);
            }
        }
        return true;
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.windowManager.frameOpened(this);
        }
        super.setVisible(value);
    }

    @Override
    public void requestClose() {
        super.requestClose();
        this.dispose();
    }

    private class MyListener
    implements ProjectListener,
    LibraryListener,
    Simulator.ProgressListener,
    LocaleListener {
        private MyListener() {
        }

        @Override
        public void libraryChanged(LibraryEvent event) {
            int action = event.getAction();
            if (action == 6) {
                LogFrame.this.setTitle(LogFrame.computeTitle(LogFrame.this.curModel, LogFrame.this.project));
            }
        }

        @Override
        public void localeChanged() {
            LogFrame.this.setTitle(LogFrame.computeTitle(LogFrame.this.curModel, LogFrame.this.project));
            for (int i = 0; i < LogFrame.this.panels.length; ++i) {
                LogFrame.this.tabbedPane.setTitleAt(i, LogFrame.this.panels[i].getTitle());
                LogFrame.this.tabbedPane.setToolTipTextAt(i, LogFrame.this.panels[i].getToolTipText());
                LogFrame.this.panels[i].localeChanged();
            }
            LogFrame.this.windowManager.localeChanged();
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            int action = event.getAction();
            if (action == 4) {
                LogFrame.this.setSimulator(event.getProject().getSimulator(), event.getProject().getCircuitState());
            } else if (action == 0) {
                LogFrame.this.setTitle(LogFrame.computeTitle(LogFrame.this.curModel, LogFrame.this.project));
            }
        }

        @Override
        public void simulatorReset(Simulator.Event e) {
            LogFrame.this.curModel.simulatorReset();
        }

        @Override
        public void propagationCompleted(Simulator.Event e) {
            LogFrame.this.curModel.propagationCompleted(e.didTick(), e.didSingleStep(), e.didPropagate());
        }

        @Override
        public boolean wantsProgressEvents() {
            return LogFrame.this.curModel.isFine();
        }

        @Override
        public void propagationInProgress(Simulator.Event e) {
            LogFrame.this.curModel.propagationCompleted(false, true, false);
        }

        @Override
        public void simulatorStateChanged(Simulator.Event e) {
            if (LogFrame.this.setSimulator(LogFrame.this.project.getSimulator(), LogFrame.this.project.getCircuitState())) {
                return;
            }
            if (LogFrame.this.curModel != null) {
                LogFrame.this.curModel.checkForClocks();
            }
        }
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component selected = LogFrame.this.tabbedPane.getSelectedComponent();
            if (selected instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)selected;
                selected = scrollPane.getViewport().getView();
            }
            if (selected instanceof JPanel) {
                JPanel panel = (JPanel)selected;
                panel.requestFocus();
            }
            if (selected instanceof LogPanel) {
                LogPanel tab = (LogPanel)selected;
                LogFrame.this.menuListener.setEditHandler(tab.getEditHandler());
                LogFrame.this.menuListener.setPrintHandler(tab.getPrintHandler());
                tab.updateTab();
            }
        }
    }

    private class WindowMenuManager
    extends WindowMenuItemManager
    implements LocaleListener,
    ProjectListener,
    LibraryListener {
        final Project proj;

        WindowMenuManager(Project p) {
            super(Strings.S.get("logFrameMenuItem"), false);
            this.proj = p;
            this.proj.addProjectListener(this);
            this.proj.addLibraryListener(this);
        }

        @Override
        public JFrame getJFrame(boolean create, Component parent) {
            return LogFrame.this;
        }

        @Override
        public void libraryChanged(LibraryEvent event) {
            if (event.getAction() == 6) {
                this.localeChanged();
            }
        }

        @Override
        public void localeChanged() {
            String title = this.proj.getLogisimFile().getDisplayName();
            this.setText(Strings.S.get("logFrameMenuItem", title));
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            if (event.getAction() == 0) {
                this.localeChanged();
            }
        }
    }

    static class SelectionDialog
    extends JDialogOk {
        private static final long serialVersionUID = 1L;
        final SelectionPanel selPanel;

        SelectionDialog(LogFrame logFrame) {
            super("Signal Selection", false);
            this.selPanel = new SelectionPanel(logFrame);
            this.selPanel.localeChanged();
            this.getContentPane().add(this.selPanel);
            this.setMinimumSize(new Dimension(AppPreferences.getScaled(350), AppPreferences.getScaled(300)));
            this.setSize(AppPreferences.getScaled(400), AppPreferences.getScaled(400));
            this.pack();
            this.setVisible(true);
        }

        @Override
        public void cancelClicked() {
            this.okClicked();
        }

        @Override
        public void okClicked() {
        }
    }
}

