/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.generic;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.gui.generic.ProjectExplorerLibraryNode;
import com.cburch.logisim.gui.generic.ProjectExplorerModel;
import com.cburch.logisim.gui.generic.ProjectExplorerToolNode;
import com.cburch.logisim.gui.icons.TreeIcon;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.vhdl.base.VhdlContent;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class ProjectExplorer
extends JTree
implements LocaleListener {
    public static final Color MAGNIFYING_INTERIOR = new Color(200, 200, 255, 64);
    private static final long serialVersionUID = 1L;
    private final Project proj;
    private final MyListener myListener = new MyListener();
    private final MyCellRenderer renderer = new MyCellRenderer();
    private final DeleteAction deleteAction = new DeleteAction();
    private Listener listener = null;
    private Tool haloedTool = null;

    public ProjectExplorer(Project proj, boolean showMouseTools) {
        this.proj = proj;
        this.setModel(new ProjectExplorerModel(proj, this, showMouseTools));
        this.setRootVisible(true);
        this.addMouseListener(this.myListener);
        ToolTipManager.sharedInstance().registerComponent(this);
        MySelectionModel selector = new MySelectionModel();
        selector.setSelectionMode(1);
        this.setSelectionModel(selector);
        this.setCellRenderer(this.renderer);
        this.addTreeSelectionListener(this.myListener);
        InputMap imap = this.getInputMap(1);
        imap.put(KeyStroke.getKeyStroke(8, 0), this.deleteAction);
        imap.put(KeyStroke.getKeyStroke(127, 0), this.deleteAction);
        ActionMap amap = this.getActionMap();
        amap.put(this.deleteAction, this.deleteAction);
        proj.addProjectListener(this.myListener);
        AppPreferences.GATE_SHAPE.addPropertyChangeListener(this.myListener);
        LocaleManager.addLocaleListener(this);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        renderer.setClosedIcon(new TreeIcon(true));
        renderer.setOpenIcon(new TreeIcon(false));
    }

    public Tool getSelectedTool() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object last = path.getLastPathComponent();
        return last instanceof ProjectExplorerToolNode ? (Tool)((ProjectExplorerToolNode)last).getValue() : null;
    }

    public void updateStructure() {
        ProjectExplorerModel model = (ProjectExplorerModel)this.getModel();
        model.updateStructure();
    }

    @Override
    public void localeChanged() {
        ProjectExplorerModel model = (ProjectExplorerModel)this.getModel();
        model.fireStructureChanged();
    }

    public void setHaloedTool(Tool t) {
        this.haloedTool = t;
    }

    public void setListener(Listener value) {
        this.listener = value;
    }

    private class MyListener
    implements BaseMouseListenerContract,
    TreeSelectionListener,
    ProjectListener,
    PropertyChangeListener {
        private MyListener() {
        }

        private void checkForPopup(MouseEvent e) {
            JPopupMenu menu;
            TreePath path;
            if (e.isPopupTrigger() && (path = ProjectExplorer.this.getPathForLocation(e.getX(), e.getY())) != null && ProjectExplorer.this.listener != null && (menu = ProjectExplorer.this.listener.menuRequested(new Event(path))) != null) {
                menu.show(ProjectExplorer.this, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath path;
            if (e.getClickCount() == 2 && (path = ProjectExplorer.this.getPathForLocation(e.getX(), e.getY())) != null && ProjectExplorer.this.listener != null) {
                ProjectExplorer.this.listener.doubleClicked(new Event(path));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ProjectExplorer.this.requestFocus();
            this.checkForPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkForPopup(e);
        }

        void changedNode(Object o) {
            ProjectExplorerModel.Node<Tool> node;
            ProjectExplorerModel model = (ProjectExplorerModel)ProjectExplorer.this.getModel();
            if (model != null && o instanceof Tool && (node = model.findTool((Tool)o)) != null) {
                node.fireNodeChanged();
            }
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            int act = event.getAction();
            if (act == 1 || act == 2) {
                this.changedNode(event.getOldData());
                this.changedNode(event.getData());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (AppPreferences.GATE_SHAPE.isSource(event)) {
                ProjectExplorer.this.repaint();
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (ProjectExplorer.this.listener != null) {
                ProjectExplorer.this.listener.selectionChanged(new Event(path));
            }
        }
    }

    private class MyCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component ret = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Font plainFont = AppPreferences.getScaledFont(ret.getFont());
            Font boldFont = new Font(plainFont.getFontName(), 1, plainFont.getSize());
            ret.setFont(plainFont);
            if (ret instanceof JComponent) {
                JComponent comp = (JComponent)ret;
                comp.setToolTipText(null);
            }
            if (value instanceof ProjectExplorerToolNode) {
                ProjectExplorerToolNode toolNode = (ProjectExplorerToolNode)value;
                Tool tool = (Tool)toolNode.getValue();
                if (ret instanceof JLabel) {
                    JLabel label = (JLabel)ret;
                    boolean viewed = false;
                    if (tool instanceof AddTool && ProjectExplorer.this.proj != null && ProjectExplorer.this.proj.getFrame() != null) {
                        Circuit circ = null;
                        VhdlContent vhdl = null;
                        ComponentFactory fact = ((AddTool)tool).getFactory(false);
                        if (fact instanceof SubcircuitFactory) {
                            SubcircuitFactory sub = (SubcircuitFactory)fact;
                            circ = sub.getSubcircuit();
                        } else if (fact instanceof VhdlEntity) {
                            VhdlEntity vhdlEntity = (VhdlEntity)fact;
                            vhdl = vhdlEntity.getContent();
                        }
                        viewed = ProjectExplorer.this.proj.getFrame().getHdlEditorView() == null ? circ != null && circ == ProjectExplorer.this.proj.getCurrentCircuit() : vhdl != null && vhdl == ProjectExplorer.this.proj.getFrame().getHdlEditorView();
                    }
                    label.setFont(viewed ? boldFont : plainFont);
                    label.setText(tool.getDisplayName());
                    label.setIcon(new ToolIcon(tool));
                    label.setToolTipText(tool.getDescription());
                }
            } else if (value instanceof ProjectExplorerLibraryNode) {
                ProjectExplorerLibraryNode libNode = (ProjectExplorerLibraryNode)value;
                Library lib = (Library)libNode.getValue();
                if (ret instanceof JLabel) {
                    String baseName = lib.getDisplayName();
                    Object text = baseName;
                    if (lib.isDirty()) {
                        String DIRTY_MARKER_LOCAL = "*";
                        text = "*" + baseName;
                    }
                    ((JLabel)ret).setText((String)text);
                }
            }
            return ret;
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TreePath path = ProjectExplorer.this.getSelectionPath();
            if (ProjectExplorer.this.listener != null && path != null && path.getPathCount() == 2) {
                ProjectExplorer.this.listener.deleteRequested(new Event(path));
            }
            ProjectExplorer.this.requestFocus();
        }
    }

    public static interface Listener {
        default public void deleteRequested(Event event) {
        }

        default public void doubleClicked(Event event) {
        }

        public JPopupMenu menuRequested(Event var1);

        default public void moveRequested(Event event, AddTool dragged, AddTool target) {
        }

        default public void selectionChanged(Event event) {
        }
    }

    private static class MySelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = 1L;

        private MySelectionModel() {
        }

        @Override
        public void addSelectionPath(TreePath path) {
            if (this.isPathValid(path)) {
                super.addSelectionPath(path);
            }
        }

        @Override
        public void addSelectionPaths(TreePath[] paths) {
            if ((paths = this.getValidPaths(paths)) != null) {
                super.addSelectionPaths(paths);
            }
        }

        private TreePath[] getValidPaths(TreePath[] paths) {
            int count = 0;
            for (TreePath treePath : paths) {
                if (!this.isPathValid(treePath)) continue;
                ++count;
            }
            if (count == 0) {
                return null;
            }
            if (count == paths.length) {
                return paths;
            }
            TreePath[] ret = new TreePath[count];
            int j = 0;
            for (TreePath path : paths) {
                if (!this.isPathValid(path)) continue;
                ret[j++] = path;
            }
            return ret;
        }

        private boolean isPathValid(TreePath path) {
            return path == null || path.getPathCount() > 3 ? false : path.getLastPathComponent() instanceof ProjectExplorerToolNode;
        }

        @Override
        public void setSelectionPath(TreePath path) {
            if (this.isPathValid(path)) {
                this.clearSelection();
                super.setSelectionPath(path);
            }
        }

        @Override
        public void setSelectionPaths(TreePath[] paths) {
            if ((paths = this.getValidPaths(paths)) != null) {
                this.clearSelection();
                super.setSelectionPaths(paths);
            }
        }
    }

    public static class Event {
        private final TreePath path;

        public Event(TreePath p) {
            this.path = p;
        }

        public TreePath getTreePath() {
            return this.path;
        }

        public Object getTarget() {
            return this.path == null ? null : this.path.getLastPathComponent();
        }
    }

    private class ToolIcon
    implements Icon {
        final Tool tool;
        Circuit circ = null;
        VhdlContent vhdl = null;

        ToolIcon(Tool tool) {
            this.tool = tool;
            if (tool instanceof AddTool) {
                AddTool addTool = (AddTool)tool;
                ComponentFactory fact = addTool.getFactory(false);
                if (fact instanceof SubcircuitFactory) {
                    SubcircuitFactory sub = (SubcircuitFactory)fact;
                    this.circ = sub.getSubcircuit();
                } else if (fact instanceof VhdlEntity) {
                    VhdlEntity vhdlEntity = (VhdlEntity)fact;
                    this.vhdl = vhdlEntity.getContent();
                }
            }
        }

        @Override
        public int getIconHeight() {
            return AppPreferences.getScaled(20);
        }

        @Override
        public int getIconWidth() {
            return AppPreferences.getScaled(20);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean haloed;
            boolean viewed = ProjectExplorer.this.proj.getFrame().getHdlEditorView() == null ? this.circ != null && this.circ == ProjectExplorer.this.proj.getCurrentCircuit() : this.vhdl != null && this.vhdl == ProjectExplorer.this.proj.getFrame().getHdlEditorView();
            boolean bl = haloed = !viewed && this.tool == ProjectExplorer.this.haloedTool && AppPreferences.ATTRIBUTE_HALO.getBoolean();
            if (haloed) {
                Shape s = g.getClip();
                g.clipRect(x, y, AppPreferences.getScaled(20), AppPreferences.getScaled(20));
                g.setColor(Canvas.HALO_COLOR);
                g.setColor(Color.BLACK);
                g.setClip(s);
            }
            g.setColor(new Color(AppPreferences.COMPONENT_ICON_COLOR.get()));
            Graphics gfxIcon = g.create();
            ComponentDrawContext context = new ComponentDrawContext(ProjectExplorer.this, null, null, g, gfxIcon);
            this.tool.paintIcon(context, x + AppPreferences.getScaled(2), y + AppPreferences.getScaled(2));
            gfxIcon.dispose();
            if (viewed) {
                int tx = x + AppPreferences.getScaled(13);
                int ty = y + AppPreferences.getScaled(13);
                int[] xp = new int[]{tx - 1, x + AppPreferences.getScaled(18), x + AppPreferences.getScaled(20), tx + 1};
                int[] yp = new int[]{ty + 1, y + AppPreferences.getScaled(20), y + AppPreferences.getScaled(18), ty - 1};
                g.setColor(MAGNIFYING_INTERIOR);
                g.fillOval(x + AppPreferences.getScaled(5), y + AppPreferences.getScaled(5), AppPreferences.getScaled(10), AppPreferences.getScaled(10));
                g.setColor(new Color(139, 69, 19));
                g.drawOval(x + AppPreferences.getScaled(5), y + AppPreferences.getScaled(5), AppPreferences.getScaled(10), AppPreferences.getScaled(10));
                g.fillPolygon(xp, yp, xp.length);
            }
        }
    }
}

