/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.AppearancePort;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.io.Led;
import com.cburch.logisim.std.io.RgbLed;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;

public class LayoutThumbnail
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final int BORDER = 10;
    private CircuitState circuitState = null;
    private Collection<Instance> ports = null;
    private Collection<Instance> elts = null;

    public LayoutThumbnail(Dimension size) {
        this.setBackground(Color.LIGHT_GRAY);
        this.setPreferredSize(size);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (AppPreferences.AntiAliassing.getBoolean()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.circuitState != null) {
            int h;
            int w;
            int y;
            int x;
            Bounds b;
            int width;
            Circuit circuit = this.circuitState.getCircuit();
            Bounds bounds = circuit.getBounds(g);
            Dimension size = this.getSize();
            double scaleX = (double)(size.width - 20) / (double)bounds.getWidth();
            double scaleY = (double)(size.height - 20) / (double)bounds.getHeight();
            double scale = Math.min(1.0, Math.min(scaleX, scaleY));
            Graphics gfxCopy = g.create();
            int borderX = (int)(((double)size.width - (double)bounds.getWidth() * scale) / 2.0);
            int borderY = (int)(((double)size.height - (double)bounds.getHeight() * scale) / 2.0);
            gfxCopy.translate(borderX, borderY);
            if (scale != 1.0 && g instanceof Graphics2D) {
                ((Graphics2D)gfxCopy).scale(scale, scale);
            }
            gfxCopy.translate(-bounds.getX(), -bounds.getY());
            ComponentDrawContext context = new ComponentDrawContext(this, circuit, this.circuitState, g, gfxCopy);
            context.setShowState(false);
            context.setShowColor(false);
            circuit.draw(context, Collections.emptySet());
            if (CollectionUtil.isNotEmpty(this.ports)) {
                gfxCopy.setColor(AppearancePort.COLOR);
                width = Math.max(4, (int)(2.0 / scale + 0.5));
                GraphicsUtil.switchToWidth(gfxCopy, width);
                for (Instance port : this.ports) {
                    b = port.getBounds();
                    x = b.getX();
                    y = b.getY();
                    w = b.getWidth();
                    h = b.getHeight();
                    if (Pin.FACTORY.isInputPin(port)) {
                        gfxCopy.drawRect(x, y, w, h);
                        continue;
                    }
                    if (b.getWidth() > 25) {
                        gfxCopy.drawRoundRect(x, y, w, h, 4, 4);
                        continue;
                    }
                    gfxCopy.drawOval(x, y, w, h);
                }
            }
            if (CollectionUtil.isNotEmpty(this.elts)) {
                gfxCopy.setColor(DynamicElement.COLOR);
                width = Math.max(4, (int)(2.0 / scale + 0.5));
                GraphicsUtil.switchToWidth(gfxCopy, width);
                for (Instance elt : this.elts) {
                    b = elt.getBounds();
                    x = b.getX();
                    y = b.getY();
                    w = b.getWidth();
                    h = b.getHeight();
                    if (elt.getFactory() instanceof Led || elt.getFactory() instanceof RgbLed) {
                        gfxCopy.drawOval(x, y, w, h);
                        continue;
                    }
                    gfxCopy.drawRect(x, y, w, h);
                }
            }
            gfxCopy.dispose();
            g.setColor(Color.BLACK);
            GraphicsUtil.switchToWidth(g, 2);
            g.drawRect(0, 0, size.width - 2, size.height - 2);
        }
    }

    public void setCircuit(CircuitState circuitState, Collection<Instance> ports, Collection<Instance> elts) {
        this.circuitState = circuitState;
        this.ports = ports;
        this.elts = elts;
        this.repaint();
    }
}

