/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.fpga.data.FpgaCommanderListModel;
import com.cburch.logisim.fpga.designrulecheck.SimpleDrcContainer;
import com.cburch.logisim.fpga.gui.FpgaCommanderListWindow;
import com.cburch.logisim.fpga.gui.FpgaCommanderTextWindow;
import com.cburch.logisim.proj.Project;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

public class FpgaReportTabbedPane
extends JTabbedPane
implements BaseMouseListenerContract,
BaseWindowListenerContract {
    private static final long serialVersionUID = 1L;
    private static final int fontSize = 12;
    private static final GridLayout consolesLayout = new GridLayout(1, 1);
    private static final int infoTabIndex = 0;
    private static final int warningsTabIndex = 1;
    private static final int errorsTabIndex = 2;
    private static final int consoleTabIndex = 3;
    private final JTextArea textAreaInfo;
    private final JComponent panelInfos;
    private final ArrayList<String> infoMessages;
    private FpgaCommanderTextWindow infoWindow;
    private final JList<Object> warnings;
    private final JComponent panelWarnings;
    private final FpgaCommanderListModel warningsList;
    private final FpgaCommanderListWindow warningsWindow;
    private final JList<Object> errors;
    private final JComponent panelErrors;
    private final FpgaCommanderListModel errorsList;
    private final FpgaCommanderListWindow errorsWindow;
    private FpgaCommanderTextWindow consoleWindow;
    private final JTextArea textAreaConsole;
    private final JComponent panelConsole;
    private final ArrayList<String> consoleMessages;
    private boolean drcTraceActive = false;
    private SimpleDrcContainer activeDrcContainer;
    private final Project myProject;

    public FpgaReportTabbedPane(Project myProject) {
        this.myProject = myProject;
        this.infoMessages = new ArrayList();
        this.textAreaInfo = new JTextArea(10, 50);
        this.textAreaInfo.setForeground(Color.GRAY);
        this.textAreaInfo.setBackground(Color.BLACK);
        this.textAreaInfo.setFont(new Font("monospaced", 0, 12));
        this.textAreaInfo.setEditable(false);
        this.textAreaInfo.setText(null);
        DefaultCaret caret = (DefaultCaret)this.textAreaInfo.getCaret();
        caret.setUpdatePolicy(2);
        JScrollPane textMessages = new JScrollPane(this.textAreaInfo);
        textMessages.setVerticalScrollBarPolicy(20);
        textMessages.setHorizontalScrollBarPolicy(30);
        this.panelInfos = new JPanel();
        this.panelInfos.setLayout(consolesLayout);
        this.panelInfos.add(textMessages);
        this.panelInfos.setName("Infos (0)");
        this.add((Component)this.panelInfos, 0);
        this.warningsList = new FpgaCommanderListModel(true);
        this.warnings = new JList();
        this.warnings.setBackground(Color.BLACK);
        this.warnings.setForeground(Color.ORANGE);
        this.warnings.setSelectionBackground(Color.ORANGE);
        this.warnings.setSelectionForeground(Color.BLACK);
        this.warnings.setFont(new Font("monospaced", 0, 12));
        this.warnings.setModel(this.warningsList);
        this.warnings.setCellRenderer(this.warningsList.getMyRenderer());
        this.warnings.setSelectionMode(0);
        this.warnings.addMouseListener(this);
        JScrollPane textWarnings = new JScrollPane(this.warnings);
        textWarnings.setVerticalScrollBarPolicy(20);
        textWarnings.setHorizontalScrollBarPolicy(30);
        this.panelWarnings = new JPanel();
        this.panelWarnings.setLayout(consolesLayout);
        this.panelWarnings.add(textWarnings);
        this.panelWarnings.setName("Warnings (0)");
        this.add((Component)this.panelWarnings, 1);
        this.warningsWindow = new FpgaCommanderListWindow("FPGACommander: Warnings", Color.ORANGE, true, this.warningsList);
        this.warningsWindow.setSize(new Dimension(740, 400));
        this.warningsWindow.addWindowListener(this);
        this.warningsWindow.getListObject().addMouseListener(this);
        this.errorsList = new FpgaCommanderListModel(false);
        this.errors = new JList();
        this.errors.setBackground(Color.BLACK);
        this.errors.setForeground(Color.RED);
        this.errors.setSelectionBackground(Color.RED);
        this.errors.setSelectionForeground(Color.BLACK);
        this.errors.setFont(new Font("monospaced", 0, 12));
        this.errors.setModel(this.errorsList);
        this.errors.setCellRenderer(this.errorsList.getMyRenderer());
        this.errors.setSelectionMode(0);
        this.errors.addMouseListener(this);
        JScrollPane textErrors = new JScrollPane(this.errors);
        textErrors.setVerticalScrollBarPolicy(20);
        textErrors.setHorizontalScrollBarPolicy(30);
        this.panelErrors = new JPanel();
        this.panelErrors.setLayout(consolesLayout);
        this.panelErrors.add(textErrors);
        this.panelErrors.setName("Errors (0)");
        this.add((Component)this.panelErrors, 2);
        this.errorsWindow = new FpgaCommanderListWindow("FPGACommander: Errors", Color.RED, true, this.errorsList);
        this.errorsWindow.addWindowListener(this);
        this.errorsWindow.setSize(new Dimension(740, 400));
        this.errorsWindow.getListObject().addMouseListener(this);
        this.consoleMessages = new ArrayList();
        this.textAreaConsole = new JTextArea(10, 50);
        this.textAreaConsole.setForeground(Color.LIGHT_GRAY);
        this.textAreaConsole.setBackground(Color.BLACK);
        this.textAreaConsole.setFont(new Font("monospaced", 0, 12));
        this.textAreaConsole.setEditable(false);
        this.textAreaConsole.setText(null);
        caret = (DefaultCaret)this.textAreaConsole.getCaret();
        caret.setUpdatePolicy(2);
        JScrollPane textConsole = new JScrollPane(this.textAreaConsole);
        textConsole.setVerticalScrollBarPolicy(20);
        textConsole.setHorizontalScrollBarPolicy(30);
        this.panelConsole = new JPanel();
        this.panelConsole.setLayout(consolesLayout);
        this.panelConsole.add(textConsole);
        this.panelConsole.setName("Console");
        this.add((Component)this.panelConsole, 3);
        this.addMouseListener(this);
        this.setPreferredSize(new Dimension(700, 240));
    }

    private String getAllignmentSpaces(int index) {
        if (index < 9) {
            return "    " + index;
        }
        if (index < 99) {
            return "   " + index;
        }
        if (index < 999) {
            return "  " + index;
        }
        if (index < 9999) {
            return " " + index;
        }
        return Integer.toString(index);
    }

    public void addInfo(Object message) {
        int nrOfInfos = this.infoMessages.size() + 1;
        this.infoMessages.add(this.getAllignmentSpaces(nrOfInfos) + "> " + message.toString() + "\n");
        if (this.infoWindow != null && this.infoWindow.isVisible()) {
            this.updateInfoWindow();
            return;
        }
        this.updateInfoTab();
    }

    private void updateInfoWindow() {
        StringBuilder line = new StringBuilder();
        for (String mes : this.infoMessages) {
            line.append(mes);
        }
        this.infoWindow.set(line.toString(), this.infoMessages.size());
    }

    private void updateInfoTab() {
        StringBuilder line = new StringBuilder();
        for (String mes : this.infoMessages) {
            line.append(mes);
        }
        this.textAreaInfo.setText(line.toString());
        int idx = this.indexOfComponent(this.panelInfos);
        if (idx >= 0) {
            this.setSelectedIndex(idx);
            this.setTitleAt(idx, "Infos (" + this.infoMessages.size() + ")");
            this.panelInfos.revalidate();
            this.panelInfos.repaint();
        }
    }

    public void addWarning(Object message) {
        this.warningsList.add(message);
        int idx = this.indexOfComponent(this.panelWarnings);
        if (idx >= 0) {
            this.setSelectedIndex(idx);
            this.setTitleAt(idx, "Warnings (" + this.warningsList.getCountNr() + ")");
            this.panelWarnings.revalidate();
            this.panelWarnings.repaint();
        }
    }

    public void addErrors(Object message) {
        this.errorsList.add(message);
        int idx = this.indexOfComponent(this.panelErrors);
        if (idx >= 0) {
            this.setSelectedIndex(idx);
            this.setTitleAt(idx, "Errors (" + this.errorsList.getCountNr() + ")");
            this.panelErrors.revalidate();
            this.panelErrors.repaint();
        }
    }

    public void addConsole(String Message) {
        this.consoleMessages.add(Message + "\n");
        if (this.consoleWindow != null && this.consoleWindow.isVisible()) {
            this.updateConsoleWindow();
        }
        this.updateConsoleTab();
    }

    private void updateConsoleWindow() {
        StringBuilder lines = new StringBuilder();
        for (String mes : this.consoleMessages) {
            lines.append(mes);
        }
        this.consoleWindow.set(lines.toString(), 0);
    }

    private void updateConsoleTab() {
        StringBuilder lines = new StringBuilder();
        for (String mes : this.consoleMessages) {
            lines.append(mes);
        }
        this.textAreaConsole.setText(lines.toString());
        int idx = this.indexOfComponent(this.panelConsole);
        if (idx >= 0) {
            this.setSelectedIndex(idx);
            this.panelConsole.revalidate();
            this.panelConsole.repaint();
        }
    }

    public void clearConsole() {
        this.consoleMessages.clear();
    }

    public void clearDrcTrace() {
        if (this.drcTraceActive) {
            this.activeDrcContainer.clearMarks();
            this.drcTraceActive = false;
            if (this.myProject != null) {
                this.myProject.repaintCanvas();
            }
        }
    }

    public void clearAllMessages() {
        this.clearDrcTrace();
        this.textAreaInfo.setText(null);
        this.infoMessages.clear();
        int idx = this.indexOfComponent(this.panelInfos);
        if (idx >= 0) {
            this.setTitleAt(idx, "Infos (" + this.infoMessages.size() + ")");
            this.setSelectedIndex(idx);
        }
        this.warningsList.clear();
        idx = this.indexOfComponent(this.panelWarnings);
        if (idx >= 0) {
            this.setTitleAt(idx, "Warnings (" + this.warningsList.getCountNr() + ")");
        }
        this.errorsList.clear();
        idx = this.indexOfComponent(this.panelErrors);
        if (idx >= 0) {
            this.setTitleAt(idx, "Errors (" + this.errorsList.getCountNr() + ")");
        }
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(rect);
        } else {
            this.repaint(rect);
        }
    }

    public void closeOpenWindows() {
        if (this.infoWindow != null && this.infoWindow.isVisible()) {
            this.infoWindow.setVisible(false);
            this.add((Component)this.panelInfos, 0);
            this.updateInfoTab();
        }
        if (this.warningsWindow != null && this.warningsWindow.isVisible()) {
            this.warningsWindow.setVisible(false);
            this.add((Component)this.panelWarnings, 1);
            this.setTitleAt(1, "Warnings (" + this.warningsList.getCountNr() + ")");
            this.clearDrcTrace();
        }
        if (this.errorsWindow != null && this.errorsWindow.isVisible()) {
            this.errorsWindow.setVisible(false);
            this.add((Component)this.panelErrors, 2);
            this.setTitleAt(2, "Errors (" + this.errorsList.getCountNr() + ")");
            this.clearDrcTrace();
        }
        if (this.consoleWindow != null && this.consoleWindow.isVisible()) {
            this.consoleWindow.setVisible(false);
            this.add((Component)this.panelConsole, 3);
            this.updateConsoleTab();
        }
    }

    private void generateDrcTrace(SimpleDrcContainer dc) {
        this.drcTraceActive = true;
        this.activeDrcContainer = dc;
        if (dc.hasCircuit() && this.myProject != null && !this.myProject.getCurrentCircuit().equals(dc.getCircuit())) {
            this.myProject.setCurrentCircuit(dc.getCircuit());
        }
        dc.markComponents();
        if (this.myProject != null) {
            this.myProject.repaintCanvas();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() > 1 && e.getSource().equals(this) && this.getComponentCount() > 0) {
            if (this.getSelectedComponent().equals(this.panelInfos)) {
                if (this.infoWindow != null) {
                    this.infoWindow.setVisible(true);
                    this.updateInfoWindow();
                } else {
                    this.infoWindow = new FpgaCommanderTextWindow("FPGACommander: Infos", Color.GRAY, true);
                    this.infoWindow.setVisible(true);
                    this.updateInfoWindow();
                    this.infoWindow.addWindowListener(this);
                }
                this.remove(this.getSelectedIndex());
            } else if (this.getSelectedComponent().equals(this.panelConsole)) {
                if (this.consoleWindow != null) {
                    this.consoleWindow.setVisible(true);
                    this.updateConsoleWindow();
                } else {
                    this.consoleWindow = new FpgaCommanderTextWindow("FPGACommander: Console", Color.LIGHT_GRAY, false);
                    this.consoleWindow.setVisible(true);
                    this.updateConsoleWindow();
                    this.consoleWindow.addWindowListener(this);
                }
                this.remove(this.getSelectedIndex());
            } else if (this.getSelectedComponent().equals(this.panelWarnings)) {
                if (this.warningsWindow != null) {
                    this.warningsWindow.setVisible(true);
                    this.remove(this.getSelectedIndex());
                }
            } else if (this.getSelectedComponent().equals(this.panelErrors) && this.errorsWindow != null) {
                this.errorsWindow.setVisible(true);
                this.remove(this.getSelectedIndex());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean sourceIsErrorsWindow;
        boolean sourceIsWarningsWindow = this.warningsWindow != null && e.getSource().equals(this.warningsWindow.getListObject());
        boolean bl = sourceIsErrorsWindow = this.errorsWindow != null && e.getSource().equals(this.errorsWindow.getListObject());
        if (e.getSource().equals(this.errors) || sourceIsErrorsWindow) {
            this.clearDrcTrace();
            int idx = -1;
            if (e.getSource().equals(this.errors)) {
                idx = this.errors.getSelectedIndex();
            } else if (sourceIsErrorsWindow) {
                idx = this.errorsWindow.getListObject().getSelectedIndex();
            }
            if (idx >= 0 && this.errorsList.getElementAt(idx) instanceof SimpleDrcContainer) {
                this.generateDrcTrace((SimpleDrcContainer)this.errorsList.getElementAt(idx));
            }
        } else if (e.getSource().equals(this.warnings) || sourceIsWarningsWindow) {
            this.clearDrcTrace();
            int idx = -1;
            if (e.getSource().equals(this.warnings)) {
                idx = this.warnings.getSelectedIndex();
            } else if (sourceIsWarningsWindow) {
                idx = this.warningsWindow.getListObject().getSelectedIndex();
            }
            if (idx >= 0 && this.warningsList.getElementAt(idx) instanceof SimpleDrcContainer) {
                this.generateDrcTrace((SimpleDrcContainer)this.warningsList.getElementAt(idx));
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        HashSet<Component> comps;
        int idx;
        if (e.getSource().equals(this.infoWindow)) {
            this.add((Component)this.panelInfos, 0);
            this.updateInfoTab();
        }
        if (e.getSource().equals(this.consoleWindow)) {
            this.add((Component)this.panelConsole, this.getComponentCount());
            this.updateConsoleTab();
        }
        if (e.getSource().equals(this.warningsWindow)) {
            idx = this.getComponentCount();
            comps = new HashSet<Component>(Arrays.asList(this.getComponents()));
            if (comps.contains(this.panelConsole)) {
                idx = this.indexOfComponent(this.panelConsole);
            }
            if (comps.contains(this.panelErrors)) {
                idx = this.indexOfComponent(this.panelErrors);
            }
            this.add((Component)this.panelWarnings, idx);
            this.setTitleAt(idx, "Warnings (" + this.warningsList.getCountNr() + ")");
            this.setSelectedIndex(idx);
            this.clearDrcTrace();
        }
        if (e.getSource().equals(this.errorsWindow)) {
            idx = this.getComponentCount();
            comps = new HashSet<Component>(Arrays.asList(this.getComponents()));
            if (comps.contains(this.panelConsole)) {
                idx = this.indexOfComponent(this.panelConsole);
            }
            this.add((Component)this.panelErrors, idx);
            this.setTitleAt(idx, "Errors (" + this.errorsList.getCountNr() + ")");
            this.setSelectedIndex(idx);
            this.clearDrcTrace();
        }
    }
}

