/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.gui;

import com.cburch.contracts.BaseKeyListenerContract;
import com.cburch.contracts.BaseWindowListenerContract;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

public class FpgaCommanderTextWindow
extends JFrame
implements BaseKeyListenerContract,
BaseWindowListenerContract {
    private int FontSize;
    private final String Title;
    private final JTextArea textArea;
    private boolean IsActive = false;
    private final boolean count;

    public FpgaCommanderTextWindow(String Title2, Color fg, boolean count) {
        super((String)(count ? Title2 + " (0)" : Title2));
        this.Title = Title2;
        this.setResizable(true);
        this.setAlwaysOnTop(false);
        this.setDefaultCloseOperation(1);
        Color bg = Color.black;
        this.textArea = new JTextArea(25, 80);
        ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(2);
        this.textArea.setForeground(fg);
        this.textArea.setBackground(bg);
        this.textArea.setFont(new Font("monospaced", 0, this.FontSize));
        this.textArea.setEditable(false);
        this.clear();
        JScrollPane textMessages = new JScrollPane(this.textArea);
        textMessages.setVerticalScrollBarPolicy(20);
        textMessages.setHorizontalScrollBarPolicy(30);
        this.add(textMessages);
        this.setLocationRelativeTo(null);
        this.textArea.addKeyListener(this);
        this.pack();
        this.addWindowListener(this);
        this.count = count;
        this.FontSize = textMessages.getFont().getSize();
    }

    public boolean isActivated() {
        return this.IsActive;
    }

    public void clear() {
        this.textArea.setText(null);
        if (this.count) {
            this.setTitle(this.Title + " (0)");
        }
    }

    public void set(String line, int LineCount) {
        this.textArea.setText(line);
        if (this.count) {
            this.setTitle(this.Title + " (" + LineCount + ")");
        }
        Rectangle rect = this.textArea.getBounds();
        rect.x = 0;
        rect.y = 0;
        if (EventQueue.isDispatchThread()) {
            this.textArea.paintImmediately(rect);
        } else {
            this.textArea.repaint(rect);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 61: 
            case 107: 
            case 521: {
                ++this.FontSize;
                this.textArea.setFont(this.textArea.getFont().deriveFont((float)this.FontSize));
                Rectangle rect = this.textArea.getBounds();
                rect.x = 0;
                rect.y = 0;
                this.textArea.paintImmediately(rect);
                break;
            }
            case 45: 
            case 109: {
                if (this.FontSize <= 8) break;
                --this.FontSize;
                this.textArea.setFont(this.textArea.getFont().deriveFont((float)this.FontSize));
                Rectangle rect = this.textArea.getBounds();
                rect.x = 0;
                rect.y = 0;
                this.textArea.paintImmediately(rect);
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.IsActive = false;
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.IsActive = true;
    }
}

