/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.comp;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.WireSet;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class ComponentDrawContext {
    private static final int PIN_OFFS = 2;
    private static final int PIN_RAD = 4;
    private final java.awt.Component dest;
    private final Circuit circuit;
    private final CircuitState circuitState;
    private final Graphics base;
    private Graphics g;
    private boolean showState;
    private boolean showColor;
    private final boolean printView;
    private WireSet highlightedWires;
    private final InstancePainter instancePainter;

    public ComponentDrawContext(java.awt.Component dest, Circuit circuit, CircuitState circuitState, Graphics base, Graphics g) {
        this(dest, circuit, circuitState, base, g, false);
    }

    public ComponentDrawContext(java.awt.Component dest, Circuit circuit, CircuitState circuitState, Graphics base, Graphics g, boolean printView) {
        this.dest = dest;
        this.circuit = circuit;
        this.circuitState = circuitState;
        this.base = base;
        this.g = g;
        this.showState = true;
        this.showColor = true;
        this.printView = printView;
        this.highlightedWires = WireSet.EMPTY;
        this.instancePainter = new InstancePainter(this, null);
    }

    public void drawBounds(Component comp) {
        GraphicsUtil.switchToWidth(this.g, 2);
        Bounds bds = comp.getBounds();
        this.g.drawRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        GraphicsUtil.switchToWidth(this.g, 1);
    }

    public void drawClock(Component comp, int i, Direction dir) {
        GraphicsUtil.switchToWidth(this.g, 2);
        EndData e = comp.getEnd(i);
        Location pt = e.getLocation();
        int x = pt.getX();
        int y = pt.getY();
        int CLK_SZ = 4;
        int CLK_SZD = 3;
        if (dir == Direction.NORTH) {
            this.g.drawLine(x - 3, y - 1, x, y - 4);
            this.g.drawLine(x + 3, y - 1, x, y - 4);
        } else if (dir == Direction.SOUTH) {
            this.g.drawLine(x - 3, y + 1, x, y + 4);
            this.g.drawLine(x + 3, y + 1, x, y + 4);
        } else if (dir == Direction.EAST) {
            this.g.drawLine(x + 1, y - 3, x + 4, y);
            this.g.drawLine(x + 1, y + 3, x + 4, y);
        } else if (dir == Direction.WEST) {
            this.g.drawLine(x - 1, y - 3, x - 4, y);
            this.g.drawLine(x - 1, y + 3, x - 4, y);
        }
        GraphicsUtil.switchToWidth(this.g, 1);
    }

    public void drawClockSymbol(Component comp, int xpos, int ypos) {
        GraphicsUtil.switchToWidth(this.g, 2);
        int[] xcoords = new int[]{xpos + 1, xpos + 8, xpos + 1};
        int[] ycoords = new int[]{ypos - 4, ypos, ypos + 4};
        this.g.drawPolyline(xcoords, ycoords, 3);
        GraphicsUtil.switchToWidth(this.g, 1);
    }

    public void drawDongle(int x, int y) {
        GraphicsUtil.switchToWidth(this.g, 2);
        this.g.drawOval(x - 4, y - 4, 9, 9);
    }

    public void drawHandle(int x, int y) {
        this.g.setColor(Color.white);
        this.g.fillRect(x - 3, y - 3, 7, 7);
        this.g.setColor(Color.black);
        this.g.drawRect(x - 3, y - 3, 7, 7);
    }

    public void drawHandle(Location loc) {
        this.drawHandle(loc.getX(), loc.getY());
    }

    public void drawHandles(Component comp) {
        Bounds b = comp.getBounds(this.g);
        int left = b.getX();
        int right = left + b.getWidth();
        int top = b.getY();
        int bot = top + b.getHeight();
        this.drawHandle(right, top);
        this.drawHandle(left, bot);
        this.drawHandle(right, bot);
        this.drawHandle(left, top);
    }

    protected void drawPinMarker(int x, int y) {
        String appearance = AppPreferences.PinAppearance.get();
        int radius = 4;
        int offset = 2;
        switch (appearance) {
            case "dot-medium": {
                radius = 6;
                offset = 3;
                break;
            }
            case "dot-big": {
                radius = 8;
                offset = 4;
                break;
            }
            case "dot-bigger": {
                radius = 10;
                offset = 5;
            }
        }
        this.g.fillOval(x - offset, y - offset, radius, radius);
    }

    public void drawPin(Component comp, int i) {
        EndData e = comp.getEnd(i);
        Location pt = e.getLocation();
        Color curColor = this.g.getColor();
        this.g.setColor(this.getShowState() ? this.getCircuitState().getValue(pt).getColor() : new Color(AppPreferences.COMPONENT_COLOR.get()));
        this.drawPinMarker(pt.getX(), pt.getY());
        this.g.setColor(curColor);
    }

    public void drawPin(Component comp, int i, String label, Direction dir) {
        Color curColor = this.g.getColor();
        if (i < 0 || i >= comp.getEnds().size()) {
            return;
        }
        EndData e = comp.getEnd(i);
        Location pt = e.getLocation();
        int x = pt.getX();
        int y = pt.getY();
        if (this.getShowState()) {
            this.g.setColor(this.getCircuitState().getValue(pt).getColor());
        } else {
            this.g.setColor(Color.BLACK);
        }
        this.drawPinMarker(x, y);
        this.g.setColor(curColor);
        if (dir == Direction.EAST) {
            GraphicsUtil.drawText(this.g, label, x + 3, y, -1, 0);
        } else if (dir == Direction.WEST) {
            GraphicsUtil.drawText(this.g, label, x - 3, y, 1, 0);
        } else if (dir == Direction.SOUTH) {
            GraphicsUtil.drawText(this.g, label, x, y - 3, 0, 1);
        } else if (dir == Direction.NORTH) {
            GraphicsUtil.drawText(this.g, label, x, y + 3, 0, -1);
        }
    }

    public void drawPins(Component comp) {
        Color curColor = this.g.getColor();
        for (EndData e : comp.getEnds()) {
            Location pt = e.getLocation();
            if (this.getShowState()) {
                this.g.setColor(this.getCircuitState().getValue(pt).getColor());
            } else {
                this.g.setColor(Color.BLACK);
            }
            this.drawPinMarker(pt.getX(), pt.getY());
        }
        this.g.setColor(curColor);
    }

    public void drawRectangle(Component comp) {
        this.drawRectangle(comp, "");
    }

    public void drawRectangle(Component comp, String label) {
        Bounds bds = comp.getBounds(this.g);
        this.drawRectangle(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight(), label);
    }

    public void drawRectangle(ComponentFactory source, int x, int y, AttributeSet attrs, String label) {
        Bounds bds = source.getOffsetBounds(attrs);
        this.drawRectangle(source, x + bds.getX(), y + bds.getY(), bds.getWidth(), bds.getHeight(), label);
    }

    public void drawRectangle(ComponentFactory source, int x, int y, int width, int height, String label) {
        GraphicsUtil.switchToWidth(this.g, 2);
        this.g.drawRect(x + 1, y + 1, width - 1, height - 1);
        if (label != null && !label.equals("")) {
            FontMetrics fm = this.base.getFontMetrics(this.g.getFont());
            int lwid = fm.stringWidth(label);
            if (height > 20) {
                this.g.drawString(label, x + (width - lwid) / 2, y + 2 + fm.getAscent());
            } else {
                this.g.drawString(label, x + (width - lwid) / 2, y + (height + fm.getAscent()) / 2 - 1);
            }
        }
    }

    public void drawRectangle(int x, int y, int width, int height, String label) {
        GraphicsUtil.switchToWidth(this.g, 2);
        this.g.drawRect(x, y, width, height);
        if (label != null && !label.equals("")) {
            FontMetrics fm = this.base.getFontMetrics(this.g.getFont());
            int lwid = fm.stringWidth(label);
            if (height > 20) {
                this.g.drawString(label, x + (width - lwid) / 2, y + 2 + fm.getAscent());
            } else {
                this.g.drawString(label, x + (width - lwid) / 2, y + (height + fm.getAscent()) / 2 - 1);
            }
        }
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public CircuitState getCircuitState() {
        return this.circuitState;
    }

    public java.awt.Component getDestination() {
        return this.dest;
    }

    public Object getGateShape() {
        return AppPreferences.GATE_SHAPE.get();
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public WireSet getHighlightedWires() {
        return this.highlightedWires;
    }

    public InstancePainter getInstancePainter() {
        return this.instancePainter;
    }

    public boolean getShowState() {
        return !this.printView && this.showState;
    }

    public boolean isPrintView() {
        return this.printView;
    }

    public void setGraphics(Graphics g) {
        this.g = g;
    }

    public void setHighlightedWires(WireSet value) {
        this.highlightedWires = value == null ? WireSet.EMPTY : value;
    }

    public void setShowColor(boolean value) {
        this.showColor = value;
    }

    public void setShowState(boolean value) {
        this.showState = value;
    }

    public boolean shouldDrawColor() {
        return !this.printView && this.showColor;
    }

    public void drawRoundBounds(Component comp, Bounds bds, Color color) {
        GraphicsUtil.switchToWidth(this.g, 2);
        if (color != null && !color.equals(Color.WHITE)) {
            this.g.setColor(color);
            this.g.fillRoundRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight(), 10, 10);
        }
        this.g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        this.g.drawRoundRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight(), 10, 10);
        GraphicsUtil.switchToWidth(this.g, 1);
    }

    public void drawRoundBounds(Component comp, Color color) {
        this.drawRoundBounds(comp, comp.getBounds(), color);
    }
}

