/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.file.TruthtableCsvFile;
import com.cburch.logisim.analyze.file.TruthtableTextFile;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.util.JFileChoosers;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class ImportTableButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private final JFrame parent;
    private final AnalyzerModel model;
    private File lastFile = null;

    ImportTableButton(JFrame parent, AnalyzerModel model) {
        this.parent = parent;
        this.model = model;
        this.addActionListener(event -> this.doLoad());
    }

    void localeChanged() {
        this.setText(Strings.S.get("importTableButton"));
    }

    void doLoad() {
        if (this.lastFile == null) {
            Circuit c = this.model.getCurrentCircuit();
            this.lastFile = c != null ? new File(c.getName() + ".txt") : new File("truthtable.txt");
        }
        JFileChooser chooser = JFileChoosers.createSelected(this.lastFile);
        chooser.setDialogTitle(Strings.S.get("openButton"));
        chooser.addChoosableFileFilter(TruthtableTextFile.FILE_FILTER);
        chooser.addChoosableFileFilter(TruthtableCsvFile.FILE_FILTER);
        chooser.setFileFilter(TruthtableTextFile.FILE_FILTER);
        int choice = chooser.showOpenDialog(this.parent);
        if (choice == 0) {
            File file = chooser.getSelectedFile();
            if (file.isDirectory()) {
                OptionPane.showMessageDialog(this.parent, Strings.S.get("notFileMessage", file.getName()), Strings.S.get("openErrorTitle"), 0);
                return;
            }
            if (!file.exists() || !file.canRead()) {
                OptionPane.showMessageDialog(this.parent, Strings.S.get("cantReadMessage", file.getName()), Strings.S.get("openErrorTitle"), 0);
                return;
            }
            try {
                String fileName = file.getName();
                int idx = fileName.lastIndexOf(".");
                String ext = fileName.substring(idx + 1);
                if (ext.equals("txt")) {
                    TruthtableTextFile.doLoad(file, this.model, this.parent);
                } else if (ext.equals("csv")) {
                    TruthtableCsvFile.doLoad(file, this.model, this.parent);
                } else {
                    OptionPane.showMessageDialog(this.parent, Strings.S.get("DoNotKnowHowto", fileName), Strings.S.get("openErrorTitle"), 0);
                    return;
                }
                this.lastFile = file;
            }
            catch (IOException e) {
                OptionPane.showMessageDialog(this.parent, e.getMessage(), Strings.S.get("openErrorTitle"), 0);
            }
        }
    }
}

