/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.toolbar;

import com.cburch.draw.toolbar.ToolbarButton;
import com.cburch.draw.toolbar.ToolbarItem;
import com.cburch.draw.toolbar.ToolbarModel;
import com.cburch.draw.toolbar.ToolbarModelEvent;
import com.cburch.draw.toolbar.ToolbarModelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class Toolbar
extends JPanel {
    public static final Object VERTICAL = new Object();
    public static final Object HORIZONTAL = new Object();
    private static final long serialVersionUID = 1L;
    private final JPanel subpanel = new JPanel();
    private final MyListener myListener;
    private ToolbarModel model;
    private Object orientation;
    private ToolbarButton curPressed;

    public Toolbar(ToolbarModel model) {
        super(new BorderLayout());
        this.model = model;
        this.orientation = HORIZONTAL;
        this.myListener = new MyListener();
        this.curPressed = null;
        this.add((Component)new JPanel(), "Center");
        this.setOrientation(HORIZONTAL);
        this.computeContents();
        if (model != null) {
            model.addToolbarModelListener(this.myListener);
        }
    }

    private void computeContents() {
        this.subpanel.removeAll();
        ToolbarModel m = this.model;
        if (m != null) {
            for (ToolbarItem item : m.getItems()) {
                this.subpanel.add(new ToolbarButton(this, item));
            }
            this.subpanel.add(Box.createGlue());
        }
        this.revalidate();
    }

    Object getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Object value) {
        String position;
        int axis;
        if (value.equals(HORIZONTAL)) {
            axis = 0;
            position = "Before";
        } else if (value.equals(VERTICAL)) {
            axis = 1;
            position = "North";
        } else {
            throw new IllegalArgumentException();
        }
        this.remove(this.subpanel);
        this.subpanel.setLayout(new BoxLayout(this.subpanel, axis));
        this.add((Component)this.subpanel, position);
        this.orientation = value;
    }

    ToolbarButton getPressed() {
        return this.curPressed;
    }

    void setPressed(ToolbarButton value) {
        ToolbarButton oldValue = this.curPressed;
        if (oldValue != value) {
            this.curPressed = value;
            if (oldValue != null) {
                oldValue.repaint();
            }
            if (value != null) {
                value.repaint();
            }
        }
    }

    public ToolbarModel getToolbarModel() {
        return this.model;
    }

    public void setToolbarModel(ToolbarModel value) {
        ToolbarModel oldValue = this.model;
        if (value != oldValue) {
            if (oldValue != null) {
                oldValue.removeToolbarModelListener(this.myListener);
            }
            if (value != null) {
                value.addToolbarModelListener(this.myListener);
            }
            this.model = value;
            this.computeContents();
        }
    }

    private class MyListener
    implements ToolbarModelListener {
        private MyListener() {
        }

        @Override
        public void toolbarAppearanceChanged(ToolbarModelEvent event) {
            Toolbar.this.repaint();
        }

        @Override
        public void toolbarContentsChanged(ToolbarModelEvent event) {
            Toolbar.this.computeContents();
        }
    }
}

