/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.Strings;
import com.cburch.draw.model.AbstractCanvasObject;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.SvgCreator;
import com.cburch.draw.util.EditableLabel;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Text
extends AbstractCanvasObject {
    private EditableLabel label;

    private Text(int x, int y, int halign, int valign, String text, Font font, Color color) {
        this.label = new EditableLabel(x, y, text, font);
        this.label.setColor(color);
        this.label.setHorizontalAlignment(halign);
        this.label.setVerticalAlignment(valign);
    }

    public Text(int x, int y, String text) {
        this(x, y, 2, 10, text, DrawAttr.DEFAULT_FONT, Color.BLACK);
    }

    @Override
    public Text clone() {
        Text ret = (Text)super.clone();
        ret.label = this.label.clone();
        return ret;
    }

    @Override
    public boolean contains(Location loc, boolean assumeFilled) {
        return this.label.contains(loc.getX(), loc.getY());
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.ATTRS_TEXT;
    }

    @Override
    public Bounds getBounds() {
        return this.label.getBounds();
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("shapeText");
    }

    public List<Handle> getHandles() {
        Bounds bds = this.getBounds();
        int x = bds.getX();
        int y = bds.getY();
        int w = bds.getWidth();
        int h = bds.getHeight();
        return UnmodifiableList.create(new Handle[]{new Handle(this, x, y), new Handle(this, x + w, y), new Handle(this, x + w, y + h), new Handle(this, x, y + h)});
    }

    @Override
    public List<Handle> getHandles(HandleGesture gesture) {
        return this.getHandles();
    }

    public EditableLabel getLabel() {
        return this.label;
    }

    public Location getLocation() {
        return Location.create(this.label.getX(), this.label.getY(), false);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String value) {
        this.label.setText(value);
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == DrawAttr.FONT) {
            return (V)this.label.getFont();
        }
        if (attr == DrawAttr.FILL_COLOR) {
            return (V)this.label.getColor();
        }
        if (attr == DrawAttr.HALIGNMENT) {
            int halign = this.label.getHorizontalAlignment();
            AttributeOption h = halign == 2 ? DrawAttr.HALIGN_LEFT : (halign == 4 ? DrawAttr.HALIGN_RIGHT : DrawAttr.HALIGN_CENTER);
            return (V)h;
        }
        if (attr == DrawAttr.VALIGNMENT) {
            int valign = this.label.getVerticalAlignment();
            AttributeOption v = valign == 8 ? DrawAttr.VALIGN_TOP : (valign == 11 ? DrawAttr.VALIGN_BOTTOM : (valign == 10 ? DrawAttr.VALIGN_BASELINE : DrawAttr.VALIGN_MIDDLE));
            return (V)v;
        }
        return null;
    }

    @Override
    public boolean matches(CanvasObject other) {
        boolean bl;
        if (other instanceof Text) {
            Text that = (Text)other;
            bl = this.label.equals(that.label);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int matchesHashCode() {
        return this.label.hashCode();
    }

    @Override
    public void paint(Graphics g, HandleGesture gesture) {
        this.label.paint(g);
    }

    @Override
    public Element toSvgElement(Document doc) {
        return SvgCreator.createText(doc, this);
    }

    @Override
    public void translate(int dx, int dy) {
        this.label.setLocation(this.label.getX() + dx, this.label.getY() + dy);
    }

    @Override
    public void updateValue(Attribute<?> attr, Object value) {
        if (attr == DrawAttr.FONT) {
            this.label.setFont((Font)value);
        } else if (attr == DrawAttr.FILL_COLOR) {
            this.label.setColor((Color)value);
        } else if (attr == DrawAttr.HALIGNMENT) {
            Integer intVal = (Integer)((AttributeOption)value).getValue();
            this.label.setHorizontalAlignment(intVal);
        } else if (attr == DrawAttr.VALIGNMENT) {
            Integer intVal = (Integer)((AttributeOption)value).getValue();
            this.label.setVerticalAlignment(intVal);
        }
    }
}

